/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.states;

import cn.boboweike.carrot.tasks.states.StateName;

public class AllowedTaskStateStateChanges {
    private AllowedTaskStateStateChanges() {
    }

    public static boolean isIllegalStateChange(StateName from, StateName to) {
        return !AllowedTaskStateStateChanges.isAllowedStateChange(from, to);
    }

    public static boolean isAllowedStateChange(StateName from, StateName to) {
        switch (from) {
            case SCHEDULED: {
                return to != StateName.PROCESSING;
            }
            case ENQUEUED: {
                return to != StateName.ENQUEUED;
            }
            case PROCESSING: {
                return to == StateName.SUCCEEDED || to == StateName.FAILED || to == StateName.DELETED;
            }
            case FAILED: 
            case SUCCEEDED: {
                return to == StateName.SCHEDULED || to == StateName.ENQUEUED || to == StateName.DELETED;
            }
            case DELETED: {
                return to == StateName.SCHEDULED || to == StateName.ENQUEUED;
            }
        }
        throw new UnsupportedOperationException("Unknown state " + from);
    }
}

