/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.states;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.states.AbstractTaskState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.exceptions.Exceptions;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

public class FailedState
extends AbstractTaskState {
    private String message;
    private String exceptionType;
    private String exceptionMessage;
    private String exceptionCauseType;
    private String exceptionCauseMessage;
    private String stackTrace;
    private boolean doNotRetry;

    protected FailedState() {
        super(StateName.FAILED);
        this.message = null;
        this.exceptionType = null;
        this.exceptionMessage = null;
        this.exceptionCauseType = null;
        this.exceptionCauseMessage = null;
        this.stackTrace = null;
        this.doNotRetry = false;
    }

    public FailedState(String message, Exception exception) {
        super(StateName.FAILED);
        this.message = message;
        this.exceptionType = exception.getClass().getName();
        this.exceptionMessage = exception.getMessage();
        this.exceptionCauseType = FailedState.hasCause(exception) ? exception.getCause().getClass().getName() : null;
        this.exceptionCauseMessage = FailedState.hasCause(exception) ? exception.getCause().getMessage() : null;
        this.stackTrace = Exceptions.getStackTraceAsString(exception);
        this.doNotRetry = FailedState.isProblematicAndDoNotRetry(exception);
    }

    public String getMessage() {
        return this.message;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getExceptionCauseType() {
        return this.exceptionCauseType;
    }

    public String getExceptionCauseMessage() {
        return this.exceptionCauseMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean mustNotRetry() {
        return this.doNotRetry;
    }

    public Exception getException() {
        try {
            Class exceptionClass = ReflectionUtils.toClass(this.getExceptionType());
            if (this.getExceptionCauseType() != null) {
                Class exceptionCauseClass = ReflectionUtils.toClass(this.getExceptionCauseType());
                Exception exceptionCause = this.getExceptionCauseMessage() != null ? (Exception)ReflectionUtils.newInstanceCE(exceptionCauseClass, this.getExceptionCauseMessage()) : (Exception)ReflectionUtils.newInstanceCE(exceptionCauseClass, new Object[0]);
                exceptionCause.setStackTrace(new StackTraceElement[0]);
                return this.getExceptionMessage() != null ? (Exception)ReflectionUtils.newInstanceCE(exceptionClass, this.getExceptionMessage(), exceptionCause) : (Exception)ReflectionUtils.newInstanceCE(exceptionClass, exceptionCause);
            }
            return this.getExceptionMessage() != null ? (Exception)ReflectionUtils.newInstanceCE(exceptionClass, this.getExceptionMessage()) : (Exception)ReflectionUtils.newInstanceCE(exceptionClass, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Could not reconstruct exception for class " + this.getExceptionType() + " and message " + this.getExceptionMessage(), e);
        }
    }

    private static boolean hasCause(Exception exception) {
        return exception.getCause() != null && exception.getCause() != exception;
    }

    private static boolean isProblematicAndDoNotRetry(Exception exception) {
        return exception instanceof CarrotException && ((CarrotException)exception).isProblematicAndDoNotRetry();
    }
}

