/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils;

import cn.boboweike.carrot.scheduling.exceptions.TaskClassNotFoundException;
import cn.boboweike.carrot.scheduling.exceptions.TaskMethodNotFoundException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaskUtils {
    private TaskUtils() {
    }

    public static String getReadableNameFromTaskDetails(TaskDetails taskDetails) {
        Object result = TaskUtils.getTaskClassAndMethodName(taskDetails);
        result = (String)result + "(" + taskDetails.getTaskParameters().stream().map(TaskUtils::getTaskParameterValue).collect(Collectors.joining(",")) + ")";
        return result;
    }

    public static Class<?> getTaskClass(TaskDetails taskDetails) {
        try {
            return ReflectionUtils.toClass(taskDetails.getClassName());
        }
        catch (IllegalArgumentException e) {
            throw new TaskClassNotFoundException(taskDetails);
        }
    }

    public static Method getTaskMethod(TaskDetails taskDetails) {
        return TaskUtils.getTaskMethod(TaskUtils.getTaskClass(taskDetails), taskDetails);
    }

    public static Method getTaskMethod(Class<?> taskClass, TaskDetails taskDetails) {
        return ReflectionUtils.findMethod(taskClass, taskDetails.getMethodName(), taskDetails.getTaskParameterTypes()).orElseThrow(() -> new TaskMethodNotFoundException(taskDetails));
    }

    public static void assertTaskExists(TaskDetails taskDetails) {
        if (!taskDetails.hasStaticFieldName() && TaskUtils.getTaskMethod(taskDetails) == null) {
            throw new IllegalStateException("Task does not exist");
        }
    }

    public static boolean taskExists(String taskSignature) {
        if (taskSignature.startsWith("java.") || taskSignature.startsWith("javax.")) {
            return true;
        }
        try {
            String clazzAndMethod = TaskUtils.getFQClassNameAndMethod(taskSignature);
            String clazzName = TaskUtils.getFQClassName(clazzAndMethod);
            String method = TaskUtils.getMethodName(clazzAndMethod);
            Class clazz = ReflectionUtils.toClass(clazzName);
            Class<?>[] taskParameterTypes = TaskUtils.getParameterTypes(taskSignature);
            return ReflectionUtils.findMethod(clazz, method, taskParameterTypes).isPresent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Optional<cn.boboweike.carrot.tasks.annotations.Task> getTaskAnnotation(TaskDetails taskDetails) {
        return (Optional)ReflectionUtils.cast(TaskUtils.getTaskAnnotations(taskDetails).filter(taskAnnotation -> taskAnnotation.annotationType().equals(cn.boboweike.carrot.tasks.annotations.Task.class)).findFirst());
    }

    public static String getTaskSignature(Task task) {
        return TaskUtils.getTaskSignature(task.getTaskDetails());
    }

    public static String getTaskSignature(TaskDetails taskDetails) {
        Object result = TaskUtils.getTaskClassAndMethodName(taskDetails);
        result = (String)result + "(" + taskDetails.getTaskParameters().stream().map(TaskUtils::getTaskParameterForSignature).collect(Collectors.joining(",")) + ")";
        return result;
    }

    private static Stream<Annotation> getTaskAnnotations(TaskDetails taskDetails) {
        if (taskDetails.getClassName().startsWith("java")) {
            return Stream.empty();
        }
        Method taskMethod = TaskUtils.getTaskMethod(taskDetails);
        return Stream.of(taskMethod.getDeclaredAnnotations());
    }

    private static String getFQClassNameAndMethod(String taskSignature) {
        return taskSignature.substring(0, taskSignature.indexOf("("));
    }

    private static String getFQClassName(String clazzAndMethod) {
        return clazzAndMethod.substring(0, clazzAndMethod.lastIndexOf("."));
    }

    private static String getMethodName(String clazzAndMethod) {
        return clazzAndMethod.substring(clazzAndMethod.lastIndexOf(".") + 1);
    }

    private static Class<?>[] getParameterTypes(String taskSignature) {
        String taskParameterTypesAsString = taskSignature.substring(taskSignature.indexOf("(") + 1, taskSignature.length() - 1);
        if (taskParameterTypesAsString.replaceAll("\\s", "").isEmpty()) {
            return new Class[0];
        }
        Class[] taskParameterTypes = (Class[])Arrays.stream(taskParameterTypesAsString.split(",")).map(ReflectionUtils::toClass).toArray(Class[]::new);
        return taskParameterTypes;
    }

    private static String getTaskParameterForSignature(TaskParameter taskParameter) {
        return taskParameter.getObject() != null ? taskParameter.getObject().getClass().getName() : taskParameter.getClassName();
    }

    private static String getTaskClassAndMethodName(TaskDetails taskDetails) {
        Object result = taskDetails.getClassName();
        Optional<String> staticFieldName = Optional.ofNullable(taskDetails.getStaticFieldName());
        if (staticFieldName.isPresent()) {
            result = (String)result + "." + staticFieldName.get();
        }
        result = (String)result + "." + taskDetails.getMethodName();
        return result;
    }

    private static String getTaskParameterValue(TaskParameter taskParameter) {
        if (taskParameter.getClassName().equals(TaskContext.class.getName())) {
            return TaskContext.class.getSimpleName();
        }
        return taskParameter.getObject().toString();
    }
}

