/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;

public class DurationAdapter
extends TypeAdapter<Duration> {
    public void write(JsonWriter jsonWriter, Duration duration) throws IOException {
        jsonWriter.value((Number)new BigDecimal(duration.getSeconds() + "." + String.format("%09d", duration.getNano())));
    }

    public Duration read(JsonReader jsonReader) throws IOException {
        BigDecimal durationAsSecAndNanoSec = new BigDecimal(jsonReader.nextString());
        return Duration.ofSeconds(durationAsSecAndNanoSec.longValue(), durationAsSecAndNanoSec.remainder(BigDecimal.ONE).movePointRight(durationAsSecAndNanoSec.scale()).abs().longValue());
    }
}

