/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper.gson;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.TaskParameterJsonMapperException;
import cn.boboweike.carrot.utils.mapper.gson.ClassNameObjectTypeAdapter;
import cn.boboweike.carrot.utils.mapper.gson.DurationAdapter;
import cn.boboweike.carrot.utils.mapper.gson.InstantAdapter;
import cn.boboweike.carrot.utils.mapper.gson.PathAdapter;
import cn.boboweike.carrot.utils.mapper.gson.RuntimeClassNameTypeAdapterFactory;
import cn.boboweike.carrot.utils.mapper.gson.TaskParameterDeserializer;
import cn.boboweike.carrot.utils.metadata.VersionRetriever;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class GsonJsonMapper
implements JsonMapper {
    private final Gson gson;

    public GsonJsonMapper() {
        this(new GsonBuilder());
    }

    public GsonJsonMapper(GsonBuilder gsonBuilder) {
        this.gson = this.initGson(gsonBuilder);
        this.fixGsonNotBeingExtensible(this.gson);
    }

    public GsonJsonMapper(Gson gson) {
        this.gson = gson;
        this.fixGsonNotBeingExtensible(gson);
    }

    protected Gson initGson(GsonBuilder gsonBuilder) {
        return gsonBuilder.serializeNulls().registerTypeAdapterFactory(RuntimeClassNameTypeAdapterFactory.of(TaskState.class)).registerTypeAdapterFactory(RuntimeClassNameTypeAdapterFactory.of(Map.class)).registerTypeAdapterFactory(RuntimeClassNameTypeAdapterFactory.of(TaskContext.Metadata.class)).registerTypeHierarchyAdapter(Path.class, (Object)new PathAdapter().nullSafe()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter().nullSafe()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(TaskParameter.class, (Object)new TaskParameterDeserializer()).create();
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.gson.toJson(object);
        }
        catch (Exception e) {
            throw new TaskParameterJsonMapperException("The task parameters are not serializable.", e);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object object) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            this.gson.toJson(object, (Appendable)writer);
        }
        catch (IOException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    @Override
    public <T> T deserialize(String serializedObjectAsString, Class<T> clazz) {
        return (T)this.gson.fromJson(serializedObjectAsString, clazz);
    }

    private void fixGsonNotBeingExtensible(Gson gson) {
        try {
            Field factories = ReflectionUtils.getField(Gson.class, "factories");
            ReflectionUtils.makeAccessible(factories);
            ArrayList<TypeAdapterFactory> o = new ArrayList<TypeAdapterFactory>((Collection)factories.get(gson));
            if (!o.get(1).getClass().getName().contains("ObjectTypeAdapter")) {
                throw CarrotException.shouldNotHappenException(String.format("It looks like you are running a Gson version (%s) which is not compatible with Carrot", VersionRetriever.getVersion(Gson.class)));
            }
            o.set(1, ClassNameObjectTypeAdapter.FACTORY);
            factories.set(gson, Collections.unmodifiableList(o));
        }
        catch (ReflectiveOperationException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }
}

