/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper.gson;

import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.TaskParameterNotDeserializableException;
import cn.boboweike.carrot.utils.mapper.JsonMapperUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;

public class TaskParameterDeserializer
implements JsonDeserializer<TaskParameter> {
    public TaskParameter deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String taskParameterMethodType = jsonObject.get("className").getAsString();
        String taskParameterActualType = jsonObject.has("actualClassName") ? jsonObject.get("actualClassName").getAsString() : null;
        try {
            return new TaskParameter(taskParameterMethodType, this.deserializeToObject(context, JsonMapperUtils.getActualClassName(taskParameterMethodType, taskParameterActualType), jsonObject.get("object")));
        }
        catch (Exception e) {
            return new TaskParameter(new TaskParameterNotDeserializableException(JsonMapperUtils.getActualClassName(taskParameterMethodType, taskParameterActualType), e.getMessage()));
        }
    }

    private Object deserializeToObject(JsonDeserializationContext context, String type, JsonElement jsonElement) {
        return context.deserialize(jsonElement, ReflectionUtils.toClass(type));
    }
}

