/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper.jackson;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.TaskParameterJsonMapperException;
import cn.boboweike.carrot.utils.mapper.jackson.modules.CarrotModule;
import cn.boboweike.carrot.utils.mapper.jackson.modules.CarrotTimeModule;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class JacksonJsonMapper
implements JsonMapper {
    private final ObjectMapper objectMapper;
    private static final Predicate<Module> isJSR310JavaTimeModule = m -> "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule".equals(m.getTypeId());
    private static final Predicate<Module> isCarrotModule = m -> "cn.boboweike.carrot.utils.mapper.jackson.modules.CarrotModule".equals(m.getTypeId());

    public JacksonJsonMapper() {
        this(true);
    }

    public JacksonJsonMapper(boolean moduleAutoDiscover) {
        this(new ObjectMapper(), moduleAutoDiscover);
    }

    public JacksonJsonMapper(ObjectMapper objectMapper) {
        this(objectMapper, true);
    }

    public JacksonJsonMapper(ObjectMapper objectMapper, boolean moduleAutoDiscover) {
        this.objectMapper = this.initObjectMapper(objectMapper, moduleAutoDiscover);
    }

    protected ObjectMapper initObjectMapper(ObjectMapper objectMapper, boolean moduleAutoDiscover) {
        return objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).registerModules(JacksonJsonMapper.findModules(moduleAutoDiscover)).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ")).activateDefaultTypingAsProperty((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS, "@class");
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new TaskParameterJsonMapperException("The task parameters are not serializable.", e);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object object) {
        try {
            this.objectMapper.writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    @Override
    public <T> T deserialize(String serializedObjectAsString, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(serializedObjectAsString, clazz);
        }
        catch (InvalidDefinitionException e) {
            throw CarrotException.configurationException("Did you register all necessary Jackson Modules?", e);
        }
        catch (IOException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    private static List<Module> findModules(boolean moduleAutoDiscover) {
        List modules;
        List list = modules = moduleAutoDiscover ? ObjectMapper.findModules() : new ArrayList();
        if (modules.stream().noneMatch(isJSR310JavaTimeModule)) {
            modules.add(new CarrotTimeModule());
        }
        if (modules.stream().noneMatch(isCarrotModule)) {
            modules.add(new CarrotModule());
        }
        return modules;
    }
}

