/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.mapper.jackson.modules;

import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.TaskParameterNotDeserializableException;
import cn.boboweike.carrot.utils.mapper.JsonMapperUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

public class TaskParameterDeserializer
extends StdDeserializer<TaskParameter> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected TaskParameterDeserializer() {
        super(TaskParameter.class);
    }

    public TaskParameter deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String className = node.get("className").asText();
        String actualClassName = node.has("actualClassName") ? node.get("actualClassName").asText() : null;
        JsonNode objectJsonNode = node.get("object");
        if (Path.class.getName().equals(className)) {
            return new TaskParameter(className, (Object)Paths.get(objectJsonNode.asText().replace("file:", ""), new String[0]));
        }
        return this.getTaskParameter(jsonParser, className, actualClassName, objectJsonNode);
    }

    private TaskParameter getTaskParameter(JsonParser jsonParser, String className, String actualClassName, JsonNode objectJsonNode) throws JsonProcessingException {
        try {
            Class valueType = ReflectionUtils.toClass(TaskParameterDeserializer.getActualClassName(className, actualClassName));
            if (objectJsonNode.isArray() && !Collection.class.isAssignableFrom(valueType)) {
                JsonNode jsonNodeInArray = objectJsonNode.get(1);
                Object object = jsonParser.getCodec().treeToValue((TreeNode)jsonNodeInArray, valueType);
                return new TaskParameter(className, object);
            }
            try {
                Object object = jsonParser.getCodec().treeToValue((TreeNode)objectJsonNode, valueType);
                return new TaskParameter(className, object);
            }
            catch (MismatchedInputException e) {
                if (valueType.isEnum()) {
                    ArrayNode arrayNode = (ArrayNode)jsonParser.getCodec().createArrayNode();
                    arrayNode.add(valueType.getName());
                    arrayNode.add(objectJsonNode);
                    Object object = jsonParser.getCodec().treeToValue((TreeNode)arrayNode, valueType);
                    return new TaskParameter(className, object);
                }
                Object object = this.objectMapper.treeToValue((TreeNode)objectJsonNode, valueType);
                return new TaskParameter(className, object);
            }
        }
        catch (Exception e) {
            return new TaskParameter(new TaskParameterNotDeserializableException(TaskParameterDeserializer.getActualClassName(className, actualClassName), e.getMessage()));
        }
    }

    public static String getActualClassName(String methodClassName, String actualClassName) {
        return JsonMapperUtils.getActualClassName(methodClassName, actualClassName, "sun.", "com.sun.");
    }
}

