/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import cn.boboweike.carrot.utils.reflection.autobox.BooleanTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.DoubleTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.DurationTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.EnumAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.FloatTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.InstantTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.IntegerTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.LongTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.StringTypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.TypeAutoboxer;
import cn.boboweike.carrot.utils.reflection.autobox.UUIDTypeAutoboxer;
import java.util.Arrays;
import java.util.List;

public class Autoboxer {
    private static final List<TypeAutoboxer> autoboxers = Arrays.asList(new BooleanTypeAutoboxer(), new InstantTypeAutoboxer(), new IntegerTypeAutoboxer(), new LongTypeAutoboxer(), new DoubleTypeAutoboxer(), new FloatTypeAutoboxer(), new StringTypeAutoboxer(), new UUIDTypeAutoboxer(), new EnumAutoboxer(), new DurationTypeAutoboxer());

    private Autoboxer() {
    }

    public static <T> T autobox(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return ReflectionUtils.cast(value);
        }
        return ReflectionUtils.cast(autoboxers.stream().filter(autoboxer -> autoboxer.supports(type)).findFirst().map(autoboxer -> autoboxer.autobox(value, type)).orElseThrow(() -> new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), type.getName()))));
    }
}

