/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import cn.boboweike.carrot.utils.reflection.autobox.TypeAutoboxer;
import java.sql.Clob;
import java.sql.SQLException;

public class StringTypeAutoboxer
implements TypeAutoboxer<String> {
    @Override
    public boolean supports(Class<?> type) {
        return String.class.equals(type);
    }

    @Override
    public String autobox(Object value, Class<String> type) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Clob) {
            try {
                Clob clob = (Clob)value;
                return (String)ReflectionUtils.cast(clob.getSubString(1L, (int)clob.length()));
            }
            catch (SQLException e) {
                throw CarrotException.shouldNotHappenException(e);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), String.class.getName()));
    }
}

