/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import cn.boboweike.carrot.utils.reflection.autobox.TypeAutoboxer;
import java.util.UUID;

public class UUIDTypeAutoboxer
implements TypeAutoboxer<UUID> {
    @Override
    public boolean supports(Class<?> type) {
        return UUID.class.equals(type);
    }

    @Override
    public UUID autobox(Object value, Class<UUID> type) {
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return (UUID)ReflectionUtils.cast(UUID.fromString((String)value));
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), UUID.class.getName()));
    }
}

