/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.resilience;

import cn.boboweike.carrot.utils.resilience.Lock;
import cn.boboweike.carrot.utils.resilience.Lockable;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class MultiLock
implements Closeable {
    private final Collection<Lock> locks;

    public MultiLock(Lockable ... lockables) {
        this(Arrays.asList(lockables));
    }

    public MultiLock(Collection<? extends Lockable> lockables) {
        this.locks = lockables.parallelStream().map(Lockable::lock).collect(Collectors.toList());
    }

    public void unlock() {
        this.locks.forEach(Lock::unlock);
    }

    @Override
    public void close() {
        this.unlock();
    }
}

