/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.resilience;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.locks.ReentrantLock;

public class RateLimiter {
    public static final Duration SECOND = Duration.ofSeconds(1L);
    public static final Duration MINUTE = Duration.ofMinutes(1L);
    private final ReentrantLock lock = new ReentrantLock();
    private final Duration perDuration;
    private volatile Instant lastAllowed;

    private RateLimiter(Duration perDuration, Instant lastAllowed) {
        this.perDuration = perDuration;
        this.lastAllowed = lastAllowed;
    }

    public boolean isRateLimited() {
        return !this.isAllowed();
    }

    public boolean isAllowed() {
        if (this.lock.tryLock()) {
            try {
                if (this.lastAllowed.plus(this.perDuration).isBefore(Instant.now())) {
                    this.lastAllowed = Instant.now();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    public static class Builder {
        private int amount;

        public static Builder rateLimit() {
            return new Builder();
        }

        public Builder at1Request() {
            return this.atRequests(1);
        }

        public Builder at2Requests() {
            return this.atRequests(2);
        }

        public Builder at5Requests() {
            return this.atRequests(5);
        }

        public Builder at10Requests() {
            return this.atRequests(10);
        }

        public Builder atRequests(int amount) {
            this.amount = amount;
            return this;
        }

        public RateLimiter per(int time, ChronoUnit unit) {
            return this.per(Duration.of(time, unit));
        }

        public RateLimiter per(Duration duration) {
            Duration perDuration = duration.dividedBy(this.amount);
            Instant lastAllowed = Instant.now().minus(duration);
            return new RateLimiter(perDuration, lastAllowed);
        }

        public RateLimiter withoutLimits() {
            return new RateLimiter(Duration.ofNanos(1L), Instant.now());
        }
    }
}

