/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.utils.resources;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.utils.resources.FileSystemProvider;
import cn.boboweike.carrot.utils.resources.JarFileSystemProvider;
import cn.boboweike.carrot.utils.resources.PathFileSystemProvider;
import cn.boboweike.carrot.utils.resources.ResourcesFileSystemProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceProvider
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathResourceProvider.class);
    private static final Map<String, FileSystemProvider> fileSystemProviders = new HashMap<String, FileSystemProvider>();
    private static final ReentrantLock lock = new ReentrantLock();

    public ClassPathResourceProvider() {
        try {
            lock.tryLock(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unable to open lock. Make sure the ClassPathResourceProvider is used inside a try-with-resources block?", e);
        }
    }

    public Stream<Path> listAllChildrenOnClasspath(Class<?> clazz, String ... subFolder) {
        try {
            return this.toPathsOnClasspath(clazz, subFolder).flatMap(this::listAllChildrenOnClasspath);
        }
        catch (Exception e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    private Stream<Path> toPathsOnClasspath(Class<?> clazz, String ... subFolders) {
        return this.toPathsOnClasspath(clazz.getPackage(), subFolders);
    }

    private Stream<Path> toPathsOnClasspath(Package pkg, String ... subFolders) {
        String joinedSubfolders = String.join((CharSequence)"/", subFolders);
        if (joinedSubfolders.startsWith("/")) {
            return this.toUrls(joinedSubfolders.substring(1)).map(this::toPath);
        }
        return this.toUrls(pkg.getName().replace(".", "/") + "/" + joinedSubfolders).map(this::toPath);
    }

    private Stream<URL> toUrls(String folder) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources(folder);
            return Collections.list(resources).stream();
        }
        catch (IOException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    private Path toPath(URL url) {
        try {
            URI uri = url.toURI();
            if ("wsjar".equals(uri.getScheme())) {
                uri = new URI(uri.toString().replace("wsjar", "jar"));
            }
            FileSystemProvider fileSystemProvider = this.getFileSystemProvider(uri);
            return fileSystemProvider.toPath(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    private Stream<Path> listAllChildrenOnClasspath(Path rootPath) {
        try {
            if (rootPath == null) {
                return Stream.empty();
            }
            if (Files.notExists(rootPath, new LinkOption[0])) {
                return Stream.empty();
            }
            return Files.list(rootPath);
        }
        catch (IOException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }

    private FileSystemProvider getFileSystemProvider(URI uri) {
        return fileSystemProviders.computeIfAbsent(uri.getScheme(), this::getFileSystemProviderByScheme);
    }

    @Override
    public void close() throws IllegalStateException {
        try {
            for (FileSystemProvider fileSystemProvider : fileSystemProviders.values()) {
                this.closeFileSystemProvider(fileSystemProvider);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not close FileSystemProvider", (Throwable)e);
            throw new IllegalStateException("Could not close FileSystemProvider", e);
        }
        finally {
            fileSystemProviders.clear();
            lock.unlock();
        }
    }

    private FileSystemProvider getFileSystemProviderByScheme(String scheme) {
        switch (scheme) {
            case "jar": {
                return new JarFileSystemProvider();
            }
            case "resource": {
                return new ResourcesFileSystemProvider();
            }
            case "file": {
                return new PathFileSystemProvider();
            }
        }
        throw new IllegalArgumentException("Unknown FileSystem required " + scheme);
    }

    private void closeFileSystemProvider(FileSystemProvider fileSystemProvider) throws IOException {
        try {
            fileSystemProvider.close();
        }
        catch (ClosedFileSystemException closedFileSystemException) {
            // empty catch block
        }
    }
}

