/*
 * Decompiled with CFR 0.152.
 */
package cn.buk.api.wechat.dao;

import cn.buk.api.wechat.dao.AbstractDao;
import cn.buk.api.wechat.dao.WeixinDao;
import cn.buk.api.wechat.entity.Token;
import cn.buk.api.wechat.entity.WeixinAccessTime;
import cn.buk.api.wechat.entity.WeixinCustomMenu;
import cn.buk.api.wechat.entity.WeixinMaterial;
import cn.buk.api.wechat.entity.WeixinMaterial_;
import cn.buk.api.wechat.entity.WeixinOauthToken;
import cn.buk.api.wechat.entity.WeixinTemplate;
import cn.buk.api.wechat.entity.WeixinUser;
import cn.buk.api.wechat.entity.WeixinUser_;
import cn.buk.common.CommonSearchCriteria;
import cn.buk.common.Page;
import cn.buk.util.DateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Component;

@Component
public class WeixinDaoImpl
extends AbstractDao
implements WeixinDao {
    @Override
    public int createWeixinOauthToken(WeixinOauthToken token) {
        int retCode = this.persist(token);
        return retCode == 1 ? token.getId() : retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createWeixinAccessTime(String weixinOpenId, int weixinId) {
        int retCode = 0;
        try (EntityManager em = this.createEntityManager();){
            WeixinAccessTime accessTime;
            List accessTimes = em.createQuery("select o from WeixinAccessTime o  where o.weixinOpenId = :weixinOpenId and o.weixinId = :weixinId ").setParameter("weixinOpenId", (Object)weixinOpenId).setParameter("weixinId", (Object)weixinId).getResultList();
            em.getTransaction().begin();
            if (accessTimes.size() > 0) {
                accessTime = (WeixinAccessTime)accessTimes.get(0);
                accessTime.setAccessTime(DateUtil.getCurDateTime());
                em.merge((Object)accessTime);
            } else {
                accessTime = new WeixinAccessTime();
                accessTime.setWeixinOpenId(weixinOpenId);
                accessTime.setAccessTime(DateUtil.getCurDateTime());
                accessTime.setWeixinId(weixinId);
                em.persist((Object)accessTime);
            }
            em.getTransaction().commit();
            retCode = accessTime.getId();
        }
        return retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token retrieveWeixinToken(int weixinId, int weixinType) {
        try (EntityManager em = this.createEntityManager();){
            List tokens = em.createQuery("select o from Token o where o.weixinId = :weixinId and o.weixinType = :weixinType order by o.id desc").setParameter("weixinId", (Object)weixinId).setParameter("weixinType", (Object)weixinType).setMaxResults(1).getResultList();
            if (tokens == null || tokens.size() == 0) {
                Token token = null;
                return token;
            }
            Token token = (Token)tokens.get(0);
            return token;
        }
    }

    @Override
    public int createWeixinToken(Token token) {
        int retCode = this.persist(token);
        return retCode == 1 ? token.getId() : retCode;
    }

    @Override
    public int createWeixinUser(WeixinUser user) {
        int retCode = this.persist(user);
        return retCode == 1 ? user.getId() : retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WeixinUser> searchSubscribers(int enterpriseId, CommonSearchCriteria sc) {
        List users = null;
        try (EntityManager em = this.createEntityManager();){
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(WeixinUser.class);
            Root root = cq.from(WeixinUser.class);
            Predicate where = cb.conjunction();
            where = cb.and((Expression)where, (Expression)cb.equal((Expression)root.get(WeixinUser_.ownerId), (Object)enterpriseId));
            cq.where((Expression)where);
            ArrayList<Order> orderByes = new ArrayList<Order>();
            orderByes.add(cb.asc((Expression)root.get("subscribe_time")));
            cq.orderBy(orderByes);
            CriteriaQuery countQuery = cb.createQuery(Long.class);
            Root countRoot = countQuery.from(WeixinUser.class);
            Predicate where0 = cb.conjunction();
            where0 = cb.and((Expression)where0, (Expression)cb.equal((Expression)countRoot.get(WeixinUser_.ownerId), (Object)enterpriseId));
            countQuery.select((Selection)cb.count((Expression)countRoot)).where((Expression)where0);
            Long count = (Long)em.createQuery(countQuery).getSingleResult();
            int maxResults = count.intValue();
            if (maxResults > 0) {
                Page page = sc.getPage();
                page.setRowCount(maxResults);
                int i = (page.getPageNo() - 1) * page.getPageSize();
                if (i < 0) {
                    i = 0;
                }
                try {
                    users = em.createQuery(cq).setFirstResult(i).setMaxResults(page.getPageSize()).getResultList();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (users == null) {
            users = new ArrayList();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WeixinUser searchWeixinUser(int enterpriseId, String openId) {
        try (EntityManager em = this.createEntityManager();){
            List users = em.createQuery("select o from WeixinUser o where o.ownerId = :enterpriseId and o.weixinOpenId = :openId").setParameter("enterpriseId", (Object)enterpriseId).setParameter("openId", (Object)openId).getResultList();
            WeixinUser weixinUser = users.size() > 0 ? (WeixinUser)users.get(0) : null;
            return weixinUser;
        }
    }

    @Override
    public int createWeixinTemplate(WeixinTemplate tpl) {
        int retCode = this.persist(tpl);
        return retCode == 1 ? tpl.getId() : retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WeixinTemplate searchWeixinTemplate(int ownerId, String id) {
        try (EntityManager em = this.createEntityManager();){
            List list = em.createQuery("select o from WeixinTemplate o where o.ownerId = :ownerId and o.businessId = :id").setParameter("ownerId", (Object)ownerId).setParameter("id", (Object)id).getResultList();
            WeixinTemplate weixinTemplate = list.size() > 0 ? (WeixinTemplate)list.get(0) : null;
            return weixinTemplate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WeixinTemplate> searchWeixinTemplates(int ownerId) {
        try (EntityManager em = this.createEntityManager();){
            List list;
            List list2 = list = em.createQuery("select o from WeixinTemplate o where o.ownerId = :ownerId ").setParameter("ownerId", (Object)ownerId).getResultList();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WeixinCustomMenu> searchCustomMenus(int ownerId) {
        try (EntityManager em = this.createEntityManager();){
            List list = em.createQuery("select o from WeixinCustomMenu o where o.enterpriseId = :enterpriseId order by o.level, o.parentId, o.id").setParameter("enterpriseId", (Object)ownerId).getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteCustomMenu(int ownerId, int id) {
        int retCode = 0;
        try (EntityManager em = this.createEntityManager();){
            em.getTransaction().begin();
            retCode = em.createQuery("delete from WeixinCustomMenu o where o.enterpriseId = :enterpriseId and o.id = :id").setParameter("enterpriseId", (Object)ownerId).setParameter("id", (Object)id).executeUpdate();
            em.getTransaction().commit();
        }
        return retCode;
    }

    @Override
    public int createCustomMenu(WeixinCustomMenu o) {
        int retCode = this.persist(o);
        return retCode == 1 ? o.getId() : retCode;
    }

    @Override
    public int createWeixinMaterial(WeixinMaterial o) {
        int retCode = this.persist(o);
        return retCode == 1 ? o.getId() : retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateWeixinMaterial(WeixinMaterial wm) {
        int retCode;
        try (EntityManager em = this.createEntityManager();){
            em.getTransaction().begin();
            em.merge((Object)wm);
            em.getTransaction().commit();
            retCode = 1;
        }
        return retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WeixinMaterial> searchMaterials(int enterpriseId, CommonSearchCriteria sc) {
        List results = null;
        try (EntityManager em = this.createEntityManager();){
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(WeixinMaterial.class);
            Root root = cq.from(WeixinMaterial.class);
            Predicate where = cb.conjunction();
            where = cb.and((Expression)where, (Expression)cb.equal((Expression)root.get(WeixinMaterial_.ownerId), (Object)enterpriseId));
            cq.where((Expression)where);
            ArrayList<Order> orderByes = new ArrayList<Order>();
            orderByes.add(cb.desc((Expression)root.get("id")));
            cq.orderBy(orderByes);
            CriteriaQuery countQuery = cb.createQuery(Long.class);
            Root countRoot = countQuery.from(WeixinMaterial.class);
            Predicate where0 = cb.conjunction();
            where0 = cb.and((Expression)where0, (Expression)cb.equal((Expression)countRoot.get(WeixinMaterial_.ownerId), (Object)enterpriseId));
            countQuery.select((Selection)cb.count((Expression)countRoot)).where((Expression)where0);
            Long count = (Long)em.createQuery(countQuery).getSingleResult();
            int maxResults = count.intValue();
            if (maxResults > 0) {
                Page page = sc.getPage();
                page.setRowCount(maxResults);
                try {
                    results = em.createQuery(cq).setFirstResult(page.getFirstPosition()).setMaxResults(page.getPageSize()).getResultList();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (results == null) {
            results = new ArrayList();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WeixinMaterial> searchMaterials(int enterpriseId, String mediaId) {
        try (EntityManager em = this.createEntityManager();){
            List list = em.createQuery("select o from WeixinMaterial o where o.ownerId = :ownerId and o.mediaId = :mediaId").setParameter("ownerId", (Object)enterpriseId).setParameter("mediaId", (Object)mediaId).getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WeixinMaterial searchWeixinMaterial(int weixinId, int id) {
        try (EntityManager em = this.createEntityManager();){
            WeixinMaterial o = (WeixinMaterial)em.find(WeixinMaterial.class, (Object)id);
            if (o != null && o.getOwnerId() != weixinId) {
                WeixinMaterial weixinMaterial = null;
                return weixinMaterial;
            }
            WeixinMaterial weixinMaterial = o;
            return weixinMaterial;
        }
    }
}

