/*
 * Decompiled with CFR 0.152.
 */
package cn.buk.api.wechat.service;

import cn.buk.api.wechat.dao.WeixinDao;
import cn.buk.api.wechat.dto.JsSdkParam;
import cn.buk.api.wechat.dto.WeixinMediasRequest;
import cn.buk.api.wechat.dto.WeixinMenu;
import cn.buk.api.wechat.dto.WeixinMenuItem;
import cn.buk.api.wechat.dto.WeixinUserInfo;
import cn.buk.api.wechat.dto.WxArticle;
import cn.buk.api.wechat.dto.WxData;
import cn.buk.api.wechat.dto.WxMaterialSummary;
import cn.buk.api.wechat.dto.WxMaterials;
import cn.buk.api.wechat.dto.WxMediaRequest;
import cn.buk.api.wechat.dto.WxMediaResponse;
import cn.buk.api.wechat.dto.WxNews;
import cn.buk.api.wechat.dto.WxNewsRequest;
import cn.buk.api.wechat.dto.WxTemplate;
import cn.buk.api.wechat.dto.WxTemplateList;
import cn.buk.api.wechat.dto.WxTemplateSend;
import cn.buk.api.wechat.entity.Token;
import cn.buk.api.wechat.entity.WeixinCustomMenu;
import cn.buk.api.wechat.entity.WeixinMaterial;
import cn.buk.api.wechat.entity.WeixinOauthToken;
import cn.buk.api.wechat.entity.WeixinTemplate;
import cn.buk.api.wechat.entity.WeixinUser;
import cn.buk.api.wechat.service.WeixinService;
import cn.buk.api.wechat.util.EncoderHandler;
import cn.buk.api.wechat.util.HttpUtil;
import cn.buk.api.wechat.util.SignUtil;
import cn.buk.common.CommonSearchCriteria;
import cn.buk.util.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WeixinServiceImpl
implements WeixinService {
    private static Logger logger = Logger.getLogger(WeixinServiceImpl.class);
    private static final String WX_CUSTOM_MSGTYPE_TEXT = "text";
    private static final String WX_CUSTOM_MSGTYPE_NEWS = "news";
    private static final String URL = "http://www.csdn.net";
    private static final String ECODING = "UTF-8";
    private static final String IMGURL_REG = "<img.*src=(.*?)[^>]*?>";
    private static final String IMGSRC_REG = "http:\"?(.*?)(\"|>|\\s+)";
    private static final String DOWNLOAD_DIR = "/temp";
    @Value(value="${Weixin_Id}")
    private int weixinId;
    @Value(value="${Weixin_AppId}")
    private String appId;
    @Value(value="${Weixin_AppSecret}")
    private String appSecret;
    @Value(value="${Weixin_Token}")
    private String weixinToken;
    @Autowired
    private WeixinDao weixinDao;

    public static String postFile(String url, String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String result = null;
        try {
            URL url1 = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)url1.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Cache-Control", "no-cache");
            String boundary = "-----------------------------" + System.currentTimeMillis();
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream output = conn.getOutputStream();
            output.write(("--" + boundary + "\r\n").getBytes());
            output.write(String.format("Content-Disposition: form-data; name=\"media\"; filename=\"%s\"\r\n", file.getName()).getBytes(ECODING));
            output.write("Content-Type: image/jpeg \r\n\r\n".getBytes());
            byte[] data = new byte[1024];
            int len = 0;
            FileInputStream input = new FileInputStream(file);
            while ((len = input.read(data)) > -1) {
                output.write(data, 0, len);
            }
            output.write(("\r\n--" + boundary + "\r\n\r\n").getBytes());
            output.flush();
            output.close();
            input.close();
            InputStream resp = conn.getInputStream();
            StringBuffer sb = new StringBuffer();
            while ((len = resp.read(data)) > -1) {
                sb.append(new String(data, 0, len, "utf-8"));
            }
            resp.close();
            result = sb.toString();
        }
        catch (ClientProtocolException e) {
            logger.error((Object)"postFile\uff0c\u4e0d\u652f\u6301http\u534f\u8bae", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"postFile\u6570\u636e\u4f20\u8f93\u5931\u8d25", (Throwable)e);
        }
        System.out.println(result);
        return result;
    }

    private String getHTML(String url) throws Exception {
        URL uri = new URL(url);
        URLConnection connection = uri.openConnection();
        InputStream in = connection.getInputStream();
        byte[] buf = new byte[1024];
        int length = 0;
        StringBuffer sb = new StringBuffer();
        while ((length = in.read(buf, 0, buf.length)) > 0) {
            sb.append(new String(buf, ECODING));
        }
        in.close();
        return sb.toString();
    }

    private List<String> getImageUrl(String HTML) {
        Matcher matcher = Pattern.compile(IMGURL_REG).matcher(HTML);
        ArrayList<String> listImgUrl = new ArrayList<String>();
        while (matcher.find()) {
            listImgUrl.add(matcher.group());
        }
        return listImgUrl;
    }

    private List<String> getImageSrc(List<String> listImageUrl) {
        ArrayList<String> listImgSrc = new ArrayList<String>();
        for (String image : listImageUrl) {
            Matcher matcher = Pattern.compile(IMGSRC_REG).matcher(image);
            while (matcher.find()) {
                listImgSrc.add(matcher.group().substring(0, matcher.group().length() - 1));
            }
        }
        return listImgSrc;
    }

    private void Download(List<String> listImgSrc) {
        try {
            for (String url : listImgSrc) {
                String imageName = url.substring(url.lastIndexOf("/") + 1, url.length());
                URL uri = new URL(url);
                InputStream in = uri.openStream();
                FileOutputStream fo = new FileOutputStream(new File(imageName));
                byte[] buf = new byte[1024];
                int length = 0;
                System.out.println("\u5f00\u59cb\u4e0b\u8f7d:" + url);
                while ((length = in.read(buf, 0, buf.length)) != -1) {
                    fo.write(buf, 0, length);
                }
                in.close();
                fo.close();
                System.out.println(imageName + "\u4e0b\u8f7d\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            System.out.println("\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    @Override
    public String getAppid() {
        return this.appId;
    }

    @Override
    public JsSdkParam getJsSdkConfig(String jsapi_url) {
        JsSdkParam jsapiParam = new JsSdkParam();
        jsapiParam.setAppId(this.appId);
        Token ticket = this.getJsSdkTicket();
        Map<String, String> ret = SignUtil.sign(ticket.getAccess_token(), jsapi_url);
        jsapiParam.setTimestamp(ret.get("timestamp"));
        jsapiParam.setNonceStr(ret.get("nonceStr"));
        jsapiParam.setSignature(ret.get("signature"));
        jsapiParam.setUrl(jsapi_url);
        return jsapiParam;
    }

    @Override
    public WeixinOauthToken getOauthToken(String weixinOauthCode) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("appid", this.appId));
        params.add((NameValuePair)new BasicNameValuePair("secret", this.appSecret));
        params.add((NameValuePair)new BasicNameValuePair("code", weixinOauthCode));
        params.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        String jsonStr = HttpUtil.getUrl("https://api.weixin.qq.com/sns/oauth2/access_token?", params);
        JSONObject param = JSON.parseObject((String)jsonStr);
        if (param.get((Object)"errcode") == null) {
            WeixinOauthToken token = new WeixinOauthToken();
            token.setAccess_token((String)param.get((Object)"access_token"));
            token.setRefresh_token((String)param.get((Object)"refresh_token"));
            token.setOpenid((String)param.get((Object)"openid"));
            token.setScope((String)param.get((Object)"scope"));
            token.setExpires_in(((Integer)param.get((Object)"expires_in")).intValue());
            token.setWeixinId(this.weixinId);
            this.weixinDao.createWeixinOauthToken(token);
            return token;
        }
        return null;
    }

    public void testImgUrl() {
        String HTML = null;
        try {
            HTML = this.getHTML(URL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> imgUrl = this.getImageUrl(HTML);
        List<String> imgSrc = this.getImageSrc(imgUrl);
    }

    @Override
    public int getWeixinId() {
        return this.weixinId;
    }

    @Override
    public boolean verifyWeixinSource(String signature, String timestamp, String nonce) {
        try {
            ArrayList<String> al = new ArrayList<String>();
            al.add(this.weixinToken);
            al.add(timestamp);
            al.add(nonce);
            Collections.sort(al);
            String allString = "";
            for (String temp : al) {
                allString = allString + temp;
            }
            String mySignature = EncoderHandler.encode("SHA1", allString);
            return mySignature.compareTo(signature) == 0;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            return false;
        }
    }

    @Override
    public String getCustomMenu() {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get?";
        Token token = this.getToken();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("access_token", token.getAccess_token()));
        String jsonStr = HttpUtil.getUrl("https://api.weixin.qq.com/cgi-bin/menu/get?", params);
        try {
            jsonStr = new String(jsonStr.getBytes("ISO-8859-1"), ECODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return jsonStr;
    }

    @Override
    public String createCustomMenu() {
        String url;
        WeixinMenu wm = new WeixinMenu();
        List menus = this.weixinDao.searchCustomMenus(this.weixinId);
        for (WeixinCustomMenu m1 : menus) {
            if (m1.getLevel() != 1) continue;
            WeixinMenuItem dto = new WeixinMenuItem();
            wm.getButton().add(dto);
            dto.setName(m1.getName());
            for (WeixinCustomMenu m2 : menus) {
                if (m2.getLevel() != 2 || m2.getParentId() != m1.getId()) continue;
                if (dto.getSub_button() == null) {
                    dto.setSub_button(new ArrayList<WeixinMenuItem>());
                }
                WeixinMenuItem dto2 = new WeixinMenuItem();
                dto.getSub_button().add(dto2);
                dto2.setName(m2.getName());
                if (m2.getType().equalsIgnoreCase("VIEW")) {
                    dto2.setType(m2.getType());
                    url = this.buildUrlInWeixin(m2.getUrl());
                    dto2.setUrl(url);
                    continue;
                }
                if (!m2.getType().equalsIgnoreCase("click")) continue;
                dto2.setType(m2.getType());
                dto2.setKey(m2.getKey());
            }
        }
        String jsonBody = JSON.toJSON((Object)wm).toString();
        logger.info((Object)jsonBody);
        Token token = this.getToken();
        url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + token.getAccess_token();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("body", jsonBody));
        return HttpUtil.postUrl(url, jsonBody);
    }

    private synchronized Token getToken() {
        Token token = this.weixinDao.retrieveWeixinToken(this.weixinId, 0);
        if (token == null || DateUtil.getPastSeconds((Date)token.getCreateTime()) >= token.getExpires_in()) {
            token = this.refreshWeixinToken();
        }
        return token;
    }

    private synchronized Token getJsSdkTicket() {
        Token token = this.weixinDao.retrieveWeixinToken(this.weixinId, 100);
        if (token == null || DateUtil.getPastSeconds((Date)token.getCreateTime()) >= token.getExpires_in()) {
            token = this.refreshWeixinJsSdkTicket();
        }
        return token;
    }

    private Token refreshWeixinToken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token?";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credential"));
        params.add((NameValuePair)new BasicNameValuePair("appid", this.appId));
        params.add((NameValuePair)new BasicNameValuePair("secret", this.appSecret));
        String jsonStr = HttpUtil.getUrl("https://api.weixin.qq.com/cgi-bin/token?", params);
        JSONObject param = (JSONObject)JSON.parse((String)jsonStr);
        Token token = new Token();
        token.setAccess_token((String)param.get((Object)"access_token"));
        token.setExpires_in(((Integer)param.get((Object)"expires_in")).intValue());
        token.setWeixinId(this.weixinId);
        this.weixinDao.createWeixinToken(token);
        return token;
    }

    private Token refreshWeixinJsSdkTicket() {
        Token accessToken = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("access_token", accessToken.getAccess_token()));
        params.add((NameValuePair)new BasicNameValuePair("type", "jsapi"));
        String jsonStr = HttpUtil.getUrl(url, params);
        logger.info((Object)jsonStr);
        JSONObject param = (JSONObject)JSON.parse((String)jsonStr);
        Token ticket = new Token();
        ticket.setAccess_token((String)param.get((Object)"ticket"));
        ticket.setExpires_in(((Integer)param.get((Object)"expires_in")).intValue());
        ticket.setWeixinType(100);
        this.weixinDao.createWeixinToken(ticket);
        return ticket;
    }

    @Override
    public WxMaterials getMaterials(String mediaType, int offset, int count) {
        WeixinMediasRequest request = new WeixinMediasRequest();
        request.setType(mediaType);
        request.setOffset(offset);
        request.setCount(count);
        String jsonBody = JSON.toJSON((Object)request).toString();
        logger.debug((Object)jsonBody);
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=" + token.getAccess_token();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("body", jsonBody));
        String result = HttpUtil.postUrl(url, jsonBody);
        WxMaterials rs = (WxMaterials)JSON.parseObject((String)result, WxMaterials.class);
        return rs;
    }

    @Override
    public WxMediaResponse addMaterial(String filePath, String mediaType) {
        String API_URL = "https://api.weixin.qq.com/cgi-bin/material/add_material?";
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" + token.getAccess_token() + "&type=" + mediaType;
        String result = WeixinServiceImpl.postFile(url, filePath);
        WxMediaResponse rs = (WxMediaResponse)JSON.parseObject((String)result, WxMediaResponse.class);
        if (rs.getErrcode() <= 0) {
            WeixinMaterial wm = new WeixinMaterial();
            wm.setOwnerId(this.weixinId);
            wm.setMaterialType(mediaType);
            wm.setMediaId(rs.getMedia_id());
            wm.setUrl(rs.getUrl());
            this.weixinDao.createWeixinMaterial(wm);
        } else {
            logger.error((Object)result);
        }
        return rs;
    }

    @Override
    public WxMediaResponse addMaterialNews(WxNewsRequest request) {
        this.replaceImageUrl(request.getArticles());
        String API_URL = "https://api.weixin.qq.com/cgi-bin/material/add_news?";
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=" + token.getAccess_token();
        String jsonBody = JSON.toJSON((Object)request).toString();
        logger.debug((Object)jsonBody);
        String result = HttpUtil.postUrl(url, jsonBody);
        logger.info((Object)result);
        WxMediaResponse rs = (WxMediaResponse)JSON.parseObject((String)result, WxMediaResponse.class);
        return rs;
    }

    private void replaceImageUrl(List<WxNews> articles) {
        for (WxNews article : articles) {
            List<String> images = this.getImageUrl(article.getContent());
            List<String> urls = this.getImageSrc(images);
            for (String url : urls) {
                WxMediaResponse rs;
                logger.info((Object)url);
                String filepath = this.getFilePath(url);
                String filename = HttpUtil.download(url, filepath);
                logger.info((Object)filename);
                if (filename == null || (rs = this.uploadNewsImage(filename)) == null || rs.getUrl() == null) continue;
                article.setContent(article.getContent().replace(url, rs.getUrl()));
            }
        }
    }

    private String getFilePath(String url) {
        String[] vals = url.split("/");
        String val = vals[vals.length - 1];
        if (val.indexOf(".") > 0) {
            return "/temp/" + val;
        }
        return null;
    }

    @Override
    public WxMediaResponse uploadNewsImage(String filePath) {
        String API_URL = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?";
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=" + token.getAccess_token();
        String result = WeixinServiceImpl.postFile(url, filePath);
        logger.info((Object)result);
        WxMediaResponse rs = (WxMediaResponse)JSON.parseObject((String)result, WxMediaResponse.class);
        return rs;
    }

    @Override
    public String getMaterial(String mediaType, String mediaId) {
        WxMediaRequest request = new WxMediaRequest();
        request.setMedia_id(mediaId);
        String jsonBody = JSON.toJSON((Object)request).toString();
        logger.debug((Object)jsonBody);
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + token.getAccess_token();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("body", jsonBody));
        if (mediaType.equalsIgnoreCase(WX_CUSTOM_MSGTYPE_NEWS) || mediaType.equalsIgnoreCase("video")) {
            return HttpUtil.postUrl(url, jsonBody);
        }
        return HttpUtil.downloadFile(url, jsonBody, null);
    }

    @Override
    public WxMediaResponse delMaterial(String mediaId) {
        WxMediaRequest request = new WxMediaRequest();
        request.setMedia_id(mediaId);
        String jsonBody = JSON.toJSON((Object)request).toString();
        logger.debug((Object)jsonBody);
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=" + token.getAccess_token();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("body", jsonBody));
        String result = HttpUtil.postUrl(url, jsonBody);
        WxMediaResponse rs = (WxMediaResponse)JSON.parseObject((String)result, WxMediaResponse.class);
        return rs;
    }

    @Override
    public WeixinUserInfo getUserInfo(String openid) {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("access_token", this.getToken().getAccess_token()));
        params.add((NameValuePair)new BasicNameValuePair("openid", openid));
        params.add((NameValuePair)new BasicNameValuePair("lang", "zh_CN"));
        String jsonStr = HttpUtil.getUrl(url, params);
        logger.debug((Object)url);
        logger.debug((Object)jsonStr);
        return (WeixinUserInfo)JSON.parseObject((String)jsonStr, WeixinUserInfo.class);
    }

    @Override
    public WxMaterialSummary getMaterialSummary() {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?";
        Token token = this.getToken();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("access_token", token.getAccess_token()));
        String result = HttpUtil.getUrl("https://api.weixin.qq.com/cgi-bin/material/get_materialcount?", params);
        WxMaterialSummary summary = (WxMaterialSummary)JSON.parseObject((String)result, WxMaterialSummary.class);
        return summary;
    }

    @Override
    public void processWeixinEvent(HttpServletResponse response, WxData rq) {
        if ("subscribe".equalsIgnoreCase(rq.getEvent())) {
            ArrayList<Object> articles = new ArrayList<Object>();
            WxArticle article = new WxArticle();
            article.setTitle("\u65b0\u6ce8\u518c\u4f1a\u5458\u7acb\u90011000\u79ef\u5206");
            article.setDescription("\u7aed\u8bda\u4e3a\u60a8\u63d0\u4f9b\u4f18\u8d28\u670d\u52a1\uff0c\u6b22\u8fce\u60a8\u6ce8\u518c\u4f1a\u5458\u3002");
            article.setPicurl("");
            String url0 = "";
            String url = this.buildUrlInWeixin(url0);
            article.setUrl(url);
            articles.add(article);
            article = new WxArticle();
            article.setTitle("\u4f53\u9a8c\u4f18\u8d28\u670d\u52a1\uff0c\u73b0\u5728\u5c31\u5f00\u59cb\u5427");
            article.setDescription("\u6b22\u8fce\u6765\u4f53\u9a8c\u6211\u4eec\u7684\u4f18\u8d28\u670d\u52a1");
            article.setPicurl("");
            url0 = "";
            url = this.buildUrlInWeixin(url0);
            article.setUrl(url);
            articles.add(article);
            this.sendCustomMessage(rq.getFromUserName(), WX_CUSTOM_MSGTYPE_NEWS, null, articles);
        } else if ("unsubscribe".equalsIgnoreCase(rq.getEvent())) {
            logger.warn((Object)(rq.getFromUserName() + " unsubscribe."));
        } else if ("CLICK".equalsIgnoreCase(rq.getEvent())) {
            logger.debug((Object)(rq.getEventKey() + "."));
        } else if ("TEMPLATESENDJOBFINISH".equalsIgnoreCase(rq.getEvent())) {
            logger.info((Object)(rq.getMsgId() + ", " + rq.getStatus()));
        }
    }

    @Override
    public int syncUserList() {
        String url = "https://api.weixin.qq.com/cgi-bin/user/get?";
        Token token = this.getToken();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("access_token", token.getAccess_token()));
        params.add((NameValuePair)new BasicNameValuePair("next_openid", ""));
        String jsonStr = HttpUtil.getUrl("https://api.weixin.qq.com/cgi-bin/user/get?", params);
        JSONObject jsonResult = JSONObject.parseObject((String)jsonStr);
        int total = (Integer)jsonResult.get((Object)"total");
        int count = (Integer)jsonResult.get((Object)"count");
        JSONObject dataObject = (JSONObject)jsonResult.get((Object)"data");
        JSONArray array = dataObject.getJSONArray("openid");
        for (int i = 0; i < array.size(); ++i) {
            int status;
            String openId = (String)array.get(i);
            WeixinUser user = new WeixinUser();
            user.setWeixinOpenId(openId);
            WeixinUserInfo userDetail = this.getUserInfo(openId);
            if (userDetail != null) {
                user.setSubscribe(Integer.valueOf(userDetail.getSubscribe()));
                if (userDetail.getSubscribe() == 1) {
                    BeanUtils.copyProperties((Object)userDetail, (Object)user);
                    user.setSubscribe_time(DateUtil.timestampToDate((long)(userDetail.getSubscribe_time() * 1000L)));
                }
            }
            if (this.weixinDao.searchWeixinUser(user.getOwnerId(), user.getWeixinOpenId()) != null || (status = this.weixinDao.createWeixinUser(user)) != -100) continue;
            user.setNickname("");
            status = this.weixinDao.createWeixinUser(user);
        }
        return count;
    }

    @Override
    public List<WeixinTemplate> syncTemplates() {
        ArrayList<WeixinTemplate> results = new ArrayList<WeixinTemplate>();
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("access_token", token.getAccess_token()));
        String jsonStr = HttpUtil.getUrl(url, params);
        WxTemplateList templateList = (WxTemplateList)JSON.parseObject((String)jsonStr, WxTemplateList.class);
        List<WxTemplate> wxTemplates = templateList.getTemplate_list();
        for (WxTemplate t0 : wxTemplates) {
            WeixinTemplate t1 = new WeixinTemplate();
            results.add(t1);
            BeanUtils.copyProperties((Object)t0, (Object)t1);
            t1.setOwnerId(this.weixinId);
            if (this.weixinDao.searchWeixinTemplate(this.weixinId, t1.getTemplate_id()) != null) continue;
            this.weixinDao.createWeixinTemplate(t1);
        }
        return results;
    }

    @Override
    public String sendTemplateMsg(WxTemplateSend wxTplRq) {
        String jsonBody = JSON.toJSONString((Object)wxTplRq);
        logger.debug((Object)jsonBody);
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + token.getAccess_token();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("body", jsonBody));
        String result = HttpUtil.postUrl(url, jsonBody);
        try {
            result = new String(result.getBytes("ISO-8859-1"), ECODING);
            logger.debug((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public void processWeixinMessage(HttpServletRequest request, HttpServletResponse response) {
        String requestXml = this.readInputXml(request);
        logger.debug((Object)("request xml: " + requestXml));
        WxData rq = WxData.fromXml(requestXml);
        if (WX_CUSTOM_MSGTYPE_TEXT.equalsIgnoreCase(rq.getMsgType()) || "image".equalsIgnoreCase(rq.getMsgType()) || "voice".equalsIgnoreCase(rq.getMsgType())) {
            WxData rs = new WxData();
            rs.setMap("ToUserName", rq.getFromUserName());
            rs.setMap("FromUserName", rq.getToUserName());
            rs.setMap("CreateTime", DateUtil.getCurDateTime().getTime() / 1000L);
            rs.setMap("MsgType", "transfer_customer_service");
            String xml = rs.toXml();
            logger.debug((Object)xml);
            HttpUtil.sendResponse(response, xml);
            return;
        }
        HttpUtil.sendResponse(response, "success");
        if ("event".equalsIgnoreCase(rq.getMsgType())) {
            this.processWeixinEvent(response, rq);
            return;
        }
    }

    @Override
    public List<WeixinUser> searchSubscribers(int enterpriseId, CommonSearchCriteria sc) {
        return this.weixinDao.searchSubscribers(enterpriseId, sc);
    }

    @Override
    public List<WeixinMaterial> searchMaterials(int enterpriseId, CommonSearchCriteria sc) {
        return this.weixinDao.searchMaterials(enterpriseId, sc);
    }

    @Override
    public List<WeixinMaterial> searchMaterials(int enterpriseId, String mediaId) {
        return this.weixinDao.searchMaterials(enterpriseId, mediaId);
    }

    @Override
    public int createWeixinMaterial(int enterpriseId, String mediaType, String mediaId, String url, String name) {
        if (enterpriseId != this.weixinId) {
            return -1;
        }
        List<WeixinMaterial> list = this.searchMaterials(this.weixinId, mediaId);
        if (list == null || list.size() == 0) {
            WeixinMaterial wm = new WeixinMaterial();
            wm.setOwnerId(this.weixinId);
            wm.setMaterialType(mediaType);
            wm.setMediaId(mediaId);
            wm.setUrl(url);
            wm.setName(name);
            return this.weixinDao.createWeixinMaterial(wm);
        }
        WeixinMaterial wm = list.get(0);
        wm.setMaterialType(mediaType);
        wm.setUrl(url);
        wm.setName(name);
        return this.weixinDao.updateWeixinMaterial(wm);
    }

    @Override
    public WeixinMaterial searchWeixinMaterial(int id) {
        return this.weixinDao.searchWeixinMaterial(this.weixinId, id);
    }

    @Override
    public Token searchAccessToken(int enterpriseId) {
        return this.getToken();
    }

    @Override
    public WeixinTemplate searchWeixinTemplate(String id) {
        return this.weixinDao.searchWeixinTemplate(this.weixinId, id);
    }

    @Override
    public List<WeixinTemplate> searchTemplates(int enterpriseId) {
        if (enterpriseId == this.weixinId) {
            return this.weixinDao.searchWeixinTemplates(this.weixinId);
        }
        return new ArrayList<WeixinTemplate>();
    }

    private String readInputXml(HttpServletRequest request) {
        String result = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String buildUrlInWeixin(String url0) {
        try {
            return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + this.appId + "&redirect_uri=" + URLEncoder.encode(url0, ECODING) + "&response_type=code&scope=snsapi_base&state=#wechat_redirect";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String sendCustomMessage(String touser, String msgType, String content, List<Object> articles) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)touser);
        jsonObject.put("msgtype", (Object)msgType);
        if (WX_CUSTOM_MSGTYPE_TEXT.equalsIgnoreCase(msgType)) {
            JSONObject textObject = new JSONObject();
            textObject.put("content", (Object)content);
            jsonObject.put(WX_CUSTOM_MSGTYPE_TEXT, (Object)textObject);
        } else if (WX_CUSTOM_MSGTYPE_NEWS.equalsIgnoreCase(msgType)) {
            JSONObject newsObj = new JSONObject();
            jsonObject.put(WX_CUSTOM_MSGTYPE_NEWS, (Object)newsObj);
            JSONArray jsonArray = new JSONArray(articles);
            newsObj.put("articles", (Object)jsonArray);
        }
        String jsonBody = jsonObject.toJSONString();
        logger.debug((Object)jsonBody);
        Token token = this.getToken();
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + token.getAccess_token();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("body", jsonBody));
        String result = HttpUtil.postUrl(url, jsonBody);
        try {
            result = new String(result.getBytes("ISO-8859-1"), ECODING);
            logger.debug((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public List<WeixinCustomMenu> searchCustomMenus(int enterpriseId) {
        return this.weixinDao.searchCustomMenus(enterpriseId);
    }

    @Override
    public int deleteCustomMenu(int enterpriseId, int id) {
        return this.weixinDao.deleteCustomMenu(enterpriseId, id);
    }

    @Override
    public int createCustomMenu(int enterpriseId, String name, String type, String url, String key, int level, int parentId) {
        WeixinCustomMenu o = new WeixinCustomMenu();
        o.setEnterpriseId(enterpriseId);
        o.setName(name);
        o.setType(type);
        o.setUrl(url);
        o.setKey(key);
        o.setLevel(level);
        o.setParentId(parentId);
        return this.weixinDao.createCustomMenu(o);
    }
}

