/*
 * Decompiled with CFR 0.152.
 */
package cn.buk.api.wechat.util;

import cn.buk.api.wechat.util.BaseHttpClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpUtil
extends BaseHttpClient {
    private static Logger logger = Logger.getLogger(HttpUtil.class);

    public static String getUrl(String url, List<NameValuePair> params) {
        String uri = url;
        if (params != null) {
            uri = uri + URLEncodedUtils.format(params, (String)"UTF-8");
        }
        logger.debug((Object)uri.toString());
        CloseableHttpClient httpClient = HttpUtil.createHttpClient();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SO_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT).build();
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(requestConfig);
        String rs = "";
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                rs = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                logger.debug((Object)("response: " + rs));
            }
            response.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return rs;
    }

    public static String postUrl(String url, String body) {
        CloseableHttpClient httpClient = HttpUtil.createHttpClient();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SO_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        String rs = "";
        try {
            StringEntity entity = new StringEntity(body, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpUtil.outHeaders((HttpResponse)response);
                rs = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            response.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return rs;
    }

    public static String downloadFile(String url, String body, String filepath) {
        CloseableHttpClient httpClient = HttpUtil.createHttpClient();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SO_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        try {
            StringEntity entity = new StringEntity(body, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpUtil.outHeaders((HttpResponse)response);
            InputStream is = response.getEntity().getContent();
            if (filepath == null) {
                filepath = HttpUtil.getFilePath((HttpResponse)response);
            }
            File file = new File(filepath);
            file.getParentFile().mkdirs();
            FileOutputStream fileout = new FileOutputStream(file);
            byte[] buffer = new byte[10240];
            int ch = 0;
            while ((ch = is.read(buffer)) != -1) {
                fileout.write(buffer, 0, ch);
            }
            is.close();
            fileout.flush();
            fileout.close();
            response.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        return filepath;
    }

    public static String download(String url, String filepath) {
        String filename = null;
        try {
            CloseableHttpClient httpClient = HttpUtil.createHttpClient();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SO_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT).build();
            HttpGet httpget = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            HttpUtil.outHeaders((HttpResponse)response);
            HttpEntity entity = response.getEntity();
            InputStream is = entity.getContent();
            if (filepath == null) {
                filepath = HttpUtil.getFilePath((HttpResponse)response);
            }
            File file = new File(filepath);
            file.getParentFile().mkdirs();
            FileOutputStream fileout = new FileOutputStream(file);
            byte[] buffer = new byte[10240];
            int ch = 0;
            while ((ch = is.read(buffer)) != -1) {
                fileout.write(buffer, 0, ch);
            }
            is.close();
            fileout.flush();
            fileout.close();
            filename = filepath;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filename;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        logger.debug((Object)ip);
        return ip;
    }

    public static void sendResponse(HttpServletResponse response, String content) {
        response.setContentType("text/plain;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        try {
            PrintWriter pw = response.getWriter();
            pw.print(content);
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void outHeaders(HttpResponse response) {
        Header[] headers = response.getAllHeaders();
        for (int i = 0; i < headers.length; ++i) {
            System.out.println(headers[i]);
        }
    }

    public static String getRandomFileName() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String getFileName(HttpResponse response) {
        NameValuePair param;
        HeaderElement[] values;
        Header contentHeader = response.getFirstHeader("Content-Disposition");
        String filename = null;
        if (contentHeader != null && (values = contentHeader.getElements()).length == 1 && (param = values[0].getParameterByName("filename")) != null) {
            try {
                filename = param.getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filename;
    }

    public static String getFilePath(HttpResponse response) {
        String filepath = "~/";
        String filename = HttpUtil.getFileName(response);
        filepath = filename != null ? filepath + filename : filepath + HttpUtil.getRandomFileName();
        return filepath;
    }
}

