/*
 * Decompiled with CFR 0.152.
 */
package cn.buk.util;

import cn.buk.util.DateUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import org.apache.log4j.Logger;

public class BukEtermClient {
    private static final Logger logger = Logger.getLogger(BukEtermClient.class);
    private String remoteHost;
    private int remotePort;
    private String username;
    private String password;
    private int soTimeout = 3000;
    private int timeout = 10000;
    private Socket socket;
    private boolean logined;
    private Date requestTime;
    private BufferedWriter out;
    private InputStream input;
    private byte[] buffer = new byte[2000];

    private String generatePmDataPackage(String cmd) {
        return this.doGenerateDataPackage("PM" + cmd);
    }

    private String generateOne1DataPackage(String cmd) {
        return this.doGenerateDataPackage("1E" + cmd);
    }

    private String doGenerateDataPackage(String cmd) {
        int len = cmd.length() + 5;
        int intH = len / 256;
        int intL = len % 256;
        return "BUK" + (char)intH + (char)intL + cmd;
    }

    private String doExecuteCmd(String cmd) throws IOException {
        if (!this.isConnected()) {
            logger.warn((Object)"socket is not connected.");
            return "";
        }
        this.requestTime = DateUtil.getCurDateTime();
        this.out.write(cmd, 0, cmd.length());
        this.out.flush();
        boolean done = false;
        String rs = null;
        int readCount = 0;
        Date then = DateUtil.getCurDateTime();
        while (!done) {
            if (this.input.available() > 0) {
                readCount += this.input.read(this.buffer, 0, 2000);
            }
            done = readCount > 0 || DateUtil.getCurDateTime().getTime() - then.getTime() > (long)this.timeout;
            try {
                if (done) continue;
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                done = true;
            }
        }
        if (readCount > 0) {
            rs = this.readStrFromBuffer(readCount);
        }
        return rs;
    }

    private String readStrFromBuffer(int readCount) throws UnsupportedEncodingException {
        String rs = new String(this.buffer, 0, readCount, "GB2312");
        if ("BUK".equalsIgnoreCase(rs.substring(0, 3))) {
            int len;
            byte intH = this.buffer[3];
            int intL = this.buffer[4];
            if (intL < 0) {
                intL = 256 + intL;
            }
            if ((len = intH * 256 + intL) != readCount) {
                if (len < readCount) {
                    logger.warn((Object)(len + " < " + readCount));
                } else {
                    logger.warn((Object)(len + " > " + readCount));
                }
            }
        } else {
            logger.error((Object)"Data packet is wrong.");
        }
        return rs;
    }

    public void connect() {
        this.socket = new Socket();
        InetSocketAddress socketAddress = new InetSocketAddress(this.remoteHost, this.remotePort);
        try {
            this.socket.connect(socketAddress, this.soTimeout);
            if (this.socket.isConnected()) {
                this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                this.input = this.socket.getInputStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.socket != null ? this.socket.isConnected() : false;
    }

    public boolean login() throws IOException, InterruptedException {
        char intL;
        char intH;
        int len;
        if (!this.isConnected()) {
            return false;
        }
        if (this.logined) {
            return this.logined;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        BufferedReader input = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "GB2312"));
        String cmd = "USERNAME=" + this.username + ";PASSWORD=" + this.password + ";VCODE=;";
        cmd = this.generatePmDataPackage(cmd);
        out.write(cmd, 0, cmd.length());
        out.flush();
        char[] buffer = new char[1024];
        boolean done = false;
        String rs = "";
        int readCount = 0;
        Date then = DateUtil.getCurDateTime();
        while (!done) {
            Thread.sleep(100L);
            if (input.ready()) {
                readCount += input.read(buffer, 0, 1024);
            }
            done = readCount > 0 || DateUtil.getCurDateTime().getTime() - then.getTime() > (long)this.timeout;
        }
        if (readCount > 0 && "BUK".equalsIgnoreCase((rs = String.valueOf(buffer, 0, readCount)).substring(0, 3)) && (len = (intH = rs.charAt(3)) * 256 + (intL = rs.charAt(4))) == 9) {
            String rs0 = rs.substring(0, 9);
            rs0 = rs0.substring(5);
            System.out.println(rs0);
            this.logined = "PMOK".equalsIgnoreCase(rs0);
        }
        return this.logined;
    }

    public String readAvailableData() throws IOException {
        if (!this.isConnected()) {
            logger.warn((Object)"socket is not connected.");
            return "";
        }
        String rs = null;
        int readCount = 0;
        Date then = DateUtil.getCurDateTime();
        if (this.input.available() > 0) {
            readCount += this.input.read(this.buffer, 0, 2000);
        }
        if (readCount > 0) {
            rs = this.readStrFromBuffer(readCount);
        }
        return rs;
    }

    public String execCmd(String cmd0) throws IOException {
        String cmd = this.generateOne1DataPackage(cmd0);
        return this.doExecuteCmd(cmd);
    }

    public String rt(String pnrNo) throws IOException {
        return this.rt(pnrNo, true);
    }

    public String rt(String pnrNo, boolean needPn) throws IOException {
        if (this.requestTime != null && DateUtil.getPastTime(this.requestTime) < 1500) {
            try {
                Thread.sleep(1500 - DateUtil.getPastTime(this.requestTime));
                String rs = this.readAvailableData();
                if (rs != null) {
                    logger.warn((Object)rs);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String hostCmd = "RT " + pnrNo;
        String pnrDetail = "";
        boolean rtDone = false;
        logger.debug((Object)hostCmd);
        while (!rtDone) {
            String rs0 = this.doExecuteCmd(this.generateOne1DataPackage(hostCmd));
            if (pnrDetail.length() == 0) {
                pnrDetail = pnrDetail + rs0.substring(7);
                if (!rs0.contains(pnrNo)) {
                    break;
                }
            } else {
                pnrDetail = pnrDetail + "\r" + rs0.substring(7);
            }
            rtDone = !rs0.endsWith("+");
            hostCmd = "PN";
            if (!rtDone) {
                boolean bl = rtDone = rs0.indexOf("THIS PNR WAS ENTIRELY CANCELLED") >= 0;
            }
            if (!needPn) break;
            try {
                if (rtDone) continue;
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return pnrDetail;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.toUpperCase();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isLogined() {
        return this.logined;
    }

    public void setLogined(boolean logined) {
        this.logined = logined;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }
}

