/*
 * Decompiled with CFR 0.152.
 */
package cn.buk.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateUtil {
    private DateUtil() {
    }

    public static Date createDate(int year, int month, int date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, date);
        return calendar.getTime();
    }

    public static Date createDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static Date setTimeOnDate(Date date, int hourOfDay, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date getCurDateTime() {
        return Calendar.getInstance().getTime();
    }

    public static Date getCurTime() {
        Calendar c = Calendar.getInstance();
        c.clear(1);
        c.clear(2);
        c.clear(5);
        return c.getTime();
    }

    public static int getCurrentHour() {
        return Calendar.getInstance().get(11);
    }

    public static int getCurrentMinuteOfHour() {
        return Calendar.getInstance().get(12);
    }

    public static String getCurDateTimeString() {
        return DateUtil.getCurDateTimeString(null);
    }

    public static String getCurDateTimeString(String format) {
        if (format == null) {
            format = "yyyy\u5e74 MM\u6708 dd\u65e5 HH\u65f6 mm\u5206 ss\u79d2";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(DateUtil.getCurDateTime());
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, null);
    }

    public static String formatDate(Date date, String format, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        return sdf.format(date);
    }

    public static String formatDate(Date date, String format) {
        if (format == null) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        return sdf.format(date);
    }

    public static Date getCurDate() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        return c.getTime();
    }

    public static Date getSomedayAfterToday(int x) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.clear(12);
        c.clear(13);
        c.clear(14);
        c.add(5, x);
        return c.getTime();
    }

    public static Date addDays(Date date, int x) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.add(5, x);
        return c.getTime();
    }

    public static Date addMonth(Date date, int x) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.add(2, x);
        return c.getTime();
    }

    public static Date getFullDDate(Date dDate, String dTime) {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTime(dDate);
        int dHour = 0;
        int dMinute = 0;
        try {
            dHour = Integer.parseInt(dTime.substring(0, 2));
            dMinute = Integer.parseInt(dTime.substring(3));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        c.set(11, dHour);
        c.set(12, dMinute);
        return c.getTime();
    }

    public static Date getOnlyDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean isGreaterThan0230() {
        Calendar c = Calendar.getInstance();
        return c.get(11) >= 2 && c.get(12) >= 30;
    }

    public static int getPastDays(Date thenDate) {
        return DateUtil.getPastDays(DateUtil.getCurDateTime(), thenDate);
    }

    public static int getPastDays(Date nowDate, Date thenDate) {
        long ms = nowDate.getTime() - thenDate.getTime();
        long seconds = ms / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        int days = (int)(hours / 24L);
        return days;
    }

    public static int getPastHours(Date pastDate) {
        long seconds = DateUtil.getPastTime(pastDate) / 1000;
        int hours = (int)(seconds / 3600L);
        return hours;
    }

    public static int getPastMinutes(Date pastDate) {
        long seconds = DateUtil.getPastTime(pastDate) / 1000;
        int minutes = (int)seconds / 60;
        return minutes;
    }

    public static int getPastSeconds(Date pastDate) {
        long seconds = DateUtil.getPastTime(pastDate) / 1000;
        return (int)seconds;
    }

    public static int getPastTime(Date pastDate) {
        if (pastDate == null) {
            return 0;
        }
        long ms = DateUtil.getCurDateTime().getTime() - pastDate.getTime();
        return (int)ms;
    }

    public static Date getDate(String dateString, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(dateString);
    }

    public static int getDayOfWeek(Date aDate) {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTime(aDate);
        return c.get(7);
    }

    public static String getDayOfWeekDesc(Date aDate) {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTime(aDate);
        int x = c.get(7);
        switch (x) {
            case 1: {
                return "\u65e5";
            }
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
        }
        return "";
    }

    public static int getDaySpan(Date dateNow, Date dateThen) {
        long seconds = (dateNow.getTime() - dateThen.getTime()) / 1000L;
        int days = (int)seconds / 86400;
        return days;
    }

    public static String getUpdateTimeDesc(Date updateTime) {
        long seconds = (DateUtil.getCurDateTime().getTime() - updateTime.getTime()) / 1000L;
        int minutes = (int)seconds / 60;
        if (minutes < 0) {
            return "\u65f6\u95f4\u8fd8\u6ca1\u5230\u5462";
        }
        if (minutes < 5) {
            return "\u521a\u521a";
        }
        if (minutes >= 60) {
            int hours = minutes / 60;
            return hours + "\u5c0f\u65f6\u524d";
        }
        return minutes + "\u5206\u949f\u524d";
    }

    public static boolean isLowerEqualDate(Date date) {
        long ms = date.getTime() - DateUtil.getCurDateTime().getTime();
        return ms <= 0L;
    }

    public static boolean isGreaterEqualOnlyTime(Date date) {
        long ms = date.getTime() - DateUtil.getCurTime().getTime();
        return ms >= 0L;
    }

    public static boolean isLowerEqualOnlyTime(Date date) {
        long ms = date.getTime() - DateUtil.getCurTime().getTime();
        return ms <= 0L;
    }

    public static boolean isGreaterEqualDate(Date date) {
        long ms = date.getTime() - DateUtil.getCurDateTime().getTime();
        return ms >= 0L;
    }

    public static Date convertToDate(String val, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(val);
    }

    public static Date convertToDate(String val) throws ParseException {
        return DateUtil.convertToDate(val, "yyyy-MM-dd");
    }

    public static Date convertToDateTime(String val) throws ParseException {
        return DateUtil.convertToDate(val, "yyyy-MM-dd hh:mm:ss");
    }

    public static String FormateDate(Date date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(date);
    }

    public static boolean isValidateData(String val) {
        try {
            DateUtil.convertToDate(val, "yyyy-MM-dd");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String convertEtermDate(String val, String dayOfWeek, Date baseTime) {
        int curYear;
        if (val == null || val.length() < 5) {
            return "";
        }
        String day = val.substring(0, 2);
        String month = val.substring(2, 5);
        month = month.compareToIgnoreCase("JAN") == 0 ? "01" : (month.compareToIgnoreCase("FEB") == 0 ? "02" : (month.compareToIgnoreCase("MAR") == 0 ? "03" : (month.compareToIgnoreCase("APR") == 0 ? "04" : (month.compareToIgnoreCase("MAY") == 0 ? "05" : (month.compareToIgnoreCase("JUN") == 0 ? "06" : (month.compareToIgnoreCase("JUL") == 0 ? "07" : (month.compareToIgnoreCase("AUG") == 0 ? "08" : (month.compareToIgnoreCase("SEP") == 0 ? "09" : (month.compareToIgnoreCase("OCT") == 0 ? "10" : (month.compareToIgnoreCase("NOV") == 0 ? "11" : (month.compareToIgnoreCase("DEC") == 0 ? "12" : "00")))))))))));
        if (val.length() == 7) {
            return "20" + val.substring(5) + "-" + month + "-" + day;
        }
        if (baseTime == null) {
            baseTime = DateUtil.getCurDateTime();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(baseTime);
        int curMonth = c.get(2);
        int calcYear = curYear = c.get(1);
        if (curMonth > Integer.parseInt(month)) {
            ++calcYear;
        }
        if (dayOfWeek != null && dayOfWeek.length() == 2) {
            try {
                int nextYear = curYear + 1;
                int prevYear = curYear - 1;
                boolean succeeded = false;
                Date calcDate = DateUtil.convertToDate(nextYear + "-" + month + "-" + day);
                String calcDayOfWeek = DateUtil.formatDate(calcDate, "E", Locale.ENGLISH);
                calcDayOfWeek = calcDayOfWeek.toUpperCase();
                if (calcDayOfWeek.indexOf(dayOfWeek) == 0) {
                    succeeded = true;
                    calcYear = nextYear;
                }
                if (!succeeded) {
                    calcDate = DateUtil.convertToDate(curYear + "-" + month + "-" + day);
                    calcDayOfWeek = DateUtil.formatDate(calcDate, "E", Locale.ENGLISH);
                    if ((calcDayOfWeek = calcDayOfWeek.toUpperCase()).indexOf(dayOfWeek) == 0) {
                        succeeded = true;
                        calcYear = curYear;
                    }
                }
                if (!succeeded) {
                    calcDate = DateUtil.convertToDate(prevYear + "-" + month + "-" + day);
                    calcDayOfWeek = DateUtil.formatDate(calcDate, "E", Locale.ENGLISH);
                    if ((calcDayOfWeek = calcDayOfWeek.toUpperCase()).indexOf(dayOfWeek) == 0) {
                        calcYear = prevYear;
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return Integer.toString(calcYear) + "-" + month + "-" + day;
    }

    public static String convertEtermDate(String val) {
        if (val == null || val.length() != 7) {
            return "";
        }
        String day = val.substring(0, 2);
        String month = DateUtil.convertMonthFormat(val.substring(2, 5));
        String year = "20" + val.substring(5);
        return year + "-" + month + "-" + day;
    }

    public static Date addMinutes(Date date, int minutes) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.add(12, minutes);
        return c.getTime();
    }

    public static Date addSeconds(Date date, int s) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.add(13, s);
        return c.getTime();
    }

    public static Date addMilliSeconds(Date date, int ms) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.add(14, ms);
        return c.getTime();
    }

    public static Date getDateOnMinute(Date date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.clear(14);
        c.clear(13);
        return c.getTime();
    }

    public static Date getDateOnTheHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.clear(14);
        c.clear(13);
        c.clear(12);
        return c.getTime();
    }

    public static String getTomorrowStr() {
        Date tomorrow = DateUtil.addDays(DateUtil.getCurDate(), 1);
        return DateUtil.formatDate(tomorrow, "yyyy-MM-dd");
    }

    public static Date getTomorrowDate() {
        return DateUtil.addDays(DateUtil.getCurDate(), 1);
    }

    public static Date getYesterday() {
        return DateUtil.addDays(DateUtil.getCurDate(), -1);
    }

    public static XMLGregorianCalendar convertDateToXMLGregorianCalendar(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        XMLGregorianCalendar xt = null;
        try {
            xt = DatatypeFactory.newInstance().newXMLGregorianCalendar(year, month + 1, day, 0, 0, 0, 0, 0);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return xt;
    }

    public static boolean isInWorkTime(String workBeginTime, String workEndTime) {
        if (workBeginTime == null || workBeginTime.length() != 4 || workEndTime == null || workEndTime.length() != 4) {
            return false;
        }
        int hour = DateUtil.getCurrentHour();
        int minute = DateUtil.getCurrentMinuteOfHour();
        try {
            int hour0 = Integer.parseInt(workBeginTime.substring(0, 2));
            int minute0 = Integer.parseInt(workBeginTime.substring(2, 4));
            int hour1 = Integer.parseInt(workEndTime.substring(0, 2));
            int minute1 = Integer.parseInt(workEndTime.substring(2, 4));
            if (hour0 > hour1) {
                return false;
            }
            return !(hour == hour0 && minute < minute0 || hour < hour0 || hour == hour1 && minute > minute1) && hour <= hour1;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isInEntWorkDay(int dayOfWeek, String entWorkDay) {
        int dayOfWeek0 = dayOfWeek - 1;
        if (dayOfWeek0 == 0) {
            dayOfWeek0 = 7;
        }
        return entWorkDay.contains(dayOfWeek0 + "");
    }

    public static String convertMonthFormat(String abbrMonth) {
        String result = "";
        switch (abbrMonth) {
            case "JAN": {
                result = "01";
                break;
            }
            case "FEB": {
                result = "02";
                break;
            }
            case "MAR": {
                result = "03";
                break;
            }
            case "APR": {
                result = "04";
                break;
            }
            case "MAY": {
                result = "05";
                break;
            }
            case "JUN": {
                result = "06";
                break;
            }
            case "JUL": {
                result = "07";
                break;
            }
            case "AUG": {
                result = "08";
                break;
            }
            case "SEP": {
                result = "09";
                break;
            }
            case "OCT": {
                result = "10";
                break;
            }
            case "NOV": {
                result = "11";
                break;
            }
            case "DEC": {
                result = "12";
            }
        }
        return result;
    }

    public static boolean containMonth(String content) {
        return content.contains("JAN") || content.contains("FEB") || content.contains("MAR") || content.contains("APR") || content.contains("MAY") || content.contains("JUN") || content.contains("JUL") || content.contains("AUG") || content.contains("SEP") || content.contains("OCT") || content.contains("NOV") || content.contains("DEC");
    }

    public static Date timestampToDate(long subscribe_time) {
        return new Date(subscribe_time);
    }
}

