/*
 * Decompiled with CFR 0.152.
 */
package cn.buk.util;

import java.text.DecimalFormat;

public class FlightUtil {
    public static String getCityCode(String airportCode) {
        if (airportCode.equalsIgnoreCase("NAY") || airportCode.equalsIgnoreCase("PEK")) {
            return "BJS";
        }
        if (airportCode.equalsIgnoreCase("PVG") || airportCode.equalsIgnoreCase("SHA")) {
            return "SHA";
        }
        return airportCode;
    }

    public static String getOffsetDesc(int offset) {
        if (offset == 100) {
            return "\u5168\u4ef7";
        }
        if (offset < 10) {
            return "";
        }
        return new DecimalFormat("0.0").format(offset / 10) + "\u6298";
    }

    public static String getCabinClassDesc(String cabinClass) {
        if (cabinClass == null) {
            return "";
        }
        if (cabinClass.trim().equalsIgnoreCase("Y")) {
            return "\u7ecf\u6d4e\u8231";
        }
        if (cabinClass.trim().equalsIgnoreCase("F")) {
            return "\u5934\u7b49\u8231";
        }
        if (cabinClass.trim().equalsIgnoreCase("C")) {
            return "\u516c\u52a1\u8231";
        }
        return "";
    }

    public static String formatShowTime(String time) {
        if (time == null) {
            return "";
        }
        String tempDepTime = time.trim();
        if (tempDepTime.length() == 4) {
            return tempDepTime.substring(0, 2) + ":" + tempDepTime.substring(2, 4);
        }
        return tempDepTime;
    }

    public static boolean checkSubclassNormal(String subclassDesc) {
        int statusACount = 0;
        int statusOtCount = 0;
        int lastTwoStatusACount = 0;
        String[] subclsses = subclassDesc.split(" ");
        int subclassLeftCount = subclsses.length;
        for (String subclass : subclsses) {
            --subclassLeftCount;
            if ((subclass = subclass.trim()).length() != 2) continue;
            String seatStatus = subclass.substring(1);
            if (seatStatus.equalsIgnoreCase("A")) {
                ++statusACount;
                if (subclassLeftCount > 1) continue;
                ++lastTwoStatusACount;
                continue;
            }
            ++statusOtCount;
        }
        return statusOtCount >= 2 && lastTwoStatusACount != 2;
    }

    public static String verifyAirport(String port0) {
        return FlightUtil.verifyAirport(port0, null);
    }

    public static String verifyAirport(String port0, String airline) {
        if (port0.equalsIgnoreCase("PVG")) {
            return "SHA";
        }
        if (port0.equalsIgnoreCase("NAY")) {
            if (airline != null && airline.equalsIgnoreCase("KN")) {
                return "NAY";
            }
            return "PEK";
        }
        return port0.toUpperCase();
    }

    public static String verifyCityCode(String code0) {
        if (code0.equalsIgnoreCase("PVG")) {
            return "SHA";
        }
        if (code0.equalsIgnoreCase("NAY")) {
            return "BJS";
        }
        if (code0.equalsIgnoreCase("PEK")) {
            return "BJS";
        }
        return code0.toUpperCase();
    }
}

