/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.authorize.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"formatUptime", "", "millis", "", "getSystemInfo", "HuYanAuthorize"})
public final class UtilKt {
    @NotNull
    public static final String getSystemInfo() {
        String string;
        Object reader;
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String osName = osBean.getName();
        MemoryUsage heapMemoryUsage = memoryBean.getHeapMemoryUsage();
        long totalMemory = heapMemoryUsage.getMax();
        long usedMemory = heapMemoryUsage.getUsed();
        long freeMemory = totalMemory - usedMemory;
        double memoryUsagePercentage = (double)usedMemory / (double)totalMemory * (double)100;
        long startTime = runtimeBean.getStartTime();
        String upTime = UtilKt.formatUptime(System.currentTimeMillis() - startTime);
        double cpuUsage = 0.0;
        try {
            Intrinsics.checkNotNull((Object)osName);
            if (StringsKt.startsWith$default((String)osName, (String)"Linux", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"sh", "-c", "top -bn1 | grep '%Cpu(s)'"};
                Process process = Runtime.getRuntime().exec(stringArray);
                reader = new Scanner(process.getInputStream()).useDelimiter("\\A");
                String output = ((Scanner)reader).hasNext() ? ((Scanner)reader).next() : "";
                Regex pattern = new Regex("(?<=ni,|sy,|us,)\\s*(\\d+\\.\\d+)\\s+id");
                Intrinsics.checkNotNull((Object)output);
                MatchResult match = Regex.find$default((Regex)pattern, (CharSequence)output, (int)0, (int)2, null);
                if (match != null) {
                    double idle = Double.parseDouble((String)match.getGroupValues().get(1));
                    cpuUsage = 100.0 - idle;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reader = "%.2f";
        Object object = new Object[]{memoryUsagePercentage};
        String string2 = String.format((String)reader, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String formattedMemoryUsagePercentage = string2;
        if (cpuUsage > 0.0) {
            object = "%.1f%%";
            Object[] objectArray = new Object[]{cpuUsage};
            String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = "N/A";
        }
        String formattedCpuUsage = string;
        return StringsKt.trimIndent((String)("\n        \u64cd\u4f5c\u7cfb\u7edf: " + osName + "\n        \u8fd0\u884c\u65f6\u95f4: " + upTime + " \n        CPU \u4f7f\u7528\u7387: " + formattedCpuUsage + "\n        \u5185\u5b58:\n          - \u603b\u5927\u5c0f: " + totalMemory / (long)0x100000 + " MB\n          - \u5df2\u4f7f\u7528: " + usedMemory / (long)0x100000 + " MB\n          - \u672a\u4f7f\u7528: " + freeMemory / (long)0x100000 + " MB\n          - \u4f7f\u7528\u7387: " + formattedMemoryUsagePercentage + "%\n    "));
    }

    private static final String formatUptime(long millis) {
        StringBuilder stringBuilder;
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % (long)24;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % (long)60;
        StringBuilder $this$formatUptime_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (days > 0L) {
            $this$formatUptime_u24lambda_u240.append(days + "\u5929");
        }
        if (hours > 0L) {
            $this$formatUptime_u24lambda_u240.append(hours + "\u5c0f\u65f6");
        }
        $this$formatUptime_u24lambda_u240.append(minutes + "\u5206\u949f");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

