/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity;

import cn.chahuyun.economy.utils.ImageUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.awt.Color;
import java.io.Serializable;
import java.util.Date;

@Entity(name="TitleInfo")
@Table
public class TitleInfo
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private long userId;
    private String code;
    private String name;
    private boolean status;
    private String title;
    private boolean impactName;
    private boolean gradient;
    private String sColor;
    private String eColor;
    private Date dueTime;

    public Color getStartColor() {
        return ImageUtil.hexColor(this.sColor);
    }

    public Color getEndColor() {
        return ImageUtil.hexColor(this.eColor);
    }

    public static TitleInfoBuilder builder() {
        return new TitleInfoBuilder();
    }

    public int getId() {
        return this.id;
    }

    public long getUserId() {
        return this.userId;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isImpactName() {
        return this.impactName;
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public String getSColor() {
        return this.sColor;
    }

    public String getEColor() {
        return this.eColor;
    }

    public Date getDueTime() {
        return this.dueTime;
    }

    public TitleInfo setId(int id) {
        this.id = id;
        return this;
    }

    public TitleInfo setUserId(long userId) {
        this.userId = userId;
        return this;
    }

    public TitleInfo setCode(String code) {
        this.code = code;
        return this;
    }

    public TitleInfo setName(String name) {
        this.name = name;
        return this;
    }

    public TitleInfo setStatus(boolean status) {
        this.status = status;
        return this;
    }

    public TitleInfo setTitle(String title) {
        this.title = title;
        return this;
    }

    public TitleInfo setImpactName(boolean impactName) {
        this.impactName = impactName;
        return this;
    }

    public TitleInfo setGradient(boolean gradient) {
        this.gradient = gradient;
        return this;
    }

    public TitleInfo setSColor(String sColor) {
        this.sColor = sColor;
        return this;
    }

    public TitleInfo setEColor(String eColor) {
        this.eColor = eColor;
        return this;
    }

    public TitleInfo setDueTime(Date dueTime) {
        this.dueTime = dueTime;
        return this;
    }

    public TitleInfo() {
    }

    public TitleInfo(int id, long userId, String code, String name, boolean status, String title, boolean impactName, boolean gradient, String sColor, String eColor, Date dueTime) {
        this.id = id;
        this.userId = userId;
        this.code = code;
        this.name = name;
        this.status = status;
        this.title = title;
        this.impactName = impactName;
        this.gradient = gradient;
        this.sColor = sColor;
        this.eColor = eColor;
        this.dueTime = dueTime;
    }

    public static class TitleInfoBuilder {
        private int id;
        private long userId;
        private String code;
        private String name;
        private boolean status;
        private String title;
        private boolean impactName;
        private boolean gradient;
        private String sColor;
        private String eColor;
        private Date dueTime;

        TitleInfoBuilder() {
        }

        public TitleInfoBuilder id(int id) {
            this.id = id;
            return this;
        }

        public TitleInfoBuilder userId(long userId) {
            this.userId = userId;
            return this;
        }

        public TitleInfoBuilder code(String code) {
            this.code = code;
            return this;
        }

        public TitleInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TitleInfoBuilder status(boolean status) {
            this.status = status;
            return this;
        }

        public TitleInfoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public TitleInfoBuilder impactName(boolean impactName) {
            this.impactName = impactName;
            return this;
        }

        public TitleInfoBuilder gradient(boolean gradient) {
            this.gradient = gradient;
            return this;
        }

        public TitleInfoBuilder sColor(String sColor) {
            this.sColor = sColor;
            return this;
        }

        public TitleInfoBuilder eColor(String eColor) {
            this.eColor = eColor;
            return this;
        }

        public TitleInfoBuilder dueTime(Date dueTime) {
            this.dueTime = dueTime;
            return this;
        }

        public TitleInfo build() {
            return new TitleInfo(this.id, this.userId, this.code, this.name, this.status, this.title, this.impactName, this.gradient, this.sColor, this.eColor, this.dueTime);
        }

        public String toString() {
            return "TitleInfo.TitleInfoBuilder(id=" + this.id + ", userId=" + this.userId + ", code=" + this.code + ", name=" + this.name + ", status=" + this.status + ", title=" + this.title + ", impactName=" + this.impactName + ", gradient=" + this.gradient + ", sColor=" + this.sColor + ", eColor=" + this.eColor + ", dueTime=" + this.dueTime + ")";
        }
    }
}

