/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity;

import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.props.PropsBase;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity(name="UserBackpack")
@Table
public class UserBackpack
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private String userId;
    private String propsCode;
    private long propId;
    private String className;

    public UserBackpack() {
    }

    public UserBackpack(String userId, String propsCode, int propId, Class<? extends PropsBase> className) {
        this.userId = userId;
        this.propsCode = propsCode;
        this.propId = propId;
        this.className = className.getName();
    }

    public UserBackpack(UserInfo userInfo, PropsBase propsBase) {
        this.userId = userInfo.getId();
        this.propsCode = propsBase.getCode();
        this.propId = propsBase.getId();
        this.className = propsBase.getClass().getName();
    }

    public Long getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPropsCode() {
        return this.propsCode;
    }

    public long getPropId() {
        return this.propId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPropsCode(String propsCode) {
        this.propsCode = propsCode;
    }

    public void setPropId(long propId) {
        this.propId = propId;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

