/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.UserBackpack;
import cn.chahuyun.economy.entity.fish.FishInfo;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.CalendarUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.mamoe.mirai.console.permission.AbstractPermitteeId;
import net.mamoe.mirai.contact.User;

@Entity(name="UserInfo")
@Table(name="UserInfo")
public class UserInfo
implements Serializable {
    @Id
    private String id;
    private long qq;
    private String name;
    private long registerGroup;
    private Date registerTime;
    private boolean sign;
    private Date signTime;
    private int signNumber = 0;
    private int oldSignNumber;
    private double signEarnings;
    private double bankEarnings;
    @OneToMany(targetEntity=UserBackpack.class, mappedBy="userId", fetch=FetchType.EAGER)
    private List<UserBackpack> backpacks;
    @Transient
    private User user;

    public UserInfo() {
    }

    public UserInfo(long qq, long registerGroup, String name, Date registerTime) {
        this.id = new AbstractPermitteeId.ExactUser(qq).asString();
        this.qq = qq;
        this.registerGroup = registerGroup;
        this.name = name;
        this.registerTime = registerTime;
    }

    public boolean sign() {
        if (this.getSignTime() == null) {
            this.setSign(true);
            this.setSignTime(new Date());
            this.setSignNumber(1);
            HibernateFactory.merge((Object)this);
            return true;
        }
        Calendar calendar = CalendarUtil.calendar((Date)DateUtil.offsetDay((Date)this.getSignTime(), (int)1));
        calendar.set(11, HuYanEconomy.config.getReSignTime());
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date time = calendar.getTime();
        long between = DateUtil.between((Date)time, (Date)new Date(), (DateUnit)DateUnit.MINUTE, (boolean)false);
        Log.debug("\u8d26\u6237:(" + this.getQq() + ")\u7b7e\u5230\u65f6\u5dee->" + between);
        if (between < 0L) {
            return false;
        }
        if (between <= 1440L) {
            this.setSignNumber(this.getSignNumber() + 1);
            this.setOldSignNumber(0);
        } else {
            this.setOldSignNumber(this.getSignNumber());
            this.setSignNumber(1);
        }
        this.setSign(true);
        this.setSignTime(new Date());
        HibernateFactory.merge((Object)this);
        return true;
    }

    public boolean addPropToBackpack(UserBackpack userBackpack) {
        this.getBackpacks().add(userBackpack);
        try {
            HibernateFactory.merge((Object)this);
            HibernateFactory.merge((Object)userBackpack);
        }
        catch (Exception e) {
            Log.error("\u7528\u6237\u4fe1\u606f:\u6dfb\u52a0\u9053\u5177\u5230\u80cc\u5305\u51fa\u9519", e);
            return false;
        }
        return true;
    }

    public boolean isSign() {
        String now = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + " 04:00:00";
        DateTime nowDate = DateUtil.parse((CharSequence)now);
        long between = DateUtil.between((Date)nowDate, (Date)this.signTime, (DateUnit)DateUnit.HOUR, (boolean)false);
        return between > 0L;
    }

    public FishInfo getFishInfo() {
        try {
            FishInfo fishInfo = (FishInfo)HibernateFactory.selectOne(FishInfo.class, (Object)this.getQq());
            if (fishInfo != null) {
                return fishInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FishInfo newFishInfo = new FishInfo(this.getQq(), this.getRegisterGroup());
        return (FishInfo)HibernateFactory.merge((Object)newFishInfo);
    }

    public String getString() {
        return "\u7528\u6237\u540d\u79f0:" + this.getName() + "\n\u7528\u6237qq:" + this.getQq() + "\n\u8fde\u7eed\u7b7e\u5230:" + this.getSignNumber() + "\u5929\n";
    }

    public UserInfo setUser(User user) {
        this.user = user;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public long getQq() {
        return this.qq;
    }

    public String getName() {
        return this.name;
    }

    public long getRegisterGroup() {
        return this.registerGroup;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public Date getSignTime() {
        return this.signTime;
    }

    public int getSignNumber() {
        return this.signNumber;
    }

    public int getOldSignNumber() {
        return this.oldSignNumber;
    }

    public double getSignEarnings() {
        return this.signEarnings;
    }

    public double getBankEarnings() {
        return this.bankEarnings;
    }

    public List<UserBackpack> getBackpacks() {
        return this.backpacks;
    }

    public User getUser() {
        return this.user;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setQq(long qq) {
        this.qq = qq;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegisterGroup(long registerGroup) {
        this.registerGroup = registerGroup;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }

    public void setSignNumber(int signNumber) {
        this.signNumber = signNumber;
    }

    public void setOldSignNumber(int oldSignNumber) {
        this.oldSignNumber = oldSignNumber;
    }

    public void setSignEarnings(double signEarnings) {
        this.signEarnings = signEarnings;
    }

    public void setBankEarnings(double bankEarnings) {
        this.bankEarnings = bankEarnings;
    }

    public void setBackpacks(List<UserBackpack> backpacks) {
        this.backpacks = backpacks;
    }
}

