/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity.bank;

import cn.hutool.core.util.RandomUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Date;

@Entity(name="BankInfo")
@Table(name="BankInfo")
public class BankInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private String code;
    private String name;
    private String description;
    private long qq;
    private boolean interestSwitch;
    private Date regTime;
    private double regTotal;
    private double total;
    private int interest;

    public BankInfo() {
    }

    public BankInfo(String code, String name, String description, long qq, double regTotal) {
        this.code = code;
        this.name = name;
        this.description = description;
        this.qq = qq;
        this.regTime = new Date();
        this.regTotal = regTotal;
        this.interestSwitch = true;
        this.interest = BankInfo.randomInterest();
    }

    public static Integer randomInterest() {
        int i = RandomUtil.randomInt((int)1, (int)101);
        if (i <= 70) {
            return RandomUtil.randomInt((int)1, (int)4);
        }
        if (i <= 99) {
            return RandomUtil.randomInt((int)4, (int)8);
        }
        return RandomUtil.randomInt((int)-3, (int)0);
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getQq() {
        return this.qq;
    }

    public boolean isInterestSwitch() {
        return this.interestSwitch;
    }

    public Date getRegTime() {
        return this.regTime;
    }

    public double getRegTotal() {
        return this.regTotal;
    }

    public double getTotal() {
        return this.total;
    }

    public int getInterest() {
        return this.interest;
    }

    public BankInfo setId(int id) {
        this.id = id;
        return this;
    }

    public BankInfo setCode(String code) {
        this.code = code;
        return this;
    }

    public BankInfo setName(String name) {
        this.name = name;
        return this;
    }

    public BankInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public BankInfo setQq(long qq) {
        this.qq = qq;
        return this;
    }

    public BankInfo setInterestSwitch(boolean interestSwitch) {
        this.interestSwitch = interestSwitch;
        return this;
    }

    public BankInfo setRegTime(Date regTime) {
        this.regTime = regTime;
        return this;
    }

    public BankInfo setRegTotal(double regTotal) {
        this.regTotal = regTotal;
        return this;
    }

    public BankInfo setTotal(double total) {
        this.total = total;
        return this;
    }

    public BankInfo setInterest(int interest) {
        this.interest = interest;
        return this;
    }
}

