/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity.fish;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.fish.FishPond;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.hibernateplus.HibernateFactory;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.HashMap;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;

@Table
@Entity(name="FishInfo")
public class FishInfo
implements Serializable {
    @Id
    private long id;
    private long qq;
    private boolean fishRod;
    private boolean status;
    private int rodLevel;
    private String defaultFishPond;

    public FishInfo() {
    }

    public FishInfo(long qq, long group) {
        this.id = qq;
        this.qq = qq;
        this.fishRod = false;
        this.rodLevel = 0;
        this.defaultFishPond = "g-" + group;
    }

    public SingleMessage updateRod(UserInfo userInfo) {
        User user = userInfo.getUser();
        double moneyByUser = EconomyUtil.getMoneyByUser(user);
        int upMoney = 1;
        if (this.getRodLevel() == 0) {
            return this.isMoney(user, moneyByUser, upMoney);
        }
        if (1 <= this.getRodLevel() && this.getRodLevel() < 70) {
            upMoney = 40 * this.getRodLevel() * this.getLevel();
            return this.isMoney(user, moneyByUser, upMoney);
        }
        if (70 <= this.getRodLevel() && this.getRodLevel() < 80) {
            upMoney = 80 * this.getRodLevel() * this.getLevel();
            return this.isMoney(user, moneyByUser, upMoney);
        }
        if (80 <= this.getRodLevel() && this.getRodLevel() < 90) {
            upMoney = 100 * this.getRodLevel() * this.getLevel();
            return this.isMoney(user, moneyByUser, upMoney);
        }
        if (90 <= this.getRodLevel() && this.getRodLevel() < 100) {
            upMoney = 150 * this.getRodLevel() * this.getLevel();
            return this.isMoney(user, moneyByUser, upMoney);
        }
        if (this.getRodLevel() == 99) {
            upMoney = 150000;
            return this.isMoney(user, moneyByUser, upMoney);
        }
        return new PlainText("\u4f60\u7684\u9c7c\u7aff\u5df2\u7ecf\u6ee1\u7ea7\u62c9\uff01");
    }

    public FishPond getFishPond() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", this.getDefaultFishPond());
            FishPond fishPond = (FishPond)HibernateFactory.selectOne(FishPond.class, map);
            if (fishPond != null) {
                return fishPond;
            }
        }
        catch (Exception e) {
            Log.debug(e);
        }
        String[] split = this.getDefaultFishPond().split("-");
        if (split.length == 2) {
            long group = Long.parseLong(split[1]);
            Group botGroup = HuYanEconomy.INSTANCE.bot.getGroup(group);
            FishPond finalFishPond = botGroup != null ? new FishPond(1, group, HuYanEconomy.config.getOwner(), botGroup.getName() + "\u9c7c\u5858", "\u4e00\u4e2a\u5929\u7136\u5f62\u6210\u7684\u9c7c\u5858\uff0c\u65e0\u4eba\u7ba1\u7406\uff0c\u9c7c\u60c5\u826f\u597d\uff0c\u6df1\u53d7\u9493\u9c7c\u4f6c\u559c\u7231\uff01") : new FishPond(1, 0L, 0L, "\u7a7a\u9c7c\u5858", "\u4e00\u4e2a\u5929\u7136\u5f62\u6210\u7684\u9c7c\u5858\uff0c\u65e0\u4eba\u7ba1\u7406\uff0c\u9c7c\u60c5\u826f\u597d\uff0c\u6df1\u53d7\u9493\u9c7c\u4f6c\u559c\u7231\uff01");
            return (FishPond)HibernateFactory.merge((Object)finalFishPond);
        }
        return null;
    }

    public FishPond getFishPond(Group group) {
        FishPond fishPond = (FishPond)HibernateFactory.selectOne(FishPond.class, (String)"code", (Object)("g-" + group.getId()));
        if (fishPond != null) {
            return fishPond;
        }
        fishPond = new FishPond(1, group.getId(), HuYanEconomy.config.getOwner(), group.getName() + "\u9c7c\u5858", "\u4e00\u4e2a\u5929\u7136\u5f62\u6210\u7684\u9c7c\u5858\uff0c\u65e0\u4eba\u7ba1\u7406\uff0c\u9c7c\u60c5\u826f\u597d\uff0c\u6df1\u53d7\u9493\u9c7c\u4f6c\u559c\u7231\uff01");
        return (FishPond)HibernateFactory.merge((Object)fishPond);
    }

    public int getLevel() {
        return this.getRodLevel() == 0 ? 1 : this.getRodLevel() / 10 + 2;
    }

    private void upFishRod() {
        this.setRodLevel(this.getRodLevel() + 1);
        HibernateFactory.merge((Object)this);
    }

    private SingleMessage isMoney(User user, double userMoney, int upMoney) {
        if (userMoney - (double)upMoney < 0.0) {
            return new PlainText(String.format("\u4f60\u7684\u91d1\u5e01\u4e0d\u591f%s\u5566\uff01", upMoney));
        }
        if (EconomyUtil.minusMoneyToUser(user, upMoney)) {
            this.upFishRod();
            return new PlainText(String.format("\u5347\u7ea7\u6210\u529f,\u82b1\u8d39%s\u91d1\u5e01!\u4f60\u7684\u9c7c\u7aff\u66f4\u5f3a\u4e86!\n%s->%s", upMoney, this.getRodLevel() - 1, this.getRodLevel()));
        }
        return new PlainText("\u5347\u7ea7\u5931\u8d25!");
    }

    public synchronized boolean isStatus() {
        if (this.status) {
            return true;
        }
        this.status = true;
        HibernateFactory.merge((Object)this);
        return false;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void switchStatus() {
        this.status = false;
        HibernateFactory.merge((Object)this);
    }

    public long getId() {
        return this.id;
    }

    public long getQq() {
        return this.qq;
    }

    public boolean isFishRod() {
        return this.fishRod;
    }

    public int getRodLevel() {
        return this.rodLevel;
    }

    public String getDefaultFishPond() {
        return this.defaultFishPond;
    }

    public FishInfo setId(long id) {
        this.id = id;
        return this;
    }

    public FishInfo setQq(long qq) {
        this.qq = qq;
        return this;
    }

    public FishInfo setFishRod(boolean fishRod) {
        this.fishRod = fishRod;
        return this;
    }

    public FishInfo setStatus(boolean status) {
        this.status = status;
        return this;
    }

    public FishInfo setRodLevel(int rodLevel) {
        this.rodLevel = rodLevel;
        return this;
    }

    public FishInfo setDefaultFishPond(String defaultFishPond) {
        this.defaultFishPond = defaultFishPond;
        return this;
    }
}

