/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity.fish;

import cn.chahuyun.economy.entity.fish.Fish;
import cn.chahuyun.economy.plugin.FishManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.builder.EqualsBuilder;
import cn.hutool.core.builder.HashCodeBuilder;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Entity(name="FishPond")
@Table
public class FishPond
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private String code;
    private long admin;
    private int pondType;
    private String name;
    private String description;
    private int pondLevel;
    private int minLevel;
    private double rebate;
    private int number;
    @OneToMany(targetEntity=Fish.class, mappedBy="id", fetch=FetchType.EAGER)
    private List<Fish> fishList;

    public FishPond() {
    }

    public FishPond(int pondType, long group, long admin, String name, String description) {
        this.code = pondType == 1 ? "g-" + group : (pondType == 2 ? "g-" + group + "-" + admin : String.valueOf(admin));
        this.admin = admin;
        this.name = name;
        this.description = description;
        this.pondLevel = pondType == 1 ? 6 : 1;
        this.pondType = pondType;
        this.minLevel = 0;
        this.rebate = 0.05;
        this.number = 0;
    }

    public double getFishPondMoney() {
        return EconomyUtil.getMoneyByBankFromId(this.getCode(), this.getDescription());
    }

    public List<Fish> getFishList() {
        if (this.fishList == null) {
            return new ArrayList<Fish>();
        }
        return this.fishList;
    }

    public List<Fish> getFishList(int level) {
        if (this.pondType == 1) {
            return FishManager.getLevelFishList(level);
        }
        if (this.fishList == null) {
            return new ArrayList<Fish>();
        }
        return this.fishList;
    }

    public void addNumber() {
        ++this.number;
        HibernateFactory.merge((Object)this);
    }

    public FishPond save() {
        return (FishPond)HibernateFactory.merge((Object)this);
    }

    public int getId() {
        return this.id;
    }

    public FishPond setId(int id) {
        this.id = id;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public FishPond setCode(String code) {
        this.code = code;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FishPond fishPond = (FishPond)object;
        return new EqualsBuilder().append((Object)this.code, (Object)fishPond.code).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.code).toHashCode();
    }

    public long getAdmin() {
        return this.admin;
    }

    public int getPondType() {
        return this.pondType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPondLevel() {
        return this.pondLevel;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public double getRebate() {
        return this.rebate;
    }

    public int getNumber() {
        return this.number;
    }

    public void setAdmin(long admin) {
        this.admin = admin;
    }

    public void setPondType(int pondType) {
        this.pondType = pondType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPondLevel(int pondLevel) {
        this.pondLevel = pondLevel;
    }

    public void setMinLevel(int minLevel) {
        this.minLevel = minLevel;
    }

    public void setRebate(double rebate) {
        this.rebate = rebate;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setFishList(List<Fish> fishList) {
        this.fishList = fishList;
    }
}

