/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity.fish;

import cn.chahuyun.economy.entity.fish.Fish;
import cn.chahuyun.economy.entity.fish.FishPond;
import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;

@Entity(name="FishRanking")
@Table
public class FishRanking
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private long qq;
    private String name;
    private int dimensions;
    private double money;
    private int fishRodLevel;
    private Date date;
    @ManyToOne(targetEntity=Fish.class, fetch=FetchType.EAGER)
    @JoinColumn(name="FishId")
    private Fish fish;
    @ManyToOne(targetEntity=FishPond.class, fetch=FetchType.EAGER)
    @JoinColumn(name="FishPondId")
    private FishPond fishPond;

    public FishRanking() {
    }

    public FishRanking(long qq, String name, int dimensions, double money, int fishRodLevel, Fish fish, FishPond fishPond) {
        this.qq = qq;
        this.name = name;
        this.dimensions = dimensions;
        this.money = money;
        this.fishRodLevel = fishRodLevel;
        this.fish = fish;
        this.fishPond = fishPond;
        this.date = new Date();
    }

    public SingleMessage getInfo(int top) {
        String message = "top:" + (top + 1) + "\n";
        if (top == 0 || top == 1 || top == 2) {
            String s = DateUtil.formatBetween((long)DateUtil.between((Date)new Date(), (Date)this.getDate(), (DateUnit)DateUnit.MS), (BetweenFormatter.Level)BetweenFormatter.Level.MINUTE);
            message = message + "\u9738\u699c\u65f6\u95f4:" + s + "\n";
        }
        message = message + "\u7528\u6237:" + this.getName() + "(\u9c7c\u7aff\u7b49\u7ea7:" + this.getFishRodLevel() + ")\n\u5c3a\u5bf8:" + this.getDimensions() + "\n\u91d1\u989d:" + this.getMoney() + "\n\u9c7c:" + this.getFish().getName() + "(\u7b49\u7ea7:" + this.getFish().getLevel() + ")\n\u9c7c\u5858:" + this.getFishPond().getName() + "(\u9c7c\u5858\u7b49\u7ea7:" + this.getFishPond().getPondLevel() + ")";
        return new PlainText(message);
    }

    public int getId() {
        return this.id;
    }

    public FishRanking setId(int id) {
        this.id = id;
        return this;
    }

    public Fish getFish() {
        return this.fish;
    }

    public FishRanking setFish(Fish fish) {
        this.fish = fish;
        return this;
    }

    public FishPond getFishPond() {
        return this.fishPond;
    }

    public FishRanking setFishPond(FishPond fishPond) {
        this.fishPond = fishPond;
        return this;
    }

    public long getQq() {
        return this.qq;
    }

    public String getName() {
        return this.name;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public double getMoney() {
        return this.money;
    }

    public int getFishRodLevel() {
        return this.fishRodLevel;
    }

    public Date getDate() {
        return this.date;
    }

    public void setQq(long qq) {
        this.qq = qq;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public void setFishRodLevel(int fishRodLevel) {
        this.fishRodLevel = fishRodLevel;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

