/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity.redpack;

import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Entity(name="RedPack")
@Table(name="RedPack")
public class RedPack {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer id;
    private String name;
    private Long groupId;
    private Long sender;
    private Double money;
    private Integer number;
    private Date createTime;
    private boolean isRandomPack;
    private Double takenMoneys;
    private String receivers;
    private String randomRedPack;
    @Transient
    private List<Long> receiverList;
    @Transient
    private List<Double> randomPackList;

    public RedPack setReceiverList(List<Long> receiverList) {
        this.receiverList = receiverList;
        this.receivers = receiverList.stream().map(Object::toString).collect(Collectors.joining(","));
        return this;
    }

    public List<Long> getReceiverList() {
        if (StrUtil.isNotBlank((CharSequence)this.receivers)) {
            for (String s : this.receivers.split(",")) {
                this.receiverList.add(Long.parseLong(s));
            }
        }
        return this.receiverList;
    }

    public RedPack setRandomPackList(List<Double> randomPackList) {
        this.randomPackList = randomPackList;
        this.randomRedPack = randomPackList.stream().map(it -> (double)Math.round(it * 10.0) / 10.0).map(Object::toString).collect(Collectors.joining(","));
        return this;
    }

    public List<Double> getRandomPackList() {
        if (StrUtil.isNotBlank((CharSequence)this.randomRedPack)) {
            for (String s : this.randomRedPack.split(",")) {
                this.randomPackList.add(Double.parseDouble(s));
            }
        }
        return this.randomPackList;
    }

    @NotNull
    public Double getRandomPack() {
        if (this.randomRedPack.isBlank()) {
            throw new RuntimeException("\u7ea2\u5305\u5df2\u7ecf\u88ab\u9886\u5e72\u51c0\u4e86\uff0c\u4f46\u4ecd\u7136\u5728\u9886\u53d6!");
        }
        if (this.getRandomPackList().isEmpty()) {
            throw new RuntimeException("\u7ea2\u5305\u5df2\u7ecf\u88ab\u9886\u5e72\u51c0\u4e86\uff0c\u4f46\u4ecd\u7136\u5728\u9886\u53d6!");
        }
        int index = RandomUtil.randomInt((int)0, (int)this.randomPackList.size());
        Double v = this.randomPackList.get(index);
        this.randomPackList.remove(v);
        this.setRandomPackList(this.randomPackList);
        HibernateFactory.merge((Object)this);
        return v;
    }

    public boolean isRandomPack() {
        return this.isRandomPack;
    }

    public RedPack setRandomPack(boolean randomPack) {
        this.isRandomPack = randomPack;
        return this;
    }

    public String toString() {
        return "RedPack{id=" + this.id + ", name='" + this.name + "', groupId=" + this.groupId + ", sender=" + this.sender + ", money=" + this.money + ", number=" + this.number + ", createTime=" + this.createTime + ", isRandomPack=" + this.isRandomPack + ", takenMoneys=" + this.takenMoneys + ", receivers='" + this.receivers + "', randomRedPack='" + this.randomRedPack + "', receiverList=" + this.receiverList + ", randomPackList=" + this.randomPackList + "}";
    }

    private static Double $default$takenMoneys() {
        return 0.0;
    }

    private static List<Long> $default$receiverList() {
        return new ArrayList<Long>();
    }

    private static List<Double> $default$randomPackList() {
        return new ArrayList<Double>();
    }

    public static RedPackBuilder builder() {
        return new RedPackBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Long getSender() {
        return this.sender;
    }

    public Double getMoney() {
        return this.money;
    }

    public Integer getNumber() {
        return this.number;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Double getTakenMoneys() {
        return this.takenMoneys;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public String getRandomRedPack() {
        return this.randomRedPack;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public void setSender(Long sender) {
        this.sender = sender;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setTakenMoneys(Double takenMoneys) {
        this.takenMoneys = takenMoneys;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public void setRandomRedPack(String randomRedPack) {
        this.randomRedPack = randomRedPack;
    }

    public RedPack(Integer id, String name, Long groupId, Long sender, Double money, Integer number, Date createTime, boolean isRandomPack, Double takenMoneys, String receivers, String randomRedPack, List<Long> receiverList, List<Double> randomPackList) {
        this.id = id;
        this.name = name;
        this.groupId = groupId;
        this.sender = sender;
        this.money = money;
        this.number = number;
        this.createTime = createTime;
        this.isRandomPack = isRandomPack;
        this.takenMoneys = takenMoneys;
        this.receivers = receivers;
        this.randomRedPack = randomRedPack;
        this.receiverList = receiverList;
        this.randomPackList = randomPackList;
    }

    public RedPack() {
        this.takenMoneys = RedPack.$default$takenMoneys();
        this.receiverList = RedPack.$default$receiverList();
        this.randomPackList = RedPack.$default$randomPackList();
    }

    public static class RedPackBuilder {
        private Integer id;
        private String name;
        private Long groupId;
        private Long sender;
        private Double money;
        private Integer number;
        private Date createTime;
        private boolean isRandomPack;
        private boolean takenMoneys$set;
        private Double takenMoneys$value;
        private String receivers;
        private String randomRedPack;
        private boolean receiverList$set;
        private List<Long> receiverList$value;
        private boolean randomPackList$set;
        private List<Double> randomPackList$value;

        RedPackBuilder() {
        }

        public RedPackBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public RedPackBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RedPackBuilder groupId(Long groupId) {
            this.groupId = groupId;
            return this;
        }

        public RedPackBuilder sender(Long sender) {
            this.sender = sender;
            return this;
        }

        public RedPackBuilder money(Double money) {
            this.money = money;
            return this;
        }

        public RedPackBuilder number(Integer number) {
            this.number = number;
            return this;
        }

        public RedPackBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public RedPackBuilder isRandomPack(boolean isRandomPack) {
            this.isRandomPack = isRandomPack;
            return this;
        }

        public RedPackBuilder takenMoneys(Double takenMoneys) {
            this.takenMoneys$value = takenMoneys;
            this.takenMoneys$set = true;
            return this;
        }

        public RedPackBuilder receivers(String receivers) {
            this.receivers = receivers;
            return this;
        }

        public RedPackBuilder randomRedPack(String randomRedPack) {
            this.randomRedPack = randomRedPack;
            return this;
        }

        public RedPackBuilder receiverList(List<Long> receiverList) {
            this.receiverList$value = receiverList;
            this.receiverList$set = true;
            return this;
        }

        public RedPackBuilder randomPackList(List<Double> randomPackList) {
            this.randomPackList$value = randomPackList;
            this.randomPackList$set = true;
            return this;
        }

        public RedPack build() {
            Double takenMoneys$value = this.takenMoneys$value;
            if (!this.takenMoneys$set) {
                takenMoneys$value = RedPack.$default$takenMoneys();
            }
            List<Long> receiverList$value = this.receiverList$value;
            if (!this.receiverList$set) {
                receiverList$value = RedPack.$default$receiverList();
            }
            List<Double> randomPackList$value = this.randomPackList$value;
            if (!this.randomPackList$set) {
                randomPackList$value = RedPack.$default$randomPackList();
            }
            return new RedPack(this.id, this.name, this.groupId, this.sender, this.money, this.number, this.createTime, this.isRandomPack, takenMoneys$value, this.receivers, this.randomRedPack, receiverList$value, randomPackList$value);
        }

        public String toString() {
            return "RedPack.RedPackBuilder(id=" + this.id + ", name=" + this.name + ", groupId=" + this.groupId + ", sender=" + this.sender + ", money=" + this.money + ", number=" + this.number + ", createTime=" + this.createTime + ", isRandomPack=" + this.isRandomPack + ", takenMoneys$value=" + this.takenMoneys$value + ", receivers=" + this.receivers + ", randomRedPack=" + this.randomRedPack + ", receiverList$value=" + this.receiverList$value + ", randomPackList$value=" + this.randomPackList$value + ")";
        }
    }
}

