/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.entity.title;

import cn.chahuyun.economy.entity.TitleInfo;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.title.TitleApi;

public abstract class TitleTemplate
implements TitleApi {
    private final String templateCode;
    private final String titleName;
    private final Integer validityPeriod;
    private final Boolean canIBuy;
    private final Double price;

    public TitleTemplate(String templateCode, String titleName, Integer validityPeriod, Boolean canIBuy, Double price) {
        this.templateCode = templateCode;
        this.titleName = titleName;
        this.validityPeriod = validityPeriod;
        this.canIBuy = canIBuy != null && canIBuy != false;
        this.price = price;
    }

    @Override
    public TitleInfo createTitleInfo(UserInfo userInfo) {
        return TitleInfo.builder().userId(userInfo.getQq()).code(this.templateCode).name(this.titleName).build();
    }

    public String getTemplateCode() {
        return this.templateCode;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public Integer getValidityPeriod() {
        return this.validityPeriod;
    }

    public Boolean getCanIBuy() {
        return this.canIBuy;
    }

    public Double getPrice() {
        return this.price;
    }
}

