/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.event;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.config.EconomyConfig;
import cn.chahuyun.economy.manager.PropsManager;
import cn.chahuyun.economy.plugin.PluginManager;
import cn.chahuyun.economy.utils.Log;
import java.util.regex.Pattern;
import kotlin.coroutines.CoroutineContext;
import net.mamoe.mirai.contact.BotIsBeingMutedException;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MessageTooLargeException;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.EventHandler;
import net.mamoe.mirai.event.SimpleListenerHost;
import net.mamoe.mirai.event.events.EventCancelledException;
import net.mamoe.mirai.event.events.MessageEvent;
import org.jetbrains.annotations.NotNull;

public class MessageEventListener
extends SimpleListenerHost {
    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        if (exception instanceof EventCancelledException) {
            Log.error("\u53d1\u9001\u6d88\u606f\u88ab\u53d6\u6d88:", exception);
        } else if (exception instanceof BotIsBeingMutedException) {
            Log.error("\u4f60\u7684\u673a\u5668\u4eba\u88ab\u7981\u8a00:", exception);
        } else if (exception instanceof MessageTooLargeException) {
            Log.error("\u53d1\u9001\u6d88\u606f\u8fc7\u957f:", exception);
        } else if (exception instanceof IllegalArgumentException) {
            Log.error("\u53d1\u9001\u6d88\u606f\u4e3a\u7a7a:", exception);
        }
        Log.error(exception.getCause());
    }

    @EventHandler
    public void onMessage(@NotNull MessageEvent event) {
        EconomyConfig config = HuYanEconomy.config;
        User sender = event.getSender();
        boolean owner = config.getOwner() == sender.getId();
        Contact subject = event.getSubject();
        Group group = null;
        if (subject instanceof Group) {
            group = (Group)subject;
        }
        String code = event.getMessage().serializeToMiraiCode();
        PropsManager propsManager = PluginManager.getPropsManager();
        if (!config.getPrefix().isBlank()) {
            if (!code.startsWith(config.getPrefix())) {
                return;
            }
            code = code.substring(1);
        }
        switch (code) {
            case "\u80cc\u5305": 
            case "backpack": {
                Log.info("\u80cc\u5305\u6307\u4ee4");
                propsManager.viewUserBackpack(event);
                return;
            }
            case "\u9053\u5177\u5546\u5e97": 
            case "shops": {
                Log.info("\u9053\u5177\u5546\u5e97\u6307\u4ee4");
                propsManager.propStore(event);
                return;
            }
        }
        String buyPropRegex = "\u8d2d\u4e70 (\\S+)( \\S+)?|buy (\\S+)( \\S+)?";
        if (Pattern.matches(buyPropRegex, code)) {
            Log.info("\u8d2d\u4e70\u6307\u4ee4");
            propsManager.buyPropFromStore(event);
            return;
        }
        String userPropRegex = "\u4f7f\u7528 (\\S+)( \\S+)?|use (\\S+)( \\S+)?";
        if (Pattern.matches(userPropRegex, code)) {
            Log.info("\u4f7f\u7528\u6307\u4ee4");
            propsManager.userProp(event);
            return;
        }
    }
}

