/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.bank.BankInfo;
import cn.chahuyun.economy.manager.UserManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.DateUtil;
import cn.hutool.cron.task.Task;
import java.util.List;
import java.util.Map;
import xyz.cssxsh.mirai.economy.service.EconomyAccount;

class BankInterestTask
implements Task {
    private final String id;
    private final List<BankInfo> bankList;

    public BankInterestTask(String id, List<BankInfo> bankList) {
        this.id = id;
        this.bankList = bankList;
    }

    public void execute() {
        for (BankInfo bankInfo : this.bankList) {
            if (bankInfo.isInterestSwitch() && DateUtil.thisDayOfWeek() == 2) {
                bankInfo.setInterest(BankInfo.randomInterest());
            }
            if (bankInfo.getId() != 1) continue;
            int interest = bankInfo.getInterest();
            Map<EconomyAccount, Double> accountByBank = EconomyUtil.getAccountByBank();
            for (Map.Entry<EconomyAccount, Double> entry : accountByBank.entrySet()) {
                UserInfo userInfo = UserManager.getUserInfo(entry.getKey());
                double v = entry.getValue() * ((double)interest / 100.0);
                v = Double.parseDouble(String.format("%.1f", v));
                if (EconomyUtil.plusMoneyToBankForAccount(entry.getKey(), v)) {
                    userInfo.setBankEarnings(v);
                    HibernateFactory.merge((Object)userInfo);
                    continue;
                }
                Log.error("\u94f6\u884c\u5229\u606f\u7ba1\u7406:" + this.id + "\u6dfb\u52a0\u5229\u606f\u51fa\u9519");
            }
        }
    }
}

