/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.authorize.constant.MessageMatchingEnum;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.bank.BankInfo;
import cn.chahuyun.economy.manager.BankInterestTask;
import cn.chahuyun.economy.manager.UserManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.PlainText;
import xyz.cssxsh.mirai.economy.service.EconomyAccount;

@EventComponent
public class BankManager {
    public static void init() {
        BankInfo one = (BankInfo)HibernateFactory.selectOne(BankInfo.class, (Object)1);
        if (one == null) {
            BankInfo bankInfo = new BankInfo("global", "\u4e3b\u94f6\u884c", "\u7ecf\u6d4e\u670d\u52a1", HuYanEconomy.config.getOwner(), 0.0);
            HibernateFactory.merge((Object)bankInfo);
        }
        List bankInfos = null;
        try {
            bankInfos = HibernateFactory.selectList(BankInfo.class);
        }
        catch (Exception e) {
            Log.error("\u94f6\u884c\u7ba1\u7406:\u5229\u606f\u52a0\u8f7d\u51fa\u9519!", e);
        }
        BankInterestTask bankInterestTask = new BankInterestTask("bank", bankInfos);
        CronUtil.schedule((String)"bank", (String)"0 0 0 * * ?", (Task)bankInterestTask);
    }

    @MessageAuthorize(text={"\u5b58\u6b3e \\d+|deposit \\d+"}, messageMatching=MessageMatchingEnum.REGULAR)
    public static void deposit(MessageEvent event) {
        UserInfo userInfo = UserManager.getUserInfo(event.getSender());
        User user = userInfo.getUser();
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        MessageChainBuilder singleMessages = MessageUtil.quoteReply(message);
        String code = message.serializeToMiraiCode();
        int money = Integer.parseInt(code.split(" ")[1]);
        double moneyByUser = EconomyUtil.getMoneyByUser(user);
        if (moneyByUser - (double)money < 0.0) {
            singleMessages.append((CharSequence)String.format("\u4f60\u7684\u91d1\u5e01\u4e0d\u591f%s\u4e86", money));
            subject.sendMessage((Message)singleMessages.build());
            return;
        }
        if (EconomyUtil.turnUserToBank(user, money)) {
            singleMessages.append((CharSequence)"\u5b58\u6b3e\u6210\u529f!");
            subject.sendMessage((Message)singleMessages.build());
        } else {
            singleMessages.append((CharSequence)"\u5b58\u6b3e\u5931\u8d25!");
            subject.sendMessage((Message)singleMessages.build());
            Log.error("\u94f6\u884c\u7ba1\u7406:\u5b58\u6b3e\u5931\u8d25!");
        }
    }

    @MessageAuthorize(text={"\u53d6\u6b3e \\d+|withdraw \\d+"}, messageMatching=MessageMatchingEnum.REGULAR)
    public static void withdrawal(MessageEvent event) {
        UserInfo userInfo = UserManager.getUserInfo(event.getSender());
        User user = userInfo.getUser();
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        MessageChainBuilder singleMessages = MessageUtil.quoteReply(message);
        String code = message.serializeToMiraiCode();
        int money = Integer.parseInt(code.split(" ")[1]);
        double moneyByBank = EconomyUtil.getMoneyByBank(user);
        if (moneyByBank - (double)money < 0.0) {
            singleMessages.append((CharSequence)String.format("\u4f60\u7684\u94f6\u884c\u4f59\u989d\u4e0d\u591f%s\u679a\u91d1\u5e01\u4e86", money));
            subject.sendMessage((Message)singleMessages.build());
            return;
        }
        if (EconomyUtil.turnBankToUser(user, money)) {
            singleMessages.append((CharSequence)"\u53d6\u6b3e\u6210\u529f!");
            subject.sendMessage((Message)singleMessages.build());
        } else {
            singleMessages.append((CharSequence)"\u53d6\u6b3e\u5931\u8d25!");
            subject.sendMessage((Message)singleMessages.build());
            Log.error("\u94f6\u884c\u7ba1\u7406:\u53d6\u6b3e\u5931\u8d25!");
        }
    }

    @MessageAuthorize(text={"\u672c\u5468\u5229\u7387", "\u94f6\u884c\u5229\u7387"})
    public static void viewBankInterest(MessageEvent event) {
        Log.info("\u94f6\u884c\u6307\u4ee4");
        BankInfo bankInfo = (BankInfo)HibernateFactory.selectOne(BankInfo.class, (Object)1);
        event.getSubject().sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u5468\u94f6\u884c\u5229\u7387\u662f%s%%", bankInfo.getInterest()));
    }

    @MessageAuthorize(text={"\u5bcc\u8c6a\u699c", "\u7ecf\u6d4e\u6392\u884c"})
    public static void viewRegalTop(MessageEvent event) {
        Log.info("\u7ecf\u6d4e\u6307\u4ee4");
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        ForwardMessageBuilder builder = new ForwardMessageBuilder(subject);
        builder.add((UserOrBot)bot, (Message)new PlainText("\u4ee5\u4e0b\u662f\u94f6\u884c\u5b58\u6b3e\u6392\u884c\u699c:"));
        Map<EconomyAccount, Double> accountByBank = EconomyUtil.getAccountByBank();
        LinkedHashMap collect = accountByBank.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        int index = 1;
        for (Map.Entry entry : collect.entrySet()) {
            UserInfo userInfo = UserManager.getUserInfo((EconomyAccount)entry.getKey());
            Group group = bot.getGroup(userInfo.getRegisterGroup());
            String name = group == null ? String.valueOf(userInfo.getRegisterGroup()) : group.getName();
            PlainText plainText = MessageUtil.formatMessage("top:%d%n\u7528\u6237:%s%n\u6ce8\u518c\u7fa4:%s%n\u5b58\u6b3e:%.1f", index++, userInfo.getName(), name, entry.getValue());
            builder.add((UserOrBot)bot, (Message)plainText);
        }
        subject.sendMessage((Message)builder.build());
    }
}

