/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.authorize.entity.Perm;
import cn.chahuyun.authorize.entity.PermGroup;
import cn.chahuyun.authorize.utils.PermUtil;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.constant.FishPondLevelConstant;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.fish.Fish;
import cn.chahuyun.economy.entity.fish.FishInfo;
import cn.chahuyun.economy.entity.fish.FishPond;
import cn.chahuyun.economy.entity.fish.FishRanking;
import cn.chahuyun.economy.manager.TitleManager;
import cn.chahuyun.economy.manager.UserManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.economy.utils.ShareUtils;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageUtils;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

@EventComponent
public class GamesManager {
    private static final Map<Long, Date> playerCooling = new HashMap<Long, Date>();

    public static void init() {
        Task task = new Task(){

            public void execute() {
                List pondType = HibernateFactory.selectList(FishPond.class, (String)"pondType", (Object)1);
                for (FishPond fishPond : pondType) {
                    double fishPondMoney = fishPond.getFishPondMoney();
                    int level = fishPond.getPondLevel() - 1;
                    FishPondLevelConstant value = FishPondLevelConstant.values()[level];
                    if (!(fishPondMoney >= (double)value.getAmount()) || !EconomyUtil.plusMoneyToBankForId(fishPond.getCode(), fishPond.getDescription(), -30000.0)) continue;
                    Bot bot = HuYanEconomy.INSTANCE.bot;
                    Group group = bot.getGroup((long)fishPond.getId());
                    if (group != null) {
                        group.sendMessage(String.format("\u9c7c\u5858 %s \u5df2\u7ecf\u79ef\u6512\u591f\u4e86\u5347\u7ea7\u7684\u8d44\u91d1\uff01\u5f00\u59cb\u5347\u7ea7\u9c7c\u5858\u4e86\uff01%n\u9c7c\u5858\u7b49\u7ea7:%d -> %d%n\u6700\u4f4e\u9c7c\u7aff\u7b49\u7ea7:%d", fishPond.getName(), level + 1, level + 2, value.getMinFishLevel()));
                    } else {
                        Objects.requireNonNull(bot.getFriend(fishPond.getAdmin())).sendMessage("\u7fa4\u9c7c\u5858\u5347\u7ea7\u4e86");
                    }
                    fishPond.setPondLevel(level + 2);
                    fishPond.setMinLevel(value.getMinFishLevel());
                    fishPond.save();
                }
            }
        };
        CronUtil.schedule((String)"0 0 12 * * ?", (Task)task);
    }

    @MessageAuthorize(text={"\u9493\u9c7c", "\u629b\u7aff"}, groupPermissions={"fish"})
    public static void fishing(GroupMessageEvent event) {
        int size;
        List collect;
        int difficulty;
        Log.info("\u9493\u9c7c\u6307\u4ee4");
        UserInfo userInfo = UserManager.getUserInfo((User)event.getSender());
        User user = userInfo.getUser();
        Group subject = event.getSubject();
        FishInfo fishInfo = userInfo.getFishInfo();
        if (fishInfo == null || !fishInfo.isFishRod()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getNoneRodMsg(), new Object[0]));
            return;
        }
        if (fishInfo.getStatus()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getFishingNowMsg(), new Object[0]));
            return;
        }
        boolean isFishing = TitleManager.checkTitleIsExist(userInfo, "fishing");
        if (playerCooling.containsKey(userInfo.getQq())) {
            Date date = playerCooling.get(userInfo.getQq());
            long between = DateUtil.between((Date)date, (Date)new Date(), (DateUnit)DateUnit.MINUTE, (boolean)true);
            int expired = 10;
            expired = isFishing ? 3 : (expired * 60 - fishInfo.getRodLevel() * 3) / 60;
            if (between < (long)expired) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4f60\u8fd8\u5dee%s\u5206\u949f\u6765\u629b\u7b2c\u4e8c\u6746!", (long)expired - between));
                return;
            }
            playerCooling.remove(userInfo.getQq());
        } else {
            playerCooling.put(userInfo.getQq(), new Date());
        }
        if (fishInfo.isStatus()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getFishingNowMsg(), new Object[0]));
            return;
        }
        FishPond fishPond = fishInfo.getFishPond(subject);
        if (fishPond == null) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u9ed8\u8ba4\u9c7c\u5858\u4e0d\u5b58\u5728!", new Object[0]));
            return;
        }
        int minLevel = fishPond.getMinLevel();
        if (fishInfo.getRodLevel() < minLevel) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getRodLevelNotEnough(), new Object[0]));
            return;
        }
        String start = String.format("%s\u5f00\u59cb\u9493\u9c7c\n\u9c7c\u5858:%s\n\u7b49\u7ea7:%s\n\u6700\u4f4e\u9c7c\u7aff\u7b49\u7ea7:%s\n%s", userInfo.getName(), fishPond.getName(), fishPond.getPondLevel(), fishPond.getMinLevel(), fishPond.getDescription());
        subject.sendMessage(start);
        Log.info(String.format("%s\u5f00\u59cb\u9493\u9c7c", userInfo.getName()));
        boolean theRod = false;
        int difficultyMin = 0;
        int difficultyMax = 101;
        int rankMin = 1;
        int rankMax = 1;
        String[] successMessages = new String[]{"\u8fd9\u4e0d\u8f7b\u8f7b\u677e\u677e\u561b~", "\u8fd9\u9c7c\u8fd8\u6ca1\u53d1\u529b\uff01", "\u6162\u6162\u7684\u3001\u6162\u6162\u7684..."};
        String[] failureMessages = new String[]{"\u6302\u5e95\u4e86\u5417\uff1f", "\u600e\u4e48\u8fd9\u4e48\u6709\u52b2\uff1f\u96be\u9053\u662f\u5927\u9c7c\uff1f", "\u5367\u69fd\uff01\u5367\u69fd\uff01\u5367\u69fd\uff01"};
        String[] otherMessages = new String[]{"\u9493\u9c7c\u5c31\u662f\u8fd9\u4e48\u7b80\u5355", "\u4e00\u6761\u5c0f\u9c7c\u4e5f\u6562\u73ed\u95e8\u5f04\u65a7\uff01", "\u6536\uff01\u6536\uff01\u6536\uff01~~"};
        String[] errorMessages = new String[]{"\u98ce\u5439\u7684...", "\u773c\u82b1\u4e86...", "\u8d70\u795e\u4e86...", "\u5440\uff01\u5207\u7ebf\u4e86...", "\u9493\u9c7c\u4f6c\u7edd\u4e0d\u7a7a\u519b\uff01"};
        try {
            Thread.sleep(RandomUtil.randomInt((int)5000, (int)(isFishing ? 60000 : 200000)));
        }
        catch (InterruptedException e) {
            Log.debug(e);
        }
        subject.sendMessage((Message)MessageUtils.newChain((Message[])new Message[]{new At(user.getId()), new PlainText("\u6709\u52a8\u9759\u4e86\uff0c\u5feb\u6765\uff01")}));
        boolean rankStatus = true;
        int pull = 0;
        boolean put = false;
        while (rankStatus) {
            MessageEvent newMessage = ShareUtils.getNextMessageEventFromUser(user, (Contact)subject);
            if (newMessage == null) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(user.getId(), "\u4f60\u7684\u9c7c\u8dd1\u4e86\uff01\uff01", new Object[0]));
                fishInfo.switchStatus();
                return;
            }
            MessageChain nextMessage = newMessage.getMessage();
            String nextMessageCode = nextMessage.serializeToMiraiCode();
            int randomDifficultyInt = RandomUtil.randomInt((int)0, (int)4);
            int randomLevelInt = RandomUtil.randomInt((int)0, (int)4);
            int message = RandomUtil.randomInt((int)0, (int)3);
            switch (nextMessageCode) {
                case "\u5411\u5de6\u62c9": 
                case "\u5de6": 
                case "1": {
                    if (randomDifficultyInt % 2 == 1) {
                        difficultyMin += 15;
                        subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, successMessages[message], new Object[0]));
                    } else {
                        difficultyMin -= 18;
                        subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, failureMessages[message], new Object[0]));
                    }
                    ++pull;
                    break;
                }
                case "\u5411\u53f3\u62c9": 
                case "\u53f3": 
                case "2": {
                    if (randomDifficultyInt % 2 == 0) {
                        difficultyMin += 15;
                        subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, successMessages[message], new Object[0]));
                    } else {
                        difficultyMin -= 18;
                        subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, failureMessages[message], new Object[0]));
                    }
                    ++pull;
                    break;
                }
                case "\u6536\u7ebf": 
                case "\u62c9": 
                case "0": {
                    if (randomLevelInt % 2 == 0) {
                        difficultyMin += 18;
                        subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, otherMessages[message], new Object[0]));
                    } else {
                        difficultyMin -= 20;
                        subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, failureMessages[message], new Object[0]));
                    }
                    ++rankMax;
                    ++pull;
                    break;
                }
                case "\u653e\u7ebf": 
                case "\u653e": 
                case "~": {
                    if (pull > 0) {
                        difficultyMin += 15;
                        rankMax = 1;
                        --pull;
                    } else {
                        --rankMax;
                    }
                    subject.sendMessage((Message)MessageUtil.formatMessageChain(nextMessage, "\u4f60\u628a\u4f60\u6536\u56de\u6765\u7684\u7ebf\uff0c\u53c8\u653e\u4e86\u51fa\u53bb!", new Object[0]));
                    break;
                }
                default: {
                    if (!Pattern.matches("[!\uff01\u6536\u8d77\u63d0\u7aff\u6746]{1,2}", nextMessageCode)) break;
                    if (pull == 0) {
                        theRod = true;
                    }
                    rankStatus = false;
                }
            }
            ++pull;
        }
        if (theRod && RandomUtil.randomInt((int)0, (int)101) >= 50) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(user.getId(), errorMessages[RandomUtil.randomInt((int)0, (int)5)], new Object[0]));
            fishInfo.switchStatus();
            return;
        }
        rankMin = Math.max(fishInfo.getLevel() / 5 + 1, rankMin);
        rankMax = Math.max(rankMin + 1, Math.min(fishInfo.getLevel(), Math.min(fishPond.getPondLevel(), rankMax)));
        difficultyMax = Math.max(difficultyMin + 1, difficultyMax + fishInfo.getRodLevel());
        int rank = RandomUtil.randomInt((int)rankMin, (int)(rankMax + 1));
        Log.debug("\u9493\u9c7c\u7ba1\u7406:roll\u7b49\u7ea7min" + rankMin);
        Log.debug("\u9493\u9c7c\u7ba1\u7406:roll\u7b49\u7ea7max" + rankMax);
        Log.debug("\u9493\u9c7c\u7ba1\u7406:roll\u7b49\u7ea7" + rank);
        boolean winning = false;
        while (true) {
            if (rank == 0) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(user.getId(), " \u5207\u7ebf\u4e86\u6211\u53bb\uff01", new Object[0]));
                fishInfo.switchStatus();
                return;
            }
            difficulty = RandomUtil.randomInt((int)difficultyMin, (int)difficultyMax);
            Log.debug("\u9493\u9c7c\u7ba1\u7406:\u7b49\u7ea7:" + rank + "-roll\u96be\u5ea6min" + difficultyMin);
            Log.debug("\u9493\u9c7c\u7ba1\u7406:\u7b49\u7ea7:" + rank + "-roll\u96be\u5ea6max" + difficultyMax);
            Log.debug("\u9493\u9c7c\u7ba1\u7406:\u7b49\u7ea7:" + rank + "-roll\u96be\u5ea6" + difficulty);
            List<Fish> levelFishList = fishPond.getFishList(rank);
            collect = levelFishList.stream().filter(it -> it.getDifficulty() <= difficulty).sorted(Comparator.comparing(Fish::getDescription)).collect(Collectors.toList());
            size = collect.size();
            if (size != 0) break;
            --rank;
        }
        if (difficulty >= 200) {
            winning = true;
        }
        Fish fish = (Fish)collect.get(RandomUtil.randomInt((int)0, (int)Math.min(6, size)));
        int dimensions = fish.getDimensions(winning);
        int money = fish.getPrice() * dimensions;
        double v = (double)money * (1.0 - fishPond.getRebate());
        if (EconomyUtil.plusMoneyToUser(user, v) && EconomyUtil.plusMoneyToBankForId(fishPond.getCode(), fishPond.getDescription(), (double)money * fishPond.getRebate())) {
            fishPond.addNumber();
            String format = String.format("\n\u8d77\u7aff\u54af\uff01\n%s\n\u7b49\u7ea7:%s\n\u5355\u4ef7:%s\n\u5c3a\u5bf8:%d\n\u603b\u91d1\u989d:%d\n%s", fish.getName(), fish.getLevel(), fish.getPrice(), dimensions, money, fish.getDescription());
            MessageChainBuilder messages = new MessageChainBuilder();
            messages.append((SingleMessage)new At(userInfo.getQq())).append((SingleMessage)new PlainText(format));
            subject.sendMessage((Message)messages.build());
        } else {
            subject.sendMessage("\u9493\u9c7c\u5931\u8d25!");
            playerCooling.remove(userInfo.getQq());
        }
        fishInfo.switchStatus();
        FishRanking fishRanking = new FishRanking(userInfo.getQq(), userInfo.getName(), dimensions, money, fishInfo.getRodLevel(), fish, fishPond);
        HibernateFactory.merge((Object)fishRanking);
        TitleManager.checkFishTitle(userInfo, (Contact)subject);
    }

    @MessageAuthorize(text={"\u8d2d\u4e70\u9c7c\u7aff"}, groupPermissions={"fish"})
    public static void buyFishRod(MessageEvent event) {
        Log.info("\u8d2d\u4e70\u9c7c\u7aff\u6307\u4ee4");
        UserInfo userInfo = UserManager.getUserInfo(event.getSender());
        if (userInfo == null) {
            return;
        }
        User user = userInfo.getUser();
        FishInfo fishInfo = userInfo.getFishInfo();
        Contact subject = event.getSubject();
        if (fishInfo.isFishRod()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getRepeatPurchaseRod(), new Object[0]));
            return;
        }
        double moneyByUser = EconomyUtil.getMoneyByUser(user);
        if (moneyByUser - 500.0 < 0.0) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getCoinNotEnoughForRod(), new Object[0]));
            return;
        }
        if (EconomyUtil.minusMoneyToUser(user, 500.0)) {
            fishInfo.setFishRod(true);
            HibernateFactory.merge((Object)fishInfo);
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getBuyFishingRodSuccess(), new Object[0]));
        } else {
            Log.error("\u6e38\u620f\u7ba1\u7406:\u8d2d\u4e70\u9c7c\u7aff\u5931\u8d25!");
        }
    }

    @MessageAuthorize(text={"\u5347\u7ea7\u9c7c\u7aff"}, groupPermissions={"fish"})
    public static void upFishRod(MessageEvent event) {
        Log.info("\u5347\u7ea7\u9c7c\u7aff\u6307\u4ee4");
        UserInfo userInfo = UserManager.getUserInfo(event.getSender());
        Contact subject = event.getSubject();
        FishInfo fishInfo = userInfo.getFishInfo();
        if (!fishInfo.isFishRod()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getNoneRodUpgradeMsg(), new Object[0]));
            return;
        }
        if (fishInfo.getStatus()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), HuYanEconomy.msgConfig.getUpgradeWhenFishing(), new Object[0]));
            return;
        }
        SingleMessage singleMessage = fishInfo.updateRod(userInfo);
        subject.sendMessage((Message)singleMessage);
    }

    @MessageAuthorize(text={"\u9493\u9c7c\u699c", "\u9493\u9c7c\u6392\u884c"})
    public static void fishTop(MessageEvent event) {
        Log.info("\u9493\u9c7c\u699c\u6307\u4ee4");
        Bot bot = event.getBot();
        Contact subject = event.getSubject();
        List<FishRanking> rankingList = HibernateFactory.selectList(FishRanking.class);
        rankingList.sort(Comparator.comparing(FishRanking::getMoney).reversed());
        List<FishRanking> list = rankingList = rankingList.isEmpty() ? rankingList : rankingList.subList(0, Math.min(rankingList.size(), 30));
        if (rankingList.isEmpty()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u6682\u65f6\u6ca1\u4eba\u9493\u9c7c!", new Object[0]));
            return;
        }
        ForwardMessageBuilder iNodes = new ForwardMessageBuilder(subject);
        iNodes.add((UserOrBot)bot, (Message)new PlainText("\u9493\u9c7c\u6392\u884c\u699c:"));
        int start = 0;
        int end = 10;
        for (int i = start; i < end && i < rankingList.size(); ++i) {
            FishRanking ranking = (FishRanking)rankingList.get(i);
            iNodes.add((UserOrBot)bot, (Message)ranking.getInfo(i));
        }
        subject.sendMessage((Message)iNodes.build());
    }

    @MessageAuthorize(text={"\u5237\u65b0\u9493\u9c7c"}, userPermissions={"owner", "admin"}, groupPermissions={"fish"})
    public static void refresh(MessageEvent event) {
        Log.info("\u5237\u65b0\u9493\u9c7c\u6307\u4ee4");
        Boolean status = (Boolean)HibernateFactory.getSession().fromTransaction(session -> {
            List list;
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            JpaCriteriaQuery query = builder.createQuery(FishInfo.class);
            JpaRoot from = query.from(FishInfo.class);
            query.select((Selection)from);
            query.where((Expression)builder.equal((Expression)from.get("status"), (Object)true));
            try {
                list = session.createQuery((CriteriaQuery)query).list();
            }
            catch (Exception e) {
                return false;
            }
            for (FishInfo fishInfo : list) {
                fishInfo.setStatus(false);
                session.merge((Object)fishInfo);
            }
            return true;
        });
        playerCooling.clear();
        if (status.booleanValue()) {
            event.getSubject().sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u9493\u9c7c\u72b6\u6001\u5237\u65b0\u6210\u529f!", new Object[0]));
        } else {
            event.getSubject().sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u9493\u9c7c\u72b6\u6001\u5237\u65b0\u5931\u8d25!", new Object[0]));
        }
    }

    @MessageAuthorize(text={"\u9c7c\u7aff\u7b49\u7ea7"}, groupPermissions={"fish"})
    public static void viewFishLevel(MessageEvent event) {
        Log.info("\u9c7c\u7aff\u7b49\u7ea7\u6307\u4ee4");
        int rodLevel = Objects.requireNonNull(UserManager.getUserInfo(event.getSender())).getFishInfo().getRodLevel();
        event.getSubject().sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4f60\u7684\u9c7c\u7aff\u7b49\u7ea7\u4e3a%s\u7ea7", rodLevel));
    }

    @MessageAuthorize(text={"\u5f00\u542f \u9493\u9c7c"}, userPermissions={"owner", "admin"})
    public void startFish(GroupMessageEvent event) {
        Log.info("\u7ba1\u7406\u6307\u4ee4");
        Group group = event.getGroup();
        cn.chahuyun.authorize.entity.User user = cn.chahuyun.authorize.entity.User.Companion.group(group.getId());
        PermUtil util = PermUtil.INSTANCE;
        if (util.checkUserHasPerm(user, "fish")) {
            group.sendMessage("\u672c\u7fa4\u7684\u9493\u9c7c\u5df2\u7ecf\u5f00\u542f\u4e86!");
            return;
        }
        if (util.addUserToPermGroupByName(user, "\u9493\u9c7c\u7ec4")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u9493\u9c7c\u5f00\u542f\u6210\u529f!", new Object[0]));
        } else {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u9493\u9c7c\u5f00\u542f\u5931\u8d25!", new Object[0]));
        }
    }

    @MessageAuthorize(text={"\u5173\u95ed \u9493\u9c7c"}, userPermissions={"owner", "admin"})
    public void offFish(GroupMessageEvent event) {
        Log.info("\u7ba1\u7406\u6307\u4ee4");
        Group group = event.getGroup();
        cn.chahuyun.authorize.entity.User user = cn.chahuyun.authorize.entity.User.Companion.group(group.getId());
        PermUtil util = PermUtil.INSTANCE;
        if (!util.checkUserHasPerm(user, "fish")) {
            group.sendMessage("\u672c\u7fa4\u7684\u9493\u9c7c\u5df2\u7ecf\u5173\u95ed\u4e86!");
            return;
        }
        PermGroup permGroup = util.talkPermGroupByName("\u9493\u9c7c\u7ec4");
        Perm perm = util.takePerm("fish");
        permGroup.getPerms().remove(perm);
        permGroup.save();
        group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u9493\u9c7c\u5173\u95ed\u6210\u529f!", new Object[0]));
    }

    @MessageAuthorize(text={"\u9c7c\u5858\u7b49\u7ea7"})
    public void viewFishPond(GroupMessageEvent event) {
        Group group = event.getGroup();
        FishPond fishPond = UserManager.getUserInfo((User)event.getSender()).getFishInfo().getFishPond(group);
        int level = fishPond.getPondLevel();
        FishPondLevelConstant value = FishPondLevelConstant.values()[level - 1];
        double money = EconomyUtil.getMoneyByBankFromId(fishPond.getCode(), null);
        group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u5f53\u524d\u9c7c\u5858\u4fe1\u606f:%n\u9c7c\u5858\u540d\u79f0:%s%n\u9c7c\u5858\u7b49\u7ea7:%d%n\u9c7c\u5858\u6700\u4f4e\u9c7c\u7aff\u7b49\u7ea7:%d%n\u9c7c\u5858\u5347\u7ea7\u6240\u9700\u91d1\u989d:%d%n\u9c7c\u5858\u91d1\u989d:%.1f%n\u9c7c\u5858\u5347\u7ea7\u8fdb\u5ea6:%.1f%%", fishPond.getName(), level, fishPond.getMinLevel(), value.getAmount(), money, (double)value.getAmount() / money));
    }
}

