/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.authorize.constant.MessageMatchingEnum;
import cn.chahuyun.authorize.entity.Perm;
import cn.chahuyun.authorize.entity.PermGroup;
import cn.chahuyun.authorize.utils.PermUtil;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.LotteryInfo;
import cn.chahuyun.economy.manager.LotteryDayTask;
import cn.chahuyun.economy.manager.LotteryHoursTask;
import cn.chahuyun.economy.manager.LotteryMinutesTask;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;

@EventComponent
public class LotteryManager {
    private static final AtomicBoolean minuteTiming = new AtomicBoolean(false);
    private static final AtomicBoolean hoursTiming = new AtomicBoolean(false);

    public static void init() {
        List lotteryInfos;
        try {
            lotteryInfos = HibernateFactory.selectList(LotteryInfo.class);
        }
        catch (Exception e) {
            Log.error("\u5f69\u7968\u7ba1\u7406:\u5f69\u7968\u521d\u59cb\u5316\u5931\u8d25!", e);
            return;
        }
        HashMap<String, LotteryInfo> minutesLottery = new HashMap<String, LotteryInfo>();
        HashMap<String, LotteryInfo> hoursLottery = new HashMap<String, LotteryInfo>();
        HashMap<String, LotteryInfo> dayLottery = new HashMap<String, LotteryInfo>();
        for (LotteryInfo lotteryInfo : lotteryInfos) {
            switch (lotteryInfo.getType()) {
                case 1: {
                    minutesLottery.put(lotteryInfo.getNumber(), lotteryInfo);
                    break;
                }
                case 2: {
                    hoursLottery.put(lotteryInfo.getNumber(), lotteryInfo);
                    break;
                }
                case 3: {
                    dayLottery.put(lotteryInfo.getNumber(), lotteryInfo);
                }
            }
        }
        if (!minutesLottery.isEmpty()) {
            LotteryManager.extractedMinutes();
        }
        if (!hoursLottery.isEmpty()) {
            LotteryManager.extractedHours();
        }
        if (!dayLottery.isEmpty()) {
            String dayTaskId = "dayTask";
            CronUtil.remove((String)dayTaskId);
            LotteryDayTask dayTask = new LotteryDayTask(dayTaskId);
            CronUtil.schedule((String)dayTaskId, (String)"0 0 0 * * ?", (Task)dayTask);
        }
    }

    private static void extractedHours() {
        if (hoursTiming.get()) {
            return;
        }
        String hoursTaskId = "hoursTask";
        CronUtil.remove((String)hoursTaskId);
        LotteryHoursTask hoursTask = new LotteryHoursTask(hoursTaskId);
        CronUtil.schedule((String)hoursTaskId, (String)"0 0 * * * ?", (Task)hoursTask);
        hoursTiming.set(true);
    }

    private static void extractedMinutes() {
        if (minuteTiming.get()) {
            return;
        }
        String minutesTaskId = "minutesTask";
        CronUtil.remove((String)minutesTaskId);
        LotteryMinutesTask minutesTask = new LotteryMinutesTask(minutesTaskId);
        CronUtil.schedule((String)minutesTaskId, (String)"0 * * * * ?", (Task)minutesTask);
        minuteTiming.set(true);
    }

    @MessageAuthorize(text={"\u731c\u7b7e (\\d+)( \\d+)|lottery (\\d+)( \\d+)"}, messageMatching=MessageMatchingEnum.REGULAR, groupPermissions={"lottery"})
    public static void addLottery(GroupMessageEvent event) {
        String typeString;
        int type;
        Log.info("\u5f69\u7968\u6307\u4ee4");
        Member user = event.getSender();
        Group subject = event.getSubject();
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        String[] split = code.split(" ");
        StringBuilder number = new StringBuilder(split[1]);
        double money = Double.parseDouble(split[2]);
        double moneyByUser = EconomyUtil.getMoneyByUser((User)user);
        if (moneyByUser - money <= 0.0) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u90fd\u7a77\u7684\u53ee\u5f53\u54cd\u4e86\uff0c\u8fd8\u6765\u731c\u7b7e\uff1f", new Object[0]));
            return;
        }
        switch (number.length()) {
            case 3: {
                type = 1;
                typeString = "\u5c0f\u7b7e";
                break;
            }
            case 4: {
                type = 2;
                typeString = "\u4e2d\u7b7e";
                break;
            }
            case 5: {
                type = 3;
                typeString = "\u5927\u7b7e";
                break;
            }
            default: {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u731c\u7b7e\u7c7b\u578b\u9519\u8bef!", new Object[0]));
                return;
            }
        }
        if (type == 1) {
            if (!(0.0 < money) || !(money <= 1000.0)) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u6295\u6ce8\u7684\u91d1\u989d\u4e0d\u5c5e\u4e8e\u8fd9\u4e2a\u7b7e!", new Object[0]));
                return;
            }
        } else if (type == 2) {
            if (!(0.0 < money) || !(money <= 10000.0)) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u6295\u6ce8\u7684\u91d1\u989d\u4e0d\u5c5e\u4e8e\u8fd9\u4e2a\u7b7e!", new Object[0]));
                return;
            }
        } else if (!(0.0 < money) || !(money <= 1000000.0)) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u6295\u6ce8\u7684\u91d1\u989d\u4e0d\u5c5e\u4e8e\u8fd9\u4e2a\u7b7e!", new Object[0]));
            return;
        }
        String string = number.toString();
        char[] chars = string.toCharArray();
        number = new StringBuilder(String.valueOf(chars[0]));
        for (int i = 1; i < string.length(); ++i) {
            String aByte = String.valueOf(chars[i]);
            number.append(",").append(aByte);
        }
        LotteryInfo lotteryInfo = new LotteryInfo(user.getId(), subject.getId(), money, type, number.toString());
        if (!EconomyUtil.minusMoneyToUser((User)user, money)) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u731c\u7b7e\u5931\u8d25\uff01", new Object[0]));
            return;
        }
        HibernateFactory.merge((Object)lotteryInfo);
        subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u731c\u7b7e\u6210\u529f:\n\u731c\u7b7e\u7c7b\u578b:%s\n\u731c\u7b7e\u53f7\u7801:%s\n\u731c\u7b7e\u91d1\u5e01:%s", typeString, number, money));
        if (type == 1) {
            LotteryManager.extractedMinutes();
        } else if (type == 2) {
            LotteryManager.extractedHours();
        }
    }

    public static void result(int type, int location, LotteryInfo lotteryInfo) {
        if (location == 0) {
            lotteryInfo.remove();
            return;
        }
        Bot bot = HuYanEconomy.INSTANCE.bot;
        Group group = bot.getGroup(lotteryInfo.getGroup());
        assert (group != null);
        NormalMember member = group.get(lotteryInfo.getQq());
        assert (member != null);
        lotteryInfo.remove();
        if (!EconomyUtil.plusMoneyToUser((User)member, lotteryInfo.getBonus())) {
            member.sendMessage("\u5956\u91d1\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            return;
        }
        member.sendMessage(lotteryInfo.toMessage());
        switch (type) {
            case 1: {
                if (location != 3) break;
                group.sendMessage(String.format("\u5f97\u7b7e\u7740:%s(%s),\u5956\u52b1%s\u91d1\u5e01", member.getNick(), member.getId(), lotteryInfo.getBonus()));
                break;
            }
            case 2: {
                if (location != 4) break;
                group.sendMessage(String.format("\u5f97\u7b7e\u7740:%s(%s),\u5956\u52b1%s\u91d1\u5e01", member.getNick(), member.getId(), lotteryInfo.getBonus()));
                break;
            }
            case 3: {
                if (location != 5) break;
                group.sendMessage(String.format("\u5f97\u7b7e\u7740:%s(%s),\u5956\u52b1%s\u91d1\u5e01", member.getNick(), member.getId(), lotteryInfo.getBonus()));
            }
        }
    }

    public static void close() {
        CronUtil.stop();
    }

    @MessageAuthorize(text={"\u5f00\u542f \u731c\u7b7e"}, userPermissions={"owner", "admin"})
    public void startLottery(GroupMessageEvent event) {
        PermUtil util = PermUtil.INSTANCE;
        Group group = event.getGroup();
        cn.chahuyun.authorize.entity.User user = cn.chahuyun.authorize.entity.User.Companion.group(group.getId());
        if (util.checkUserHasPerm(user, "lottery")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u731c\u7b7e\u5df2\u7ecf\u5f00\u542f\u4e86!", new Object[0]));
            return;
        }
        if (util.addUserToPermGroupByName(user, "\u731c\u7b7e\u7ec4")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u731c\u7b7e\u5f00\u542f\u6210\u529f!", new Object[0]));
        } else {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u731c\u7b7e\u5f00\u542f\u5931\u8d25!", new Object[0]));
        }
    }

    @MessageAuthorize(text={"\u5173\u95ed \u731c\u7b7e"}, userPermissions={"owner", "admin"})
    public void endLottery(GroupMessageEvent event) {
        PermUtil util = PermUtil.INSTANCE;
        Group group = event.getGroup();
        cn.chahuyun.authorize.entity.User user = cn.chahuyun.authorize.entity.User.Companion.group(group.getId());
        if (!util.checkUserHasPerm(user, "lottery")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u731c\u7b7e\u5df2\u7ecf\u5173\u95ed!", new Object[0]));
            return;
        }
        PermGroup permGroup = util.talkPermGroupByName("\u731c\u7b7e\u7ec4");
        Perm perm = util.takePerm("lottery");
        permGroup.getPerms().remove(perm);
        permGroup.save();
        group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u731c\u7b7e\u5173\u95ed\u6210\u529f!", new Object[0]));
    }
}

