/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.economy.entity.UserBackpack;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.props.PropsBase;
import cn.chahuyun.economy.entity.props.PropsCard;
import cn.chahuyun.economy.entity.props.factory.PropsCardFactory;
import cn.chahuyun.economy.manager.PropsManager;
import cn.chahuyun.economy.manager.UserManager;
import cn.chahuyun.economy.plugin.PropsType;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;

public class PropsManagerImpl
implements PropsManager {
    @Override
    public boolean registerProps(PropsBase propsBase) {
        String code;
        try {
            code = propsBase.getCode();
            if (StrUtil.isBlankIfStr((Object)code)) {
                return false;
            }
            String description = propsBase.getDescription();
            if (StrUtil.isBlankIfStr((Object)description)) {
                return false;
            }
            String name = propsBase.getName();
            if (StrUtil.isBlankIfStr((Object)name)) {
                return false;
            }
        }
        catch (Exception e) {
            Log.error("\u9053\u5177\u7ba1\u7406:\u6ce8\u518c\u9053\u5177\u51fa\u9519!");
            return false;
        }
        PropsType.add(code, propsBase);
        return true;
    }

    @Override
    public List<PropsBase> getPropsByUser(UserInfo userInfo) {
        ArrayList<PropsBase> props = new ArrayList<PropsBase>();
        List<UserBackpack> backpacks = userInfo.getBackpacks();
        for (UserBackpack backpack : backpacks) {
            Class<?> aClass;
            try {
                aClass = Class.forName(backpack.getClassName());
            }
            catch (ClassNotFoundException e) {
                Log.error("\u9053\u5177\u7ba1\u7406:\u83b7\u53d6\u6240\u6709\u9053\u5177-\u83b7\u53d6\u9053\u5177\u5b50\u7c7b\u51fa\u9519!", e);
                continue;
            }
            PropsBase fromSession = (PropsBase)HibernateFactory.selectOne(aClass, (Object)backpack.getPropId());
            props.add(fromSession);
        }
        return props;
    }

    @Override
    public <E extends PropsBase> List<E> getPropsByUserFromCode(UserInfo userInfo, String code, Class<E> clazz) {
        List<UserBackpack> backpacks = userInfo.getBackpacks();
        if (backpacks == null || backpacks.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<PropsBase> propList = new ArrayList<PropsBase>();
        for (UserBackpack backpack : backpacks) {
            PropsBase base = (PropsBase)HibernateFactory.selectOne(clazz, (Object)backpack.getPropId());
            propList.add(base);
        }
        return propList;
    }

    @Override
    public <E> boolean deleteProp(UserInfo userInfo, PropsBase props, Class<E> clazz) {
        return false;
    }

    @Override
    public UserInfo deleteProp(UserInfo userInfo, PropsBase props) {
        try {
            return (UserInfo)HibernateFactory.getSession().fromTransaction(session -> {
                session.remove((Object)props);
                List<UserBackpack> backpacks = userInfo.getBackpacks();
                backpacks.removeIf(filter -> filter.getPropId() == props.getId().longValue());
                userInfo.setBackpacks(backpacks);
                return userInfo;
            });
        }
        catch (Exception e) {
            Log.error("\u9053\u5177\u7ba1\u7406:\u5220\u9664\u9053\u5177\u51fa\u9519");
            return null;
        }
    }

    @Override
    public void propStore(MessageEvent event) {
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        ForwardMessageBuilder iNodes = new ForwardMessageBuilder(subject);
        ForwardMessageBuilder propCard = new ForwardMessageBuilder(subject);
        iNodes.add((UserOrBot)bot, (Message)new PlainText("\u9053\u5177\u7cfb\u7edf"));
        propCard.add((UserOrBot)bot, (Message)new PlainText("\u9053\u5177\u5361\u5546\u5e97"));
        Set<String> strings = PropsType.getProps().keySet();
        for (String string : strings) {
            if (!string.startsWith("K-")) continue;
            Object propInfo = String.format("\u9053\u5177\u7f16\u53f7:%s\n", PropsType.getNo(string));
            propInfo = (String)propInfo + PropsType.getPropsInfo(string).toString();
            propCard.add((UserOrBot)bot, (Message)new PlainText((String)propInfo));
        }
        iNodes.add((UserOrBot)bot, (Message)propCard.build());
        subject.sendMessage((Message)iNodes.build());
    }

    @Override
    public void buyPropFromStore(MessageEvent event) {
        int total;
        String propCode;
        Contact subject = event.getSubject();
        User sender = event.getSender();
        MessageChain message = event.getMessage();
        MessageChainBuilder messages = MessageUtil.quoteReply(message);
        String code = message.serializeToMiraiCode();
        String[] s = code.split(" ");
        String no = s[1];
        int num = 1;
        if (s.length == 3) {
            num = Integer.parseInt(s[2]);
        }
        if ((propCode = PropsType.getCode(no)) == null) {
            Log.warning("\u9053\u5177\u7cfb\u7edf:\u8d2d\u4e70\u9053\u5177\u4e3a\u7a7a");
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u6211\u8fd9\u91cc\u4e0d\u5356\u8fd9\u4e2a...", new Object[0]));
            return;
        }
        Log.info("\u9053\u5177\u7cfb\u7edf:\u8d2d\u4e70\u9053\u5177-Code " + propCode);
        UserInfo userInfo = UserManager.getUserInfo(sender);
        if (userInfo == null) {
            Log.warning("\u9053\u5177\u7cfb\u7edf:\u83b7\u53d6\u7528\u6237\u4e3a\u7a7a\uff01");
            subject.sendMessage("\u7cfb\u7edf\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u4e3b\u4eba!");
            return;
        }
        PropsBase propsInfo = PropsType.getPropsInfo(propCode);
        double money = EconomyUtil.getMoneyByUser(sender);
        if (money - (double)(total = propsInfo.getCost() * num) < (double)(-propsInfo.getCost() * 5)) {
            messages.append((SingleMessage)new PlainText("\u505a\u68a6\u53bb\u5427\u4f60\uff0c" + propsInfo.getName() + "\u4e5f\u662f\u4f60\u80fd\u60f3\u8981\u7684\u4e1c\u897f?"));
            subject.sendMessage((Message)messages.build());
            return;
        }
        if (money - (double)total < 0.0) {
            messages.append((SingleMessage)new PlainText("\u8fd9\u4e48\u70b9\u94b1\u5c31\u60f3\u4e70" + propsInfo.getName() + "?"));
            subject.sendMessage((Message)messages.build());
            return;
        }
        if (!EconomyUtil.minusMoneyToUser(sender, total)) {
            Log.warning("\u9053\u5177\u7cfb\u7edf:\u51cf\u5c11\u4f59\u989d\u5931\u8d25!");
            subject.sendMessage("\u7cfb\u7edf\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u4e3b\u4eba!");
            return;
        }
        PropsCard propsCard = null;
        if (propCode.startsWith("K-")) {
            propsCard = PropsCardFactory.INSTANCE.create(propCode);
        }
        if (propsCard == null) {
            Log.error("\u9053\u5177\u7cfb\u7edf:\u9053\u5177\u521b\u5efa\u4e3a\u7a7a");
            return;
        }
        for (int number = num; number != 0; --number) {
            UserBackpack userBackpack = new UserBackpack(userInfo, propsCard);
            if (userInfo.addPropToBackpack(userBackpack)) continue;
            Log.warning("\u9053\u5177\u7cfb\u7edf:\u6dfb\u52a0\u9053\u5177\u5230\u7528\u6237\u80cc\u5305\u5931\u8d25!");
            subject.sendMessage("\u7cfb\u7edf\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u4e3b\u4eba!");
            return;
        }
        money = EconomyUtil.getMoneyByUser(sender);
        messages.append((CharSequence)String.format("\u6210\u529f\u8d2d\u4e70 %s %d%s,\u4f60\u8fd8\u6709 %s \u679a\u91d1\u5e01", propsInfo.getName(), num, propsInfo.getUnit(), money));
        Log.info("\u9053\u5177\u7cfb\u7edf:\u9053\u5177\u8d2d\u4e70\u6210\u529f");
        subject.sendMessage((Message)messages.build());
    }

    @Override
    public void userProp(MessageEvent event) {
        Contact subject = event.getSubject();
        User sender = event.getSender();
        MessageChain message = event.getMessage();
        MessageChainBuilder messages = MessageUtil.quoteReply(message);
        String code = message.serializeToMiraiCode();
        String[] s = code.split(" ");
        String no = s[1];
        int num = 1;
        if (s.length == 3) {
            num = Integer.parseInt(s[2]);
        }
        String propCode = PropsType.getCode(no);
        Log.info("\u9053\u5177\u7cfb\u7edf:\u4f7f\u7528\u9053\u5177-Code " + propCode);
        UserInfo userInfo = UserManager.getUserInfo(sender);
        int success = 0;
        PropsBase prop = null;
        if (propCode.startsWith("K-")) {
            assert (userInfo != null);
            List<PropsCard> propsByUserFromCode = this.getPropsByUserFromCode(userInfo, propCode, PropsCard.class);
            if (propsByUserFromCode.isEmpty()) {
                subject.sendMessage((Message)messages.append((CharSequence)"\u4f60\u7684\u5305\u91cc\u6ca1\u6709\u8fd9\u4e2a\u9053\u5177!").build());
                return;
            }
            for (PropsCard propsCard : propsByUserFromCode) {
                prop = propsCard;
                if (propsCard.isStatus()) continue;
                if (num == 0) break;
                propsCard.setStatus(true);
                propsCard.setEnabledTime(new Date());
                HibernateFactory.merge((Object)propsCard);
                --num;
                ++success;
            }
        }
        assert (prop != null);
        if (success == 0) {
            subject.sendMessage((Message)messages.append((CharSequence)String.format("\u4f60\u6ca1\u6709\u672a\u4f7f\u7528\u7684%s", prop.getName())).build());
            return;
        }
        subject.sendMessage((Message)messages.append((CharSequence)String.format("\u6210\u529f\u4f7f\u7528%d%s%s", success, prop.getUnit(), prop.getName())).build());
    }

    @Override
    public void viewUserBackpack(MessageEvent event) {
        Contact subject = event.getSubject();
        User sender = event.getSender();
        Bot bot = event.getBot();
        UserInfo userInfo = UserManager.getUserInfo(sender);
        assert (userInfo != null);
        List<PropsBase> propsByUser = this.getPropsByUser(userInfo);
        if (propsByUser.isEmpty()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4f60\u7684\u80cc\u5305\u7a7a\u8361\u8361\u7684...", new Object[0]));
            return;
        }
        ForwardMessageBuilder iNodes = new ForwardMessageBuilder(subject);
        HashMap<String, 1> propsListMap = new HashMap<String, 1>();
        ArrayList<PropsBase> propsBaseList = new ArrayList<PropsBase>();
        for (final PropsBase propsBase : propsByUser) {
            String code = propsBase.getCode();
            if (propsBase.isStack()) {
                if (propsListMap.containsKey(code)) {
                    ((List)propsListMap.get(code)).add(propsBase);
                    continue;
                }
                propsListMap.put(code, new ArrayList<PropsBase>(){
                    {
                        this.add(propsBase);
                    }
                });
                continue;
            }
            propsBaseList.add(propsBase);
        }
        for (Map.Entry entry : propsListMap.entrySet()) {
            PropsBase propsInfo = PropsType.getPropsInfo((String)entry.getKey());
            String no = PropsType.getNo((String)entry.getKey());
            List value = (List)entry.getValue();
            int size = value.size();
            int open = 0;
            if (propsInfo instanceof PropsCard) {
                for (PropsBase propsBase : value) {
                    PropsCard propsCard = (PropsCard)propsBase;
                    if (!propsCard.isStatus()) continue;
                    ++open;
                }
            }
            String format = String.format("\u9053\u5177\u7f16\u53f7:%s\n\u9053\u5177\u540d\u79f0:%s\n\u9053\u5177\u63cf\u8ff0:%s\n\u603b\u6570\u91cf:%d\n\u542f\u7528\u6570\u91cf:%d", no, propsInfo.getName(), propsInfo.getDescription(), size, open);
            iNodes.add((UserOrBot)bot, (Message)new PlainText(format));
        }
        for (PropsBase propsBase : propsBaseList) {
            String no = PropsType.getNo(propsBase.getCode());
            String format = String.format("\u9053\u5177\u7f16\u53f7:%s\n\u9053\u5177\u540d\u79f0:%s\n\u9053\u5177\u63cf\u8ff0:%s", no, propsBase.getName(), propsBase.getDescription());
            iNodes.add((UserOrBot)bot, (Message)new PlainText(format));
        }
        subject.sendMessage((Message)iNodes.build());
    }
}

