/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.authorize.constant.MessageMatchingEnum;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.redpack.RedPack;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.economy.utils.ShareUtils;
import cn.chahuyun.economy.utils.TimeConvertUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.PlainText;

@EventComponent
public class RedPackManager {
    @MessageAuthorize(text={"\u53d1\u7ea2\u5305( \\d+){2}( (sj|\u968f\u673a))?"}, messageMatching=MessageMatchingEnum.REGULAR)
    public static void create(GroupMessageEvent event) {
        int id;
        Log.info("\u53d1\u7ea2\u5305\u6307\u4ee4");
        Group group = event.getGroup();
        Member sender = event.getSender();
        Group subject = event.getSubject();
        MessageChain message = event.getMessage();
        String content = message.contentToString();
        String[] info = content.split(" ");
        double money = Double.parseDouble(info[1]);
        int number = Integer.parseInt(info[2]);
        boolean random = false;
        if (info.length == 4) {
            boolean bl = random = info[3].equals("sj") || info[3].equals("\u968f\u673a");
        }
        if (money / (double)number < 0.1) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u53d1\u7684\u7ea2\u5305\u592a\u5c0f\u4e86,\u6bcf\u4e2a\u7ea2\u5305\u91d1\u989d\u4f4e\u4e8e\u4e860.1\uff01", new Object[0]));
            return;
        }
        if (money > EconomyUtil.getMoneyByUser((User)sender)) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u7684\u91d1\u5e01\u4e0d\u591f\u5566\uff01", new Object[0]));
            return;
        }
        if (!EconomyUtil.plusMoneyToUser((User)sender, -money)) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u7ea2\u5305\u53d1\u9001\u5931\u8d25!", new Object[0]));
            return;
        }
        RedPack pack = RedPack.builder().name(sender.getNick() + "\u7684\u7ea2\u5305").groupId(group.getId()).sender(sender.getId()).money(money).number(number).isRandomPack(random).createTime(new Date()).build();
        if (random) {
            int residual = pack.getNumber();
            double residualMoney = pack.getMoney();
            double coefficient = 0.5;
            if (RandomUtil.randomInt((int)0, (int)11) <= 7) {
                long round = Math.round(residualMoney / (double)residual);
                coefficient = ShareUtils.rounding(RandomUtil.randomDouble((double)Math.min(5.0, (double)round * 0.3), (double)((double)round * 0.9)));
            }
            ArrayList<Double> doubles = new ArrayList<Double>();
            for (int i = 1; i < pack.getNumber(); ++i) {
                double v = RandomUtil.randomDouble((double)0.1, (double)(residualMoney - (double)(residual - i) * coefficient));
                v = ShareUtils.rounding(v);
                doubles.add(v);
                residualMoney -= v;
            }
            doubles.add(residualMoney);
            pack.setRandomPackList(doubles);
        }
        if ((id = ((RedPack)HibernateFactory.merge((Object)pack)).getId().intValue()) == 0) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u7ea2\u5305\u521b\u5efa\u5931\u8d25!", new Object[0]));
            return;
        }
        if (random) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(sender.getId(), "\u968f\u673a\u7ea2\u5305\u521b\u5efa\u6210\u529f!", new Object[0]));
        }
        String prefix = HuYanEconomy.config.getPrefix();
        subject.sendMessage((Message)MessageUtil.formatMessageChain("%s \u53d1\u9001\u4e86\u4e00\u4e2a\u7ea2\u5305,\u5feb\u6765\u62a2\u7ea2\u5305\u5427\uff01%n\u7ea2\u5305ID:%d%n\u7ea2\u5305\u6709 %.1f \u679a\u91d1\u5e01%n\u7ea2\u5305\u4e2a\u6570%d%n\u7ea2\u5305\u53d1\u9001\u65f6\u95f4%s%n\u9886\u53d6\u547d\u4ee4 %s\u9886\u7ea2\u5305 %d", sender.getNick(), id, money, number, TimeConvertUtil.timeConvert(pack.getCreateTime()), prefix.isBlank() ? "" : prefix, id));
    }

    @MessageAuthorize(text={"\u9886\u7ea2\u5305 \\d+|\u6536\u7ea2\u5305 \\d+"}, messageMatching=MessageMatchingEnum.REGULAR)
    public static void receive(GroupMessageEvent event) {
        Log.info("\u6536\u7ea2\u5305\u6307\u4ee4");
        Group subject = event.getSubject();
        Group group = event.getGroup();
        Member sender = event.getSender();
        MessageChain message = event.getMessage();
        String content = message.contentToString();
        String[] info = content.split(" ");
        int id = Integer.parseInt(info[1]);
        RedPack redPack = (RedPack)HibernateFactory.selectOne(RedPack.class, (Object)id);
        if (redPack == null) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u7ea2\u5305\u4e0d\u5b58\u5728!", new Object[0]));
            return;
        }
        if (redPack.getGroupId().longValue() != group.getId()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u8fd9\u4e0d\u662f\u8fd9\u4e2a\u7fa4\u7684\u7ea2\u5305!", new Object[0]));
            return;
        }
        if (DateUtil.between((Date)redPack.getCreateTime(), (Date)new Date(), (DateUnit)DateUnit.DAY) >= 1L) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u8fd9\u4e2a\u7ea2\u5305\u5df2\u7ecf\u8fc7\u671f\u4e86", new Object[0]));
            RedPackManager.expireRedPack(group, redPack);
            HibernateFactory.delete((Object)redPack);
            return;
        }
        RedPackManager.getRedPack((User)sender, (Contact)subject, redPack, message);
    }

    @MessageAuthorize(text={"\u7ea2\u5305\u5217\u8868"})
    public static void queryRedPackList(GroupMessageEvent event) {
        Log.info("\u7ea2\u5305\u67e5\u8be2\u6307\u4ee4");
        Group subject = event.getSubject();
        try {
            Group group = event.getGroup();
            Bot bot = event.getBot();
            List redPacks = HibernateFactory.selectList(RedPack.class, (String)"groupId", (Object)group.getId());
            ForwardMessageBuilder forwardMessage = new ForwardMessageBuilder((Contact)subject);
            if (redPacks.isEmpty()) {
                subject.sendMessage("\u672c\u7fa4\u6682\u65e0\u7ea2\u5305\uff01");
                return;
            }
            RedPackManager.viewRedPack((Contact)subject, bot, redPacks, forwardMessage);
        }
        catch (Exception e) {
            subject.sendMessage("\u67e5\u8be2\u5931\u8d25! \u539f\u56e0: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void viewRedPack(Contact subject, Bot bot, List<RedPack> redPacks, ForwardMessageBuilder forwardMessage) {
        if (!(subject instanceof Group)) {
            return;
        }
        Group group = (Group)subject;
        redPacks.forEach(redPack -> {
            int id = redPack.getId();
            String name = redPack.getName();
            long senderId = redPack.getSender();
            double money = redPack.getMoney();
            int number = redPack.getNumber();
            Date createTime = redPack.getCreateTime();
            List<Long> receivers = redPack.getReceiverList();
            ArrayList<String> nickNames = new ArrayList<String>();
            for (Long receiver : receivers) {
                String nameCard = Objects.requireNonNull(group.get(receiver.longValue())).getNameCard();
                nickNames.add(nameCard != null ? nameCard : group.get(receiver.longValue()).getNick());
            }
            PlainText message = new PlainText("\u7ea2\u5305\u4fe1\u606f: \n\u7ea2\u5305ID: " + id + "\n\u7ea2\u5305\u540d\u79f0: " + name + "\n\u7ea2\u5305\u53d1\u9001\u8005QQ\u53f7: " + senderId + "\n\u7ea2\u5305\u91d1\u5e01: " + money + "\n\u5269\u4f59\u91d1\u5e01: " + (money - redPack.getTakenMoneys()) + "\n\u7ea2\u5305\u4eba\u6570: " + number + "\n\u7ea2\u5305\u521b\u5efa\u65f6\u95f4: " + TimeConvertUtil.timeConvert(createTime) + "\n\u7ea2\u5305\u9886\u53d6\u8005: " + nickNames);
            forwardMessage.add((UserOrBot)bot, (Message)message);
        });
        subject.sendMessage((Message)forwardMessage.build());
    }

    @MessageAuthorize(text={"\u62a2\u7ea2\u5305"})
    public static void grabNewestRedPack(GroupMessageEvent event) {
        Log.info("\u62a2\u7ea2\u5305\u6307\u4ee4");
        Group subject = event.getSubject();
        try {
            Group group = event.getGroup();
            Member sender = event.getSender();
            List redPacks = HibernateFactory.selectList(RedPack.class, (String)"groupId", (Object)group.getId());
            if (redPacks.isEmpty()) {
                subject.sendMessage("\u5f53\u524d\u7fa4\u6ca1\u6709\u7ea2\u5305\u54e6!");
                return;
            }
            redPacks.sort(Comparator.comparing(RedPack::getCreateTime).reversed());
            RedPackManager.getRedPack((User)sender, (Contact)subject, (RedPack)redPacks.get(0), event.getMessage());
        }
        catch (Exception e) {
            subject.sendMessage("\u9886\u53d6\u5931\u8d25! \u539f\u56e0: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void getRedPack(User sender, Contact subject, RedPack redPack, MessageChain message) {
        double perMoney;
        double money = redPack.getMoney();
        long number = redPack.getNumber().intValue();
        boolean isRandomPack = redPack.isRandomPack();
        List<Long> receivers = redPack.getReceiverList();
        if (!receivers.isEmpty() && receivers.contains(sender.getId())) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u5df2\u7ecf\u9886\u53d6\u8fc7\u8be5\u7ea2\u5305\u4e86\uff01", new Object[0]));
            return;
        }
        if (receivers.size() >= redPack.getNumber()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u7ea2\u5305\u5df2\u88ab\u9886\u5b8c\uff01", new Object[0]));
            HibernateFactory.delete((Object)redPack);
            return;
        }
        DecimalFormat df = new DecimalFormat("#.0");
        if (isRandomPack) {
            perMoney = redPack.getRandomPack();
            redPack.setTakenMoneys(redPack.getTakenMoneys() + perMoney);
        } else {
            perMoney = Double.parseDouble(df.format(money / (double)number));
        }
        if (!EconomyUtil.plusMoneyToUser(sender, perMoney)) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u7ea2\u5305\u9886\u53d6\u5931\u8d25!", new Object[0]));
            return;
        }
        receivers.add(sender.getId());
        redPack.setReceiverList(receivers);
        HibernateFactory.merge((Object)redPack);
        subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u606d\u559c\u4f60\u9886\u53d6\u5230\u4e86\u4e00\u4e2a\u7ea2\u5305\uff0c\u4f60\u9886\u53d6\u4e86 %.1f \u679a\u91d1\u5e01\uff01", perMoney));
        if (receivers.size() >= redPack.getNumber()) {
            long between = DateUtil.between((Date)new Date(), (Date)redPack.getCreateTime(), (DateUnit)DateUnit.SECOND);
            subject.sendMessage((Message)MessageUtil.formatMessageChain("%s\u5df2\u88ab\u9886\u5b8c\uff01\u5171\u8ba1\u82b1\u8d39%d\u79d2!", redPack.getName(), between));
            HibernateFactory.delete((Object)redPack);
        }
    }

    public static void expireRedPack(Group group, RedPack redPack) {
        long ownerId = redPack.getSender();
        double money = redPack.getMoney();
        NormalMember owner = group.get(ownerId);
        double remainingMoney = money - redPack.getTakenMoneys();
        EconomyUtil.plusMoneyToUser((User)owner, remainingMoney);
        group.sendMessage((Message)MessageUtil.formatMessageChain(ownerId, "\u4f60\u7684\u7ea2\u5305\u8fc7\u671f\u5566\uff01\u9000\u8fd8\u91d1\u5e01 %.1f \u4e2a\uff01", remainingMoney));
    }

    @MessageAuthorize(text={"\u5168\u5c40\u7ea2\u5305\u5217\u8868"}, userPermissions={"owner"})
    public static void queryGlobalRedPackList(MessageEvent event) {
        Log.info("\u7ea2\u5305\u67e5\u770b\u6307\u4ee4");
        Contact subject = event.getSubject();
        try {
            Bot bot = event.getBot();
            List redPacks = HibernateFactory.selectList(RedPack.class);
            ForwardMessageBuilder forwardMessage = new ForwardMessageBuilder(subject);
            if (redPacks.isEmpty()) {
                subject.sendMessage("\u5168\u5c40\u6682\u65e0\u7ea2\u5305\uff01");
                return;
            }
            RedPackManager.viewRedPack(subject, bot, redPacks, forwardMessage);
        }
        catch (Exception e) {
            subject.sendMessage("\u67e5\u8be2\u5931\u8d25! \u539f\u56e0: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

