/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.authorize.constant.MessageMatchingEnum;
import cn.chahuyun.authorize.entity.Perm;
import cn.chahuyun.authorize.entity.PermGroup;
import cn.chahuyun.authorize.utils.PermUtil;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.rob.RobInfo;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.economy.utils.ShareUtils;
import cn.chahuyun.economy.utils.TimeConvertUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.util.RandomUtil;
import java.util.Date;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;

@EventComponent
public class RobManager {
    static String[] robFailedVariable = new String[]{"${\u5bf9\u8c61}"};
    static String[] robSuccessVariable = new String[]{"${\u5bf9\u8c61}", "${\u91d1\u5e01}"};
    static String[] loseMoneyVariable = new String[]{"${\u5bf9\u8c61}", "${\u91d1\u5e01}"};
    static String[] robJailVariable = new String[]{"${\u5bf9\u8c61}", "${\u91d1\u5e01}", "${\u65f6\u95f4}"};

    @MessageAuthorize(text={"\u62a2\u52ab ?\\[mirai:at:\\d+] ?"}, messageMatching=MessageMatchingEnum.REGULAR, groupPermissions={"rob"})
    public static void robOther(GroupMessageEvent event) {
        Log.info("\u62a2\u52ab\u6307\u4ee4");
        Member sender = event.getSender();
        Group group = event.getGroup();
        Group subject = event.getSubject();
        RobInfo robInfo = (RobInfo)HibernateFactory.selectOne(RobInfo.class, (Object)sender.getId());
        if (RobManager.checkCoolDown((Contact)subject, (User)sender, robInfo, true)) {
            return;
        }
        String message = event.getMessage().contentToString();
        long victimId = Long.parseLong(message.split("@")[1].trim());
        if (sender.getId() == victimId) {
            group.sendMessage("\u4f60\u4e0d\u80fd\u62a2\u52ab\u81ea\u5df1\u54e6\uff01");
            return;
        }
        NormalMember victim = group.get(victimId);
        if (victim == null) {
            subject.sendMessage("\u8be5\u7528\u6237\u4e0d\u5728\u7fa4\u5185\uff01");
            return;
        }
        double victimHasMoney = EconomyUtil.getMoneyByUser((User)victim);
        if (victimHasMoney <= 1.0) {
            subject.sendMessage("\u4ed6\u90fd\u6ca1\u94b1\u4e86\uff0c\u4f60\u8fd8\u62a2\uff1f");
            return;
        }
        int chance = RandomUtil.randomInt((int)0, (int)101);
        double robMoney = (double)Math.round(RandomUtil.randomDouble((double)0.1, (double)Math.min(victimHasMoney / 2.0, (double)HuYanEconomy.robConfig.getRobMaxMoney())) * 10.0) / 10.0;
        String victimName = victim.getNick();
        if (RobManager.getInJail((Contact)subject, (User)sender, robInfo, chance, victimName, robMoney)) {
            return;
        }
        if (RobManager.loseMoney((Contact)subject, (User)sender, chance, 50, victimName, robMoney)) {
            return;
        }
        RobManager.updateRobInfo((User)sender, robInfo, HuYanEconomy.robConfig.getRobCoolTime(), false);
        if (RobManager.robFailed((Contact)subject, (User)sender, chance, 75, victimName)) {
            return;
        }
        EconomyUtil.plusMoneyToUser((User)victim, -robMoney);
        EconomyUtil.plusMoneyToUser((User)sender, robMoney);
        int msgIndex = RandomUtil.randomInt((int)0, (int)HuYanEconomy.robConfig.getRobSuccessMsg().size());
        String msg = HuYanEconomy.robConfig.getRobSuccessMsg().get(msgIndex);
        msg = ShareUtils.replacer(msg, robSuccessVariable, victim.getNick(), robMoney);
        subject.sendMessage((Message)MessageUtil.formatMessageChain(sender.getId(), "%s", msg));
    }

    @MessageAuthorize(text={"\u62a2\u94f6\u884c"}, groupPermissions={"rob"})
    public static void robBank(GroupMessageEvent event) {
        Log.info("\u62a2\u94f6\u884c\u6307\u4ee4");
        Member sender = event.getSender();
        Group subject = event.getSubject();
        RobInfo robInfo = (RobInfo)HibernateFactory.selectOne(RobInfo.class, (Object)sender.getId());
        if (RobManager.checkCoolDown((Contact)subject, (User)sender, robInfo, true)) {
            return;
        }
        int chance = RandomUtil.randomInt((int)0, (int)101);
        int i = RandomUtil.randomInt((int)3, (int)8);
        double successMoney = (double)Math.round(RandomUtil.randomDouble((double)(10000 * (i - 2)), (double)(10000 * (i + 1))) * 10.0) / 10.0;
        double failedMoney = (double)Math.round(RandomUtil.randomDouble((double)1000.0, (double)5000.0) * 10.0) / 10.0;
        if (RobManager.getInJail((Contact)subject, (User)sender, robInfo, chance, "\u94f6\u884c", failedMoney)) {
            return;
        }
        RobManager.updateRobInfo((User)sender, robInfo, HuYanEconomy.robConfig.getRobCoolTime(), false);
        if (RobManager.robFailed((Contact)subject, (User)sender, chance, 99, "\u94f6\u884c")) {
            return;
        }
        EconomyUtil.plusMoneyToUser((User)sender, successMoney);
        int msgIndex = RandomUtil.randomInt((int)0, (int)HuYanEconomy.robConfig.getRobSuccessMsg().size());
        String msg = HuYanEconomy.robConfig.getRobSuccessMsg().get(msgIndex);
        msg = ShareUtils.replacer(msg, robSuccessVariable, "\u94f6\u884c", successMoney);
        subject.sendMessage((Message)MessageUtil.formatMessageChain(sender.getId(), "%s", msg));
    }

    private static void updateRobInfo(User sender, RobInfo robInfo, long cooldown, boolean isCauseJail) {
        if (robInfo == null) {
            robInfo = RobInfo.builder().userId(sender.getId()).lastRobTime(new Date()).cooling(cooldown).isInJail(isCauseJail).build();
        } else {
            robInfo.setLastRobTime(new Date());
            robInfo.setCooling(cooldown);
            robInfo.setInJail(isCauseJail);
        }
        HibernateFactory.merge((Object)robInfo);
    }

    @MessageAuthorize(text={"\u91ca\u653e\u51fa\u72f1"}, userPermissions={"owner"})
    public static void release(MessageEvent event) {
        Log.info("\u76d1\u72f1\u6307\u4ee4");
        RobInfo robInfo = (RobInfo)HibernateFactory.selectOne(RobInfo.class, (Object)event.getSender().getId());
        RobManager.updateRobInfo(event.getSender(), robInfo, 0L, false);
        event.getSubject().sendMessage((Message)new At(event.getSender().getId()).plus("\n\u4f60\u5df2\u6210\u529f\u91ca\u653e\uff01"));
    }

    private static boolean checkCoolDown(Contact subject, User sender, RobInfo robInfo, boolean send) {
        Date lastRobTime;
        Date now = new Date();
        if (robInfo != null && (lastRobTime = robInfo.getLastRobTime()) != null && now.getTime() - lastRobTime.getTime() < robInfo.getCooling() * 1000L) {
            long remainingCooldown = (robInfo.getCooling() * 1000L - (now.getTime() - lastRobTime.getTime())) / 1000L;
            MessageChain msg = robInfo.isInJail() ? MessageUtil.formatMessageChain(sender.getId(), "\u4f60\u8fd8\u8981\u88ab\u5173%s\u4e86!%n\u8fd9\u5c31\u60f3\u5f80\u51fa\u8dd1\u4e86\uff1f", TimeConvertUtil.secondConvert(remainingCooldown)) : MessageUtil.formatMessageChain(sender.getId(), "\u518d\u7b49%s\u5427!%n\u6700\u8fd1\u98ce\u6c14\u6709\u70b9\u4e0d\u597d\u3002", TimeConvertUtil.secondConvert(remainingCooldown));
            if (send) {
                subject.sendMessage((Message)msg);
            }
            return true;
        }
        if (EconomyUtil.getMoneyByUser(sender) <= 0.0) {
            if (send) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(sender.getId(), HuYanEconomy.robConfig.getRobNotEnoughMsg(), new Object[0]));
            }
            return true;
        }
        return false;
    }

    private static boolean getInJail(Contact subject, User sender, RobInfo robInfo, int chance, String victimName, double robMoney) {
        if (chance <= 50) {
            int msgIndex = RandomUtil.randomInt((int)0, (int)HuYanEconomy.robConfig.getRobJailMsg().size());
            String msg = HuYanEconomy.robConfig.getRobJailMsg().get(msgIndex);
            EconomyUtil.plusMoneyToUser(sender, -robMoney);
            msg = ShareUtils.replacer(msg, robJailVariable, victimName, robMoney, TimeConvertUtil.secondConvert(HuYanEconomy.robConfig.getJailCoolTime()));
            subject.sendMessage((Message)MessageUtil.formatMessageChain(sender.getId(), "\u6709\u4eba\u62a5\u8b66\u4e86!!!!%n%s", msg));
            RobManager.updateRobInfo(sender, robInfo, HuYanEconomy.robConfig.getJailCoolTime(), true);
            return true;
        }
        return false;
    }

    private static boolean robFailed(Contact subject, User sender, int chance, int failedChance, String victimName) {
        if (chance <= failedChance) {
            int msgIndex = RandomUtil.randomInt((int)0, (int)HuYanEconomy.robConfig.getRobFailMsg().size());
            String msg = HuYanEconomy.robConfig.getRobFailMsg().get(msgIndex);
            msg = ShareUtils.replacer(msg, robFailedVariable, victimName);
            subject.sendMessage((Message)new At(sender.getId()).plus("\n\u4f60\u5931\u8d25\u4e86\uff01\n" + msg));
            return true;
        }
        return false;
    }

    private static boolean loseMoney(Contact subject, User sender, int chance, int loseChance, String victimName, double robMoney) {
        if (chance <= loseChance) {
            int msgIndex = RandomUtil.randomInt((int)0, (int)HuYanEconomy.robConfig.getLoseMoneyMsg().size());
            String msg = HuYanEconomy.robConfig.getLoseMoneyMsg().get(msgIndex);
            msg = ShareUtils.replacer(msg, loseMoneyVariable, victimName, robMoney);
            EconomyUtil.plusMoneyToUser(sender, -robMoney);
            subject.sendMessage((Message)new At(sender.getId()).plus("\n\u4f60\u5931\u8d25\u4e86\uff01\n" + msg));
            return true;
        }
        return false;
    }

    @MessageAuthorize(text={"\u5e73\u8d26 ?\\[mirai:at:\\d+] ?"}, messageMatching=MessageMatchingEnum.REGULAR, userPermissions={"owner", "admin"}, groupPermissions={"rob"})
    public static void flatAccount(GroupMessageEvent event) {
        Log.info("\u5e73\u8d26\u6307\u4ee4");
        Member atMember = ShareUtils.getAtMember(event);
        Group subject = event.getSubject();
        if (atMember == null) {
            subject.sendMessage("\u8fd9\u4e2a\u4eba\uff0c\u4ed6\u5728\u5417\uff1f");
            return;
        }
        double moneyByUser = EconomyUtil.getMoneyByUser((User)atMember);
        if (moneyByUser < 0.0) {
            EconomyUtil.plusMoneyToUser((User)atMember, Math.abs(moneyByUser));
            String nick = event.getSender().getNick();
            subject.sendMessage((Message)MessageUtil.formatMessageChain(atMember.getId(), "%s\u7ed1\u4f60\u5e73\u6389\u4e86\u4f60\u7684\u8d1f\u503a\uff0c\u5feb\u5feb\u611f\u8c22\u4ed6\u5427\uff01", nick));
        } else {
            subject.sendMessage("\u4ed6\u4e0d\u9700\u8981\u5e73\u8d26!");
        }
    }

    @MessageAuthorize(text={"\u4fdd\u91ca ?\\[mirai:at:\\d+] ?"}, messageMatching=MessageMatchingEnum.REGULAR, userPermissions={"owner", "admin"}, groupPermissions={"rob"})
    public static void bail(GroupMessageEvent event) {
        Log.info("\u4fdd\u91ca\u6307\u4ee4");
        Member atMember = ShareUtils.getAtMember(event);
        Group subject = event.getSubject();
        Member sender = event.getSender();
        if (atMember == null) {
            subject.sendMessage("\u8fd9\u4e2a\u4eba\uff0c\u4ed6\u5728\u5417\uff1f");
            return;
        }
        RobInfo robInfo = (RobInfo)HibernateFactory.selectOne(RobInfo.class, (Object)sender.getId());
        if (robInfo != null && RobManager.checkCoolDown((Contact)subject, (User)atMember, robInfo, false)) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4f60\u5728\u76d1\u72f1\uff0c\u600e\u4e48\u4fdd\u91ca?", new Object[0]));
            return;
        }
        RobInfo one = (RobInfo)HibernateFactory.selectOne(RobInfo.class, (Object)atMember.getId());
        if (one == null || !one.isInJail()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4ed6\u4e0d\u5728\u76d1\u72f1\uff0c\u4f60\u8981\u4fdd\u91ca\u8c01?", new Object[0]));
            return;
        }
        double bailMoney = one.getCooling() * 3L;
        double moneyByUser = EconomyUtil.getMoneyByUser((User)sender);
        if (moneyByUser < bailMoney) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4f60\u7684\u94b1\u4e0d\u591f %.1f ,\u600e\u4e48\u4fdd\u91ca\uff1f", bailMoney));
            return;
        }
        if (EconomyUtil.minusMoneyToUser((User)sender, 500.0)) {
            RobManager.updateRobInfo((User)atMember, one, 0L, false);
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4fdd\u91ca\u6210\u529f!\u4f60\u82b1\u8d39\u4e86 500 \u91d1\u5e01", new Object[0]));
            subject.sendMessage((Message)MessageUtil.formatMessageChain(atMember.getId(), "\u4f60\u88ab%s\u4fdd\u91ca\u4e86,\u5feb\u5feb\u611f\u8c22\u4ed6\u5427\uff0c\u51fa\u53bb\u4e86\u8bb0\u5f97\u522b\u5e72\u574f\u4e8b!", new Object[0]));
        } else {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u4fdd\u91ca\u5931\u8d25\u4e86!", new Object[0]));
        }
    }

    public static Boolean isHospital(User user) {
        RobInfo robInfo = (RobInfo)HibernateFactory.selectOne(RobInfo.class, (Object)user.getId());
        return robInfo != null && robInfo.getType() == 2;
    }

    @MessageAuthorize(text={"\u5f00\u542f \u62a2\u52ab"}, userPermissions={"owner", "admin"})
    public void startRob(GroupMessageEvent event) {
        PermUtil util = PermUtil.INSTANCE;
        Group group = event.getGroup();
        cn.chahuyun.authorize.entity.User user = cn.chahuyun.authorize.entity.User.Companion.group(group.getId());
        if (util.checkUserHasPerm(user, "rob")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u62a2\u52ab\u5df2\u7ecf\u5f00\u542f\u4e86!", new Object[0]));
            return;
        }
        if (util.addUserToPermGroupByName(user, "\u62a2\u52ab\u7ec4")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u62a2\u52ab\u5f00\u542f\u6210\u529f!", new Object[0]));
        } else {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u62a2\u52ab\u5f00\u542f\u5931\u8d25!", new Object[0]));
        }
    }

    @MessageAuthorize(text={"\u5173\u95ed \u62a2\u52ab"}, userPermissions={"owner", "admin"})
    public void endRob(GroupMessageEvent event) {
        PermUtil util = PermUtil.INSTANCE;
        Group group = event.getGroup();
        cn.chahuyun.authorize.entity.User user = cn.chahuyun.authorize.entity.User.Companion.group(group.getId());
        if (!util.checkUserHasPerm(user, "rob")) {
            group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u62a2\u52ab\u5df2\u7ecf\u5173\u95ed!", new Object[0]));
            return;
        }
        PermGroup permGroup = util.talkPermGroupByName("\u62a2\u52ab\u7ec4");
        Perm perm = util.takePerm("rob");
        permGroup.getPerms().remove(perm);
        permGroup.save();
        group.sendMessage((Message)MessageUtil.formatMessageChain(event.getMessage(), "\u672c\u7fa4\u7684\u62a2\u52ab\u5173\u95ed\u6210\u529f!", new Object[0]));
    }
}

