/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.constant.ImageDrawXY;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.manager.TitleManager;
import cn.chahuyun.economy.manager.UserManager;
import cn.chahuyun.economy.plugin.ImageManager;
import cn.chahuyun.economy.plugin.PluginManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.ImageUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.mamoe.mirai.contact.AvatarSpec;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;

@EventComponent
public class SignManager {
    private static int index = 0;

    @MessageAuthorize(text={"\u7b7e\u5230", "\u6253\u5361", "sign"})
    public static void sign(MessageEvent event) {
        double goldNumber;
        Log.info("\u7b7e\u5230\u6307\u4ee4");
        User user = event.getSender();
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        UserInfo userInfo = UserManager.getUserInfo(user);
        MessageChainBuilder messages = MessageUtil.quoteReply(message);
        if (userInfo == null) {
            subject.sendMessage("\u7b7e\u5230\u5931\u8d25!");
            return;
        }
        if (!userInfo.sign()) {
            messages.append((SingleMessage)new PlainText("\u4f60\u5df2\u7ecf\u7b7e\u5230\u8fc7\u4e86\u54e6!"));
            subject.sendMessage((Message)messages.build());
            return;
        }
        PlainText plainText = null;
        int randomNumber = RandomUtil.randomInt((int)0, (int)10);
        if (randomNumber > 7) {
            randomNumber = RandomUtil.randomInt((int)0, (int)10);
            if (randomNumber > 8) {
                goldNumber = RandomUtil.randomInt((int)200, (int)501);
                plainText = new PlainText(String.format("\u5367\u69fd,\u4f60\u5bb6\u7956\u575f\u88c2\u4e86,\u5192\u51fa%s\u91d1\u5e01", goldNumber));
            } else {
                goldNumber = RandomUtil.randomInt((int)100, (int)200);
                plainText = new PlainText(String.format("\u54c7\u5076,\u4f60\u4eca\u5929\u8fd0\u6c14\u7206\u68da,\u83b7\u5f97%s\u91d1\u5e01", goldNumber));
            }
        } else {
            goldNumber = RandomUtil.randomInt((int)50, (int)100);
        }
        if (TitleManager.checkTitleIsOnEnable(userInfo, "sign-15")) {
            goldNumber *= 2.0;
        }
        if (!EconomyUtil.plusMoneyToUser(userInfo.getUser(), goldNumber)) {
            subject.sendMessage("\u7b7e\u5230\u5931\u8d25!");
            return;
        }
        userInfo.setSignEarnings(goldNumber);
        HibernateFactory.merge((Object)userInfo);
        double moneyBytUser = EconomyUtil.getMoneyByUser(userInfo.getUser());
        messages.append((SingleMessage)new PlainText("\u7b7e\u5230\u6210\u529f!"));
        messages.append((SingleMessage)new PlainText(String.format("\u91d1\u5e01:%s(+%s)", moneyBytUser, goldNumber)));
        if (userInfo.getOldSignNumber() != 0) {
            messages.append((CharSequence)String.format("\u4f60\u7684\u8fde\u7b7e\u7ebf\u65ad\u5728\u4e86%d\u5929,\u53ef\u60dc~", userInfo.getOldSignNumber()));
        }
        if (plainText != null) {
            messages.append((SingleMessage)plainText);
        }
        TitleManager.checkSignTitle(userInfo, subject);
        TitleManager.checkMonopoly(userInfo, subject);
        SignManager.sendSignImage(userInfo, subject, messages.build());
    }

    public static void sendSignImage(UserInfo userInfo, Contact subject, MessageChain messages) {
        BufferedImage userInfoImageBase = UserManager.getUserInfoImageBase(userInfo);
        if (userInfoImageBase == null) {
            return;
        }
        Graphics2D graphics = ImageUtil.getG2d(userInfoImageBase);
        if (PluginManager.isCustomImage) {
            graphics.setColor(Color.BLACK);
            graphics.setFont(ImageManager.getCustomFont());
            ImageUtil.drawString(messages.contentToString(), ImageDrawXY.A_WORD.getX(), ImageDrawXY.A_WORD.getY(), 440, graphics);
        } else {
            int fontSize = 20;
            graphics.setColor(Color.black);
            AtomicInteger x = new AtomicInteger(210);
            graphics.setFont(new Font("\u9ed1\u4f53", 0, fontSize));
            messages.forEach(v -> {
                graphics.drawString(v.contentToString(), 520, x.get());
                x.addAndGet(28);
            });
        }
        graphics.dispose();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)userInfoImageBase, "png", stream);
        }
        catch (IOException e) {
            Log.error("\u7b7e\u5230\u7ba1\u7406:\u7b7e\u5230\u56fe\u7247\u53d1\u9001\u9519\u8bef!", e);
            subject.sendMessage((Message)messages);
            return;
        }
        Contact.sendImage((Contact)subject, (InputStream)new ByteArrayInputStream(stream.toByteArray()));
    }

    @Deprecated(since="\u5df2\u5e9f\u5f03")
    public static void sendSignImage(UserInfo userInfo, User user, Contact subject, double money, double obtain, MessageChain messages) {
        HuYanEconomy instance = HuYanEconomy.INSTANCE;
        try {
            InputStream asStream = instance.getResourceAsStream("sign" + (index % 4 == 0 ? 4 : index % 4) + ".png");
            ++index;
            if (asStream == null) {
                Log.error("\u7b7e\u5230\u56fe\u7247\u83b7\u53d6\u9519\u8bef!");
                return;
            }
            BufferedImage image = ImageIO.read(asStream);
            Graphics2D pen = ImageUtil.getG2d(image);
            String avatarUrl = user.getAvatarUrl(AvatarSpec.LARGE);
            BufferedImage avatar = ImageIO.read(new URL(avatarUrl));
            pen.setColor(Color.WHITE);
            pen.setFont(new Font("\u9ed1\u4f53", 1, 60));
            pen.drawString(userInfo.getName(), 200, 155);
            if (String.valueOf(money).length() > 5) {
                pen.setFont(new Font("\u9ed1\u4f53", 0, 24));
                pen.setColor(Color.black);
                pen.drawString(String.valueOf(money), 600, 410);
                pen.setFont(new Font("\u9ed1\u4f53", 0, 28));
            } else {
                pen.setFont(new Font("\u9ed1\u4f53", 0, 28));
                pen.setColor(Color.black);
                pen.drawString(String.valueOf(money), 600, 410);
            }
            pen.drawString(String.valueOf(userInfo.getQq()), 172, 240);
            pen.drawString(String.valueOf(obtain), 810, 410);
            pen.setFont(new Font("\u9ed1\u4f53", 0, 23));
            pen.drawString(DateUtil.format((Date)userInfo.getSignTime(), (String)"yyyy-MM-dd HH:mm:ss"), 172, 320);
            pen.drawString(String.valueOf(userInfo.getSignNumber()), 172, 360);
            pen.drawString(DateUtil.format((Date)DateUtil.offsetDay((Date)userInfo.getSignTime(), (int)1), (String)"yyyy-MM-dd HH:mm:ss"), 221, 402);
            pen.drawString("\u6682\u65e0", 172, 440);
            AtomicInteger x = new AtomicInteger(210);
            pen.setFont(new Font("\u9ed1\u4f53", 0, 22));
            messages.forEach(v -> {
                pen.drawString(v.contentToString(), 520, x.get());
                x.addAndGet(28);
            });
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", stream);
            Contact.sendImage((Contact)subject, (InputStream)new ByteArrayInputStream(stream.toByteArray()));
        }
        catch (IOException e) {
            Log.error(e);
        }
    }

    private static void refreshSignImage() {
        HuYanEconomy instance = HuYanEconomy.INSTANCE;
        InputStream asStream = instance.getResourceAsStream("sign" + (index % 4 == 0 ? 4 : index % 4) + ".png");
        ++index;
        File file = instance.resolveDataFile("sign.png");
        if (file.exists() && file.delete()) {
            Log.debug("\u7b7e\u5230\u7ba1\u7406:\u7b7e\u5230\u56fe\u7247\u5237\u65b0\u6210\u529f");
        }
        assert (asStream != null);
        try {
            Files.copy(asStream, file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Log.error("\u7b7e\u5230\u7ba1\u7406:\u7b7e\u5230\u56fe\u7247\u5237\u65b0\u5931\u8d25", e);
        }
    }
}

