/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.authorize.constant.MessageMatchingEnum;
import cn.chahuyun.economy.constant.TitleCode;
import cn.chahuyun.economy.entity.TitleInfo;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.fish.FishRanking;
import cn.chahuyun.economy.entity.title.TitleTemplate;
import cn.chahuyun.economy.entity.title.TitleTemplateSimpleImpl;
import cn.chahuyun.economy.manager.UserManager;
import cn.chahuyun.economy.plugin.TitleTemplateManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.SingleMessage;
import org.jetbrains.annotations.NotNull;

@EventComponent
public class TitleManager {
    public static void init() {
        TitleTemplateManager.registerTitleTemplate((TitleTemplate[])new TitleTemplateSimpleImpl[]{new TitleTemplateSimpleImpl("sign-15", TitleCode.SIGN_15_EXPIRED, "\u7b7e\u5230\u72c2\u4eba", true, false, "[\u53ea\u662f\u4e2a\u4f20\u8bf4]", new Color(16744272), new Color(16737096)), new TitleTemplateSimpleImpl("monopoly-0", TitleCode.MONOPOLY_EXPIRED, "\u5927\u5bcc\u7fc1", true, true, "[\u5927\u5bcc\u7fc1]", new Color(16729943), new Color(16753922)), new TitleTemplateSimpleImpl("regal-30", TitleCode.REGAL_EXPIRED, "\u5c0f\u5bcc\u7fc1", (Double)10000.0, true, false, "[\u5c0f\u5bcc\u7fc1]", new Color(15518824), new Color(16753922)), new TitleTemplateSimpleImpl("fishing", TitleCode.FISHING_EXPIRED, "\u9493\u9c7c\u4f6c", true, true, "[\u9093\u521a]", new Color(15740866), new Color(6329578)), new TitleTemplateSimpleImpl("bet-monster", TitleCode.BET_MONSTER_EXPIRED, "\u8d4c\u602a", true, true, "[17\u5f20\u724c\u80fd\u79d2\u6211?]", new Color(0xFF0000), new Color(0x730000))});
        List titleInfos = HibernateFactory.selectList(TitleInfo.class);
        block10: for (TitleInfo titleInfo : titleInfos) {
            if (titleInfo.getCode() != null) continue;
            switch (titleInfo.getTitle()) {
                case "[\u53ea\u662f\u4e2a\u4f20\u8bf4]": {
                    HibernateFactory.merge((Object)titleInfo.setCode("sign-15").setName("\u7b7e\u5230\u72c2\u4eba"));
                    continue block10;
                }
                case "[\u5927\u5bcc\u7fc1]": {
                    HibernateFactory.merge((Object)titleInfo.setCode("monopoly-0").setName("\u5927\u5bcc\u7fc1"));
                    continue block10;
                }
                case "[\u5c0f\u5bcc\u7fc1]": {
                    HibernateFactory.merge((Object)titleInfo.setCode("regal-30").setName("\u5c0f\u5bcc\u7fc1"));
                    continue block10;
                }
            }
        }
    }

    public static TitleInfo getDefaultTitle(UserInfo userInfo) {
        List titleList = HibernateFactory.selectList(TitleInfo.class, (String)"userId", (Object)userInfo.getQq());
        if (!titleList.isEmpty()) {
            for (TitleInfo info : titleList) {
                if (TitleManager.checkTitleTime(info) || !info.isStatus()) continue;
                return info;
            }
        }
        return TitleManager.getInfo(userInfo);
    }

    @NotNull
    private static TitleInfo getInfo(UserInfo userInfo) {
        TitleInfo titleInfo = new TitleInfo();
        titleInfo.setGradient(false);
        User user = userInfo.getUser();
        if (user instanceof Member) {
            String color;
            Member member = (Member)user;
            String title = member.getSpecialTitle();
            if (title.isBlank()) {
                title = member.getRankTitle();
                color = "8a8886";
                if (title.isBlank()) {
                    title = "[\u65e0]";
                }
            } else {
                color = "ff00ff";
            }
            titleInfo.setTitle(String.format("[%s]", title));
            titleInfo.setSColor(color);
        } else {
            titleInfo.setTitle("[\u65e0]");
            titleInfo.setSColor("ff00ff");
        }
        return titleInfo;
    }

    public static boolean addTitleInfo(UserInfo userInfo, String titleTemplateCode) {
        TitleInfo title = TitleTemplateManager.createTitle(titleTemplateCode, userInfo);
        if (title == null) {
            throw new RuntimeException("\u79f0\u53f7code\u9519\u8bef\u6216\u8be5\u79f0\u53f7\u6ca1\u6709\u5728\u79f0\u53f7\u6a21\u7248\u7ba1\u7406\u4e2d\u6ce8\u518c!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", title.getCode());
        params.put("userId", title.getUserId());
        TitleInfo selectOne = (TitleInfo)HibernateFactory.selectOne(TitleInfo.class, params);
        if (selectOne != null) {
            return false;
        }
        return ((TitleInfo)HibernateFactory.merge((Object)title)).getId() != 0;
    }

    @MessageAuthorize(text={"\u6211\u7684\u79f0\u53f7", "\u79f0\u53f7\u5217\u8868", "\u62e5\u6709\u79f0\u53f7"})
    public static void viewTitleInfo(MessageEvent event) {
        Log.info("\u67e5\u8be2\u79f0\u53f7\u6307\u4ee4");
        Contact subject = event.getSubject();
        long id = event.getSender().getId();
        MessageChainBuilder builder = new MessageChainBuilder();
        builder.append((SingleMessage)new QuoteReply((MessageSource)event.getSource()));
        List titleList = HibernateFactory.selectList(TitleInfo.class, (String)"userId", (Object)id);
        if (titleList.isEmpty()) {
            subject.sendMessage((Message)builder.append((CharSequence)"\u4f60\u8fd8\u6ca1\u6709\u79f0\u53f7!").build());
            return;
        }
        builder.append((CharSequence)"\u4f60\u62e5\u6709\u7684\u79f0\u53f7\u5982\u4e0b:\n");
        int index = 0;
        for (TitleInfo titleInfo : titleList) {
            if (TitleManager.checkTitleTime(titleInfo)) continue;
            Object titleName = titleInfo.getName();
            if (titleInfo.isStatus()) {
                titleName = (String)titleName + ":\u5df2\u542f\u7528";
            }
            builder.append((CharSequence)String.format("%d-%s%n", ++index, titleName));
        }
        if (index != 0) {
            subject.sendMessage((Message)builder.build());
        } else {
            subject.sendMessage("\u4f60\u8fd8\u6ca1\u6709\u79f0\u53f7!");
        }
    }

    @MessageAuthorize(text={"\u79f0\u53f7\u5546\u5e97"})
    public static void viewCanByTitle(MessageEvent event) {
        Log.info("\u67e5\u8be2\u79f0\u53f7\u5546\u5e97\u6307\u4ee4");
        MessageChainBuilder builder = new MessageChainBuilder();
        builder.append((CharSequence)"\u53ef\u8d2d\u4e70\u7684\u79f0\u53f7\u5982\u4e0b:\n");
        List<TitleTemplate> canBuyTemplate = TitleTemplateManager.getCanBuyTemplate();
        for (TitleTemplate template : canBuyTemplate) {
            builder.append((CharSequence)String.format("%s - %s \u91d1\u5e01-\u6709\u6548\u671f: %s%n", template.getTitleName(), template.getPrice(), template.getValidityPeriod() > 0 ? template.getValidityPeriod() + "\u5929" : "\u6c38\u4e45"));
        }
        event.getSubject().sendMessage((Message)builder.build());
    }

    @MessageAuthorize(text={"\u8d2d\u4e70\u79f0\u53f7 (\\S+)"}, messageMatching=MessageMatchingEnum.REGULAR)
    public static void buyTitle(MessageEvent event) {
        Log.info("\u8d2d\u4e70\u79f0\u53f7\u6307\u4ee4");
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        List<TitleTemplate> canBuyTemplate = TitleTemplateManager.getCanBuyTemplate();
        if (canBuyTemplate.isEmpty()) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u6ca1\u6709\u79f0\u53f7\u552e\u5356!", new Object[0]));
            return;
        }
        String content = message.contentToString();
        User sender = event.getSender();
        for (TitleTemplate template : canBuyTemplate) {
            if (!template.getTitleName().equals(content.split(" +")[1])) continue;
            double moneyByUser = EconomyUtil.getMoneyByUser(sender);
            if (moneyByUser < template.getPrice()) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u7684\u91d1\u5e01\u4e0d\u591f %s ,\u65e0\u6cd5\u8d2d\u4e70 %s \u79f0\u53f7!", template.getPrice(), template.getTitleName()));
                return;
            }
            UserInfo userInfo = UserManager.getUserInfo(sender);
            if (TitleManager.checkTitleIsExist(userInfo, template.getTemplateCode())) {
                subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u5df2\u7ecf\u62e5\u6709 %s \u79f0\u53f7!", template.getTitleName()));
                return;
            }
            if (EconomyUtil.minusMoneyToUser(sender, template.getPrice())) {
                if (TitleManager.addTitleInfo(userInfo, template.getTemplateCode())) {
                    subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u4ee5\u6210\u529f\u8d2d\u4e70 %s \u79f0\u53f7,\u6709\u6548\u671f %s ", template.getTitleName(), template.getValidityPeriod() <= 0 ? "\u65e0\u9650" : template.getValidityPeriod() + "\u5929"));
                } else {
                    subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u8d2d\u4e70 %s \u79f0\u53f7\u5931\u8d25", template.getTitleName()));
                }
            }
            return;
        }
        subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u6ca1\u6709\u8fd9\u4e2a\u79f0\u53f7!", new Object[0]));
    }

    @MessageAuthorize(text={"\u5207\u6362\u79f0\u53f7 (\\d+)"}, messageMatching=MessageMatchingEnum.REGULAR)
    public static void userTitle(MessageEvent event) {
        Log.info("\u5207\u6362\u79f0\u53f7\u6307\u4ee4");
        User user = event.getSender();
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        String content = message.contentToString();
        String[] split = content.split(" +");
        int i = Integer.parseInt(split[1]);
        List titleInfos = HibernateFactory.selectList(TitleInfo.class, (String)"userId", (Object)user.getId());
        if (titleInfos.isEmpty()) {
            subject.sendMessage("\u4f60\u7684\u79f0\u53f7\u4e3a\u7a7a!");
            return;
        }
        int index = 0;
        for (TitleInfo titleInfo : titleInfos) {
            if (++index == i) {
                titleInfo.setStatus(true);
                HibernateFactory.merge((Object)titleInfo);
                subject.sendMessage(String.format("\u5df2\u5207\u6362\u79f0\u53f7\u4e3a %s ", titleInfo.getName()));
                continue;
            }
            titleInfo.setStatus(false);
            HibernateFactory.merge((Object)titleInfo);
        }
        if (i == 0) {
            subject.sendMessage("\u5df2\u5207\u6362\u4e3a\u9ed8\u8ba4\u79f0\u53f7!");
        }
    }

    public static boolean checkTitleIsExist(UserInfo userInfo, String titleCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userInfo.getQq());
        params.put("code", titleCode);
        TitleInfo titleInfo = (TitleInfo)HibernateFactory.selectOne(TitleInfo.class, params);
        return titleInfo != null;
    }

    public static boolean checkTitleIsOnEnable(UserInfo userInfo, String titleCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userInfo.getQq());
        params.put("code", titleCode);
        params.put("status", true);
        TitleInfo titleInfo = (TitleInfo)HibernateFactory.selectOne(TitleInfo.class, params);
        return titleInfo != null;
    }

    private static boolean checkTitleTime(TitleInfo titleInfo) {
        if (titleInfo.getDueTime() != null && DateUtil.between((Date)new Date(), (Date)titleInfo.getDueTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < 0L) {
            HibernateFactory.delete((Object)titleInfo);
            return true;
        }
        return false;
    }

    public static void checkMonopoly(UserInfo userInfo, Contact subject) {
        double moneyByUser = EconomyUtil.getMoneyByUser(userInfo.getUser());
        if (moneyByUser > 100000.0) {
            if (TitleManager.checkTitleIsExist(userInfo, "monopoly-0")) {
                return;
            }
            TitleManager.addTitleInfo(userInfo, "monopoly-0");
            MessageChainBuilder builder = new MessageChainBuilder();
            builder.append((SingleMessage)new At(userInfo.getQq()));
            builder.append((CharSequence)"\u606d\u559c!\u4f60\u7684\u91d1\u5e01\u6570\u91cf\u5927\u4e8e 100000 ,\u83b7\u5f97\u6c38\u4e45\u79f0\u53f7 [\u5927\u5bcc\u7fc1] !");
            subject.sendMessage((Message)builder.build());
        }
    }

    public static void checkSignTitle(UserInfo userInfo, Contact subject) {
        int signNumber = userInfo.getSignNumber();
        if (signNumber == 15) {
            if (TitleManager.checkTitleIsExist(userInfo, "sign-15")) {
                return;
            }
            TitleManager.addTitleInfo(userInfo, "sign-15");
            MessageChainBuilder builder = new MessageChainBuilder();
            builder.append((SingleMessage)new At(userInfo.getQq()));
            builder.append((CharSequence)"\u606d\u559c!\u4f60\u5df2\u7ecf\u8fde\u7eed\u7b7e\u5230 15 \u5929,\u83b7\u5f9715\u5929\u79f0\u53f7 \u7b7e\u5230\u72c2\u4eba !");
            subject.sendMessage((Message)builder.build());
        }
    }

    public static void checkFishTitle(UserInfo userInfo, Contact subject) {
        HashMap map = new HashMap();
        FishRanking fishRanking = (FishRanking)HibernateFactory.selectOneByHql(FishRanking.class, (String)"from FishRanking order by money desc limit 1", map);
        if (fishRanking == null || fishRanking.getQq() != userInfo.getQq()) {
            return;
        }
        TitleInfo titleInfo = (TitleInfo)HibernateFactory.selectOne(TitleInfo.class, (String)"code", (Object)"fishing");
        if (TitleManager.checkTitleIsExist(userInfo, "fishing")) {
            return;
        }
        if (TitleManager.addTitleInfo(userInfo, "fishing")) {
            subject.sendMessage((Message)MessageUtil.formatMessageChain(userInfo.getQq(), "\u606d\u559c\u4f60\u65a9\u83b7\u9493\u9c7c\u699c\u699c\u9996!\u83b7\u5f97\u9493\u9c7c\u4f6c\u79f0\u53f7!", new Object[0]));
            if (titleInfo != null) {
                HibernateFactory.delete((Object)titleInfo);
            }
        }
    }
}

