/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.manager;

import cn.chahuyun.authorize.EventComponent;
import cn.chahuyun.authorize.MessageAuthorize;
import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.constant.ImageDrawXY;
import cn.chahuyun.economy.entity.TitleInfo;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.yiyan.YiYan;
import cn.chahuyun.economy.manager.TitleManager;
import cn.chahuyun.economy.plugin.ImageManager;
import cn.chahuyun.economy.plugin.PluginManager;
import cn.chahuyun.economy.plugin.YiYanManager;
import cn.chahuyun.economy.utils.EconomyUtil;
import cn.chahuyun.economy.utils.ImageUtil;
import cn.chahuyun.economy.utils.Log;
import cn.chahuyun.economy.utils.MessageUtil;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.mamoe.mirai.contact.AvatarSpec;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.SingleMessage;
import org.jetbrains.annotations.NotNull;
import xyz.cssxsh.mirai.economy.service.EconomyAccount;

@EventComponent
public class UserManager {
    private static int index = 1;

    @NotNull
    public static UserInfo getUserInfo(User user) {
        long userId = user.getId();
        UserInfo one = (UserInfo)HibernateFactory.selectOne(UserInfo.class, (String)"qq", (Object)userId);
        if (one == null) {
            UserInfo info = new UserInfo(userId, 0L, user.getNick(), new Date());
            if (user instanceof Member) {
                Member member = (Member)user;
                info.setRegisterGroup(member.getGroup().getId());
            }
            return ((UserInfo)HibernateFactory.merge((Object)info)).setUser(user);
        }
        return one.setUser(user);
    }

    @NotNull
    public static UserInfo getUserInfo(EconomyAccount account) {
        String userId = account.getUuid();
        try {
            UserInfo userInfo = (UserInfo)HibernateFactory.selectOne(UserInfo.class, (Object)userId);
            if (userInfo == null) {
                throw new RuntimeException();
            }
            return userInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8be5\u7ecf\u6d4e\u8d26\u53f7\u4e0d\u5b58\u5728\u7528\u6237\u4fe1\u606f");
        }
    }

    @MessageAuthorize(text={"\u4e2a\u4eba\u4fe1\u606f", "info"})
    public static void getUserInfoImage(MessageEvent event) {
        Log.info("\u4e2a\u4eba\u4fe1\u606f\u6307\u4ee4");
        Contact subject = event.getSubject();
        User sender = event.getSender();
        UserInfo userInfo = UserManager.getUserInfo(sender);
        TitleManager.checkMonopoly(userInfo, event.getSubject());
        double moneyByUser = EconomyUtil.getMoneyByUser(sender);
        MessageChainBuilder singleMessages = new MessageChainBuilder();
        try {
            net.mamoe.mirai.message.data.Image image = Contact.uploadImage((Contact)subject, (InputStream)new URL(sender.getAvatarUrl(AvatarSpec.LARGE)).openConnection().getInputStream());
            singleMessages.append((SingleMessage)image);
        }
        catch (IOException e) {
            Log.error("\u7528\u6237\u7ba1\u7406:\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u4e0a\u4f20\u56fe\u7247\u51fa\u9519!", e);
        }
        if (userInfo == null) {
            subject.sendMessage("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u51fa\u9519!");
            return;
        }
        singleMessages.append((CharSequence)userInfo.getString()).append((CharSequence)String.format("\u91d1\u5e01:%s", moneyByUser));
        BufferedImage userInfoImageBase = UserManager.getUserInfoImageBase(userInfo);
        if (userInfoImageBase == null) {
            subject.sendMessage((Message)singleMessages.build());
            return;
        }
        YiYan yiYan = YiYanManager.getYiyan();
        if (yiYan == null) {
            String str = HttpUtil.get((String)"https://v1.hitokoto.cn");
            Log.debug("yiyan->" + str);
            yiYan = str.isBlank() ? new YiYan(0, "\u65e0", "\u65e0", "\u65e0") : (YiYan)JSONUtil.parseObj((String)str).toBean(YiYan.class);
        }
        Graphics2D graphics = ImageUtil.getG2d(userInfoImageBase);
        graphics.setColor(Color.black);
        String hitokoto = yiYan.getHitokoto();
        String signature = "--" + (yiYan.getAuthor() == null ? "\u65e0\u94ed" : yiYan.getAuthor()) + ":" + yiYan.getFrom();
        if (PluginManager.isCustomImage) {
            graphics.setFont(ImageManager.getCustomFont());
            ImageUtil.drawString(hitokoto, ImageDrawXY.A_WORD.getX(), ImageDrawXY.A_WORD.getY(), 440, graphics);
            graphics.drawString(signature, ImageDrawXY.A_WORD_FAMOUS.getX(), ImageDrawXY.A_WORD_FAMOUS.getY());
        } else {
            graphics.setFont(new Font("\u9ed1\u4f53", 0, 20));
            String[] yiyan = hitokoto.length() > 18 ? new String[]{hitokoto.substring(0, 18), hitokoto.substring(18), signature} : new String[]{hitokoto, signature};
            AtomicInteger x = new AtomicInteger(230);
            for (String s : yiyan) {
                graphics.drawString(s, 520, x.get());
                x.addAndGet(28);
            }
        }
        graphics.dispose();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)userInfoImageBase, "png", stream);
        }
        catch (IOException e) {
            Log.error("\u7b7e\u5230\u7ba1\u7406:\u7b7e\u5230\u56fe\u7247\u53d1\u9001\u9519\u8bef!", e);
            subject.sendMessage((Message)singleMessages.build());
            return;
        }
        Contact.sendImage((Contact)subject, (InputStream)new ByteArrayInputStream(stream.toByteArray()));
    }

    @MessageAuthorize(text={"money", "\u7ecf\u6d4e\u4fe1\u606f", "\u6211\u7684\u8d44\u91d1"})
    public void moneyInfo(MessageEvent event) {
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        User user = event.getSender();
        double money = EconomyUtil.getMoneyByUser(user);
        double bank = EconomyUtil.getMoneyByBank(user);
        subject.sendMessage((Message)MessageUtil.formatMessageChain(message, "\u4f60\u7684\u7ecf\u6d4e\u72b6\u51b5:%n\u94b1\u5305\u4f59\u989d:%.1f%n\u94f6\u884c\u5b58\u6b3e:%.1f", money, bank));
    }

    public static BufferedImage getUserInfoImageBase(UserInfo userInfo) {
        try {
            BufferedImage bufferedImage = UserManager.customBottom(userInfo);
            if (bufferedImage == null) {
                bufferedImage = UserManager.builtInBottom(userInfo);
            }
            return bufferedImage;
        }
        catch (IOException exception) {
            Log.error("\u7528\u6237\u7ba1\u7406:\u4e2a\u4eba\u4fe1\u606f\u57fa\u7840\u4fe1\u606f\u7ed8\u56fe\u9519\u8bef!", exception);
            return null;
        }
    }

    private static BufferedImage customBottom(UserInfo userInfo) throws IOException {
        BufferedImage bottom = ImageManager.getNextBottom();
        if (bottom == null) {
            return null;
        }
        User user = userInfo.getUser();
        String avatarUrl = user.getAvatarUrl(AvatarSpec.LARGE);
        BufferedImage avatar = ImageIO.read(new URL(avatarUrl));
        avatar = ImageUtil.makeRoundedCorner(avatar, 50);
        Graphics2D g2d = ImageUtil.getG2d(bottom);
        g2d.drawImage(avatar, ImageDrawXY.AVATAR.getX(), ImageDrawXY.AVATAR.getY(), avatar.getWidth(), avatar.getHeight(), null);
        Font font = ImageManager.getCustomFont();
        g2d.setFont(font);
        g2d.setColor(Color.BLACK);
        String id = String.valueOf(user.getId());
        TitleInfo title = TitleManager.getDefaultTitle(userInfo);
        g2d.setFont(font.deriveFont(32.0f));
        if (title.isGradient()) {
            ImageUtil.drawStringGradient(title.getTitle(), ImageDrawXY.TITLE.getX(), ImageDrawXY.TITLE.getY(), title.getStartColor(), title.getEndColor(), g2d);
            ImageUtil.drawStringGradient(id, ImageDrawXY.ID.getX(), ImageDrawXY.ID.getY(), title.getStartColor(), title.getEndColor(), g2d);
        } else {
            g2d.setColor(title.getStartColor());
            g2d.drawString(id, ImageDrawXY.ID.getX(), ImageDrawXY.ID.getY());
            g2d.drawString(title.getTitle(), ImageDrawXY.TITLE.getX(), ImageDrawXY.TITLE.getY());
        }
        String nick = user.getNick();
        boolean gradient = false;
        Color sColor = null;
        Color eColor = null;
        if (title.isImpactName()) {
            gradient = true;
            sColor = title.getStartColor();
            eColor = title.getEndColor();
        } else if (user instanceof Member) {
            gradient = true;
            Member member = (Member)user;
            if (member.getPermission() == MemberPermission.OWNER) {
                sColor = new Color(68, 138, 255);
                eColor = new Color(100, 255, 218);
            } else if (member.getPermission() == MemberPermission.ADMINISTRATOR) {
                sColor = new Color(72, 241, 155);
                eColor = new Color(140, 241, 72);
            } else {
                sColor = ImageUtil.hexColor("fce38a");
                eColor = ImageUtil.hexColor("f38181");
            }
        }
        if (nick.length() > 16) {
            g2d.setFont(font.deriveFont(1, 50.0f));
        } else {
            g2d.setFont(font.deriveFont(1, 60.0f));
        }
        if (gradient) {
            ImageUtil.drawStringGradient(nick, ImageDrawXY.NICK_NAME.getX(), ImageDrawXY.NICK_NAME.getY(), sColor, eColor, g2d);
            g2d.setColor(Color.BLACK);
        } else {
            g2d.setColor(Color.BLACK);
            g2d.drawString(nick, ImageDrawXY.NICK_NAME.getX(), ImageDrawXY.NICK_NAME.getY());
        }
        String signTime = userInfo.getSignTime() == null ? "\u6682\u672a\u7b7e\u5230" : DateUtil.format((Date)userInfo.getSignTime(), (String)"yyyy-MM-dd HH:mm:ss");
        g2d.setFont(font.deriveFont(0, 24.0f));
        g2d.drawString(signTime, ImageDrawXY.SIGN_TIME.getX(), ImageDrawXY.SIGN_TIME.getY());
        g2d.drawString(String.valueOf(userInfo.getSignNumber()), ImageDrawXY.SIGN_NUM.getX(), ImageDrawXY.SIGN_NUM.getY());
        String money = String.valueOf(EconomyUtil.getMoneyByUser(user));
        String bank = String.valueOf(EconomyUtil.getMoneyByBank(user));
        g2d.setFont(font.deriveFont(32.0f));
        g2d.drawString(money, ImageDrawXY.MY_MONEY.getX(), ImageDrawXY.MY_MONEY.getY());
        g2d.drawString(String.valueOf(userInfo.getSignEarnings()), ImageDrawXY.SIGN_OBTAIN.getX(), ImageDrawXY.SIGN_OBTAIN.getY());
        g2d.drawString(bank, ImageDrawXY.BANK_MONEY.getX(), ImageDrawXY.BANK_MONEY.getY());
        g2d.drawString(String.valueOf(userInfo.getBankEarnings()), ImageDrawXY.BANK_INTEREST.getX(), ImageDrawXY.BANK_INTEREST.getY());
        g2d.dispose();
        return bottom;
    }

    private static BufferedImage builtInBottom(UserInfo userInfo) throws IOException {
        HuYanEconomy instance = HuYanEconomy.INSTANCE;
        User user = userInfo.getUser();
        InputStream asStream = instance.getResourceAsStream("sign" + (index % 4 == 0 ? 4 : index % 4) + ".png");
        ++index;
        if (asStream == null) {
            Log.error("\u7528\u6237\u7ba1\u7406:\u4e2a\u4eba\u4fe1\u606f\u56fe\u7247\u5e95\u56fe\u83b7\u53d6\u9519\u8bef!");
            return null;
        }
        BufferedImage image = ImageIO.read(asStream);
        Graphics2D pen = ImageUtil.getG2d(image);
        String avatarUrl = user.getAvatarUrl(AvatarSpec.LARGE);
        BufferedImage avatar = ImageIO.read(new URL(avatarUrl));
        BufferedImage avatarRounder = ImageUtil.makeRoundedCorner(avatar, 50);
        pen.drawImage((Image)avatarRounder, 24, 25, null);
        String userInfoName = userInfo.getName();
        if (user instanceof Member) {
            MemberPermission permission = ((Member)user).getPermission();
            if (permission == MemberPermission.OWNER) {
                pen.setColor(Color.YELLOW);
            } else if (permission == MemberPermission.ADMINISTRATOR) {
                pen.setColor(Color.GREEN);
            } else {
                pen.setColor(Color.WHITE);
            }
        }
        int fontSize = userInfoName.length() > 6 ? 40 : 60;
        Font font = new Font("\u9ed1\u4f53", 1, fontSize);
        pen.setFont(font);
        pen.drawString(userInfoName, 200, 155);
        pen.setColor(Color.black);
        fontSize = 24;
        font = new Font("\u9ed1\u4f53", 0, fontSize);
        pen.setFont(font);
        pen.drawString(String.valueOf(userInfo.getQq()), 172, 240);
        String format = userInfo.getSignTime() == null ? "\u6682\u672a\u7b7e\u5230" : DateUtil.format((Date)userInfo.getSignTime(), (String)"yyyy-MM-dd HH:mm:ss");
        pen.drawString(format, 172, 320);
        pen.drawString(String.valueOf(userInfo.getSignNumber()), 172, 360);
        double money = EconomyUtil.getMoneyByUser(user);
        double bank = EconomyUtil.getMoneyByBank(user);
        if (String.valueOf(money).length() > 5) {
            fontSize = 20;
        }
        font = new Font("\u9ed1\u4f53", 0, fontSize);
        pen.setFont(font);
        pen.drawString(String.valueOf(money), 600, 410);
        fontSize = 24;
        font = new Font("\u9ed1\u4f53", 0, fontSize);
        pen.setFont(font);
        pen.drawString(String.valueOf(userInfo.getSignEarnings()), 810, 410);
        if (String.valueOf(bank).length() > 5) {
            fontSize = 20;
        }
        font = new Font("\u9ed1\u4f53", 0, fontSize);
        pen.setFont(font);
        pen.drawString(String.valueOf(bank), 600, 460);
        fontSize = 24;
        double bankEarnings = userInfo.getBankEarnings();
        if (String.valueOf(bankEarnings).length() > 5) {
            fontSize = 20;
        }
        font = new Font("\u9ed1\u4f53", 0, fontSize);
        pen.setFont(font);
        pen.drawString(String.valueOf(bankEarnings), 810, 460);
        fontSize = 15;
        pen.setColor(new Color(255, 255, 255, 230));
        font = new Font("\u9ed1\u4f53", 2, fontSize);
        pen.setFont(font);
        pen.drawString("by Mirai & HuYanEconomy(\u58f6\u8a00\u7ecf\u6d4e) 1.4.9", 540, 525);
        pen.dispose();
        return image;
    }
}

