/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.plugin;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.fish.Fish;
import cn.chahuyun.economy.entity.fish.FishInfo;
import cn.chahuyun.hibernateplus.HibernateFactory;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FishManager {
    private static final Map<Integer, List<Fish>> fishMap = new HashMap<Integer, List<Fish>>();

    private FishManager() {
    }

    public static void init() {
        List fishList = HibernateFactory.selectList(Fish.class);
        if (fishList == null || fishList.isEmpty()) {
            FishManager.reloadFish();
            return;
        }
        FishManager.readFish(fishList);
        List fishInfos = HibernateFactory.selectList(FishInfo.class);
        for (FishInfo fishInfo : fishInfos) {
            HibernateFactory.merge((Object)fishInfo.setStatus(false));
        }
    }

    public static List<Fish> getLevelFishList(int fishLevel) {
        return fishMap.get(fishLevel);
    }

    private static void reloadFish() {
        HuYanEconomy instance = HuYanEconomy.INSTANCE;
        InputStream resourceAsStream = instance.getResourceAsStream("fish.xls");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u7b49\u7ea7", "level");
        map.put("\u540d\u79f0", "name");
        map.put("\u63cf\u8ff0", "description");
        map.put("\u5355\u4ef7", "price");
        map.put("\u6700\u5c0f\u5c3a\u5bf8", "dimensionsMin");
        map.put("\u6700\u5927\u5c3a\u5bf8", "dimensionsMax");
        map.put("\u5c3a\u5bf81\u9636", "dimensions1");
        map.put("\u5c3a\u5bf82\u9636", "dimensions2");
        map.put("\u5c3a\u5bf83\u9636", "dimensions3");
        map.put("\u5c3a\u5bf84\u9636", "dimensions4");
        map.put("\u96be\u5ea6", "difficulty");
        map.put("\u7279\u6b8a\u6807\u8bb0", "special");
        ExcelReader reader = ExcelUtil.getReader((InputStream)resourceAsStream);
        List fishList = ((ExcelReader)reader.setHeaderAlias(map)).readAll(Fish.class);
        for (Fish fish : fishList) {
            HibernateFactory.merge((Object)fish);
        }
        FishManager.readFish(fishList);
    }

    private static void readFish(List<Fish> list) {
        for (final Fish fish : list) {
            int level = fish.getLevel();
            if (fishMap.containsKey(level)) {
                fishMap.get(level).add(fish);
                continue;
            }
            fishMap.put(level, (List<Fish>)new ArrayList<Fish>(){
                {
                    this.add(fish);
                }
            });
        }
    }
}

