/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.plugin;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.utils.ImageUtil;
import cn.chahuyun.economy.utils.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ImageManager {
    private static int next = 1;
    private static final List<BufferedImage> bufferedImages = new ArrayList<BufferedImage>(8);
    private static Font customFont;

    protected static void init(HuYanEconomy instance) throws IOException, FontFormatException {
        Log.info("\u5f00\u59cb\u52a0\u8f7d\u5b57\u4f53...");
        Path path = instance.getDataFolderPath();
        File font = path.resolve("font").toFile();
        if (font.exists()) {
            File[] files = font.listFiles();
            if (files != null && files.length != 0) {
                customFont = Font.createFont(0, files[0]).deriveFont(24.0f);
            }
        } else {
            customFont = new Font("\u5b8b\u4f53", 0, 24);
        }
        File bottom = path.resolve("bottom").toFile();
        if (!bottom.exists()) {
            return;
        }
        BufferedImage bottomPng = ImageIO.read(Objects.requireNonNull(instance.getResourceAsStream("bottom.png")));
        File[] files = bottom.listFiles();
        if (files != null) {
            int totalFiles = files.length;
            int step = totalFiles / 5;
            int currentStep = 0;
            Log.info("\u5f00\u59cb\u52a0\u8f7d\u81ea\u5b9a\u4e49\u56fe\u7247...");
            for (File file : files) {
                if (ImageManager.canBeReadAsBufferedImage(file)) {
                    try {
                        BufferedImage image = ImageIO.read(file);
                        ImageManager.drawBottom(image, bottomPng);
                    }
                    catch (IOException e) {
                        Log.error("\u8bfb\u53d6\u6587\u4ef6 " + file.getName() + " \u51fa\u9519: " + e.getMessage());
                    }
                }
                if (++currentStep % step != 0 && currentStep != totalFiles) continue;
                double percentage = (double)currentStep / (double)totalFiles * 100.0;
                Log.info(String.format("\u5904\u7406\u8fdb\u5ea6: %.2f%%", percentage));
            }
            Log.info("\u81ea\u5b9a\u4e49\u56fe\u7247\u548c\u5b57\u4f53\u52a0\u8f7d\u5b8c\u6210!");
        }
    }

    public static void view(BufferedImage image) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Image Display");
            frame.setDefaultCloseOperation(3);
            frame.setSize(image.getWidth() + 50, image.getHeight() + 50);
            JLabel label = new JLabel(new ImageIcon(image));
            frame.add((Component)label, "Center");
            frame.setVisible(true);
        });
    }

    private static void drawBottom(BufferedImage background, BufferedImage bottomPng) {
        BufferedImage canvas = new BufferedImage(1024, 576, 2);
        Graphics2D g2d = ImageUtil.getG2d(canvas);
        double scaleWidth = 1024.0 / (double)background.getWidth();
        double scaleHeight = 576.0 / (double)background.getHeight();
        double scale = Math.max(scaleWidth, scaleHeight);
        int scaledWidth = (int)((double)background.getWidth() * scale);
        int scaledHeight = (int)((double)background.getHeight() * scale);
        int x = (1024 - scaledWidth) / 2;
        int y = (576 - scaledHeight) / 2;
        g2d.drawImage(background, x, y, scaledWidth, scaledHeight, null);
        g2d.drawImage((Image)bottomPng, 0, 0, null);
        g2d.setFont(customFont);
        g2d.setColor(Color.BLACK);
        g2d.drawString("\u7b7e\u5230\u65f6\u95f4:", 70, 340);
        g2d.drawString("\u8fde\u7b7e\u6b21\u6570:", 70, 385);
        int infoY = 478;
        g2d.setFont(customFont.deriveFont(32.0f));
        g2d.drawString("\u6211\u7684\u91d1\u5e01", 118, infoY);
        g2d.drawString("\u7b7e\u5230\u83b7\u5f97", 358, infoY);
        g2d.drawString("\u6211\u7684\u94f6\u884c", 608, infoY);
        g2d.drawString("\u4eca\u65e5\u6536\u76ca", 858, infoY);
        g2d.setFont(customFont.deriveFont(12.0f));
        g2d.drawString("by Mirai & HuYanEconomy(\u58f6\u8a00\u7ecf\u6d4e) v1.4.9", 730, 573);
        g2d.dispose();
        bufferedImages.add(ImageUtil.makeRoundedCorner(canvas, 30));
    }

    public static BufferedImage getNextBottom() {
        if (bufferedImages.isEmpty()) {
            return null;
        }
        BufferedImage bufferedImage = bufferedImages.get(next++ % bufferedImages.size());
        return new BufferedImage(bufferedImage.getColorModel(), bufferedImage.copyData(null), bufferedImage.getColorModel().isAlphaPremultiplied(), null);
    }

    private static boolean canBeReadAsBufferedImage(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            return image != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Font getCustomFont() {
        return customFont;
    }
}

