/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.plugin;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.entity.TitleInfo;
import cn.chahuyun.economy.entity.UserInfo;
import cn.chahuyun.economy.entity.title.CustomTitle;
import cn.chahuyun.economy.entity.title.TitleTemplate;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TitleTemplateManager {
    private static final Logger log = LoggerFactory.getLogger((String)"HuYanEconomy");
    private static final Map<String, TitleTemplate> titleTemplateMap = new HashMap<String, TitleTemplate>(3);

    public static <T extends TitleTemplate> boolean registerTitleTemplate(T template) {
        String titleCode = template.getTemplateCode();
        if (titleTemplateMap.containsKey(titleCode)) {
            return false;
        }
        titleTemplateMap.put(titleCode, template);
        return true;
    }

    @SafeVarargs
    public static <T extends TitleTemplate> void registerTitleTemplate(T ... template) {
        for (T t : template) {
            TitleTemplateManager.registerTitleTemplate(t);
        }
    }

    public static TitleInfo createTitle(String templateCode, UserInfo userInfo) {
        if (!titleTemplateMap.containsKey(templateCode)) {
            return null;
        }
        TitleTemplate template = titleTemplateMap.get(templateCode);
        DateTime validityPeriod = null;
        if (template.getValidityPeriod() > 0) {
            validityPeriod = DateUtil.offsetDay((Date)new Date(), (int)template.getValidityPeriod());
        }
        return template.createTitleInfo(userInfo).setCode(template.getTemplateCode()).setDueTime((Date)validityPeriod);
    }

    public static List<TitleTemplate> getCanBuyTemplate() {
        return titleTemplateMap.values().stream().filter(TitleTemplate::getCanIBuy).collect(Collectors.toList());
    }

    public static TitleTemplate getTitleTemplate(String code) {
        return titleTemplateMap.get(code);
    }

    public static void loadingCustomTitle() {
        String read;
        Path path = HuYanEconomy.INSTANCE.getDataFolderPath();
        File file = path.resolve("title.json").toFile();
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    log.error("\u81ea\u5b9a\u4e49\u79f0\u53f7\u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
                    return;
                }
            }
            catch (IOException e) {
                log.error("\u81ea\u5b9a\u4e49\u79f0\u53f7\u6587\u4ef6\u521b\u5efa\u5931\u8d25!", (Throwable)e);
            }
        }
        if ((read = FileUtil.readUtf8String((File)file)).isBlank()) {
            CustomTitle titleTemplateSimple = new CustomTitle("template", -1, "\u6a21\u677f", 0.0, false, false, "[\u6a21\u677f]", "#00000", "#ffffff");
            JSONObject entries = JSONUtil.parseObj((Object)titleTemplateSimple);
            JSONArray array = new JSONArray();
            array.add((Object)entries);
            FileUtil.writeUtf8String((String)array.toStringPretty(), (File)file);
            return;
        }
        List list = JSONUtil.parseArray((String)read).toList(CustomTitle.class);
        for (CustomTitle customTitle : list) {
            if (customTitle.getTemplateCode().equals("template")) continue;
            if (customTitle.hasNullField().booleanValue()) {
                log.warn("\u81ea\u5b9a\u4e49\u79f0\u53f7\u9519\u8bef:{} ,\u6240\u6709\u5c5e\u6027\u5fc5\u586b!", (Object)customTitle.getTitleName());
                continue;
            }
            TitleTemplateManager.registerTitleTemplate(customTitle.toTemplate());
            log.debug("\u81ea\u5b9a\u4e49\u79f0\u53f7: {} \u5df2\u6ce8\u518c", (Object)customTitle.getTitleName());
        }
    }
}

