/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.utils;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.constant.Constant;
import cn.chahuyun.economy.utils.Log;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.contact.User;
import xyz.cssxsh.mirai.economy.EconomyService;
import xyz.cssxsh.mirai.economy.service.EconomyAccount;
import xyz.cssxsh.mirai.economy.service.EconomyCurrency;
import xyz.cssxsh.mirai.economy.service.GlobalEconomyContext;
import xyz.cssxsh.mirai.economy.service.IEconomyService;
import xyz.cssxsh.mirai.economy.service.UserEconomyAccount;

public class EconomyUtil {
    public static final IEconomyService economyService = EconomyService.INSTANCE;

    private EconomyUtil() {
    }

    public static void init() {
        EconomyUtil.init(Constant.CURRENCY_GOLD);
    }

    public static void init(EconomyCurrency ... currencies) {
        try {
            for (EconomyCurrency currency : currencies) {
                economyService.register(currency, false);
            }
            Log.info("\u7ecf\u6d4e\u4f53\u7cfb\u521d\u59cb\u5316\u6210\u529f!");
        }
        catch (UnsupportedOperationException e) {
            Log.error("\u7ecf\u6d4e\u4f53\u7cfb\u521d\u59cb\u5316\u5931\u8d25!", e);
        }
    }

    public static double getMoneyByUser(User user) {
        return EconomyUtil.getMoneyByUser(user, Constant.CURRENCY_GOLD);
    }

    public static double getMoneyByUser(User user, EconomyCurrency currency) {
        double d;
        block8: {
            GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
            try {
                UserEconomyAccount account = economyService.account(user);
                DecimalFormat format = new DecimalFormat("#.0");
                String str = format.format(context.get((EconomyAccount)account, currency));
                d = Double.parseDouble(str);
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u83b7\u53d6\u51fa\u9519:\u83b7\u53d6\u7528\u6237\u94b1\u5305\u4f59\u989d", e);
                    return 0.0;
                }
            }
            context.close();
        }
        return d;
    }

    public static double getMoneyByBank(User user) {
        return EconomyUtil.getMoneyByBank(user, Constant.CURRENCY_GOLD);
    }

    public static double getMoneyByBank(User user, EconomyCurrency currency) {
        double d;
        block8: {
            GlobalEconomyContext global = economyService.global();
            try {
                UserEconomyAccount account = economyService.account(user);
                DecimalFormat format = new DecimalFormat("#.0");
                String str = format.format(global.get((EconomyAccount)account, currency));
                d = Double.parseDouble(str);
                if (global == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (global != null) {
                        try {
                            global.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u83b7\u53d6\u51fa\u9519:\u83b7\u53d6\u7528\u6237\u94f6\u884c\u4f59\u989d", e);
                    return 0.0;
                }
            }
            global.close();
        }
        return d;
    }

    public static double getMoneyByBankFromId(String userId, String description) {
        return EconomyUtil.getMoneyByBankFromId(userId, description, Constant.CURRENCY_GOLD);
    }

    public static double getMoneyByBankFromId(String userId, String description, EconomyCurrency currency) {
        double d;
        block8: {
            GlobalEconomyContext global = economyService.global();
            try {
                EconomyAccount account = economyService.account(userId, description);
                DecimalFormat format = new DecimalFormat("#.0");
                String str = format.format(global.get(account, currency));
                d = Double.parseDouble(str);
                if (global == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (global != null) {
                        try {
                            global.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u83b7\u53d6\u51fa\u9519:\u83b7\u53d6\u7528\u6237\u94f6\u884c\u4f59\u989d", e);
                    return 0.0;
                }
            }
            global.close();
        }
        return d;
    }

    public static boolean turnUserToUser(User user, User toUser, double quantity) {
        return EconomyUtil.turnUserToUser(user, toUser, quantity, Constant.CURRENCY_GOLD);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean turnUserToUser(User user, User toUser, double quantity, EconomyCurrency currency) {
        try (GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);){
            UserEconomyAccount account = economyService.account(user);
            UserEconomyAccount toAccount = economyService.account(toUser);
            double userMoney = context.get((EconomyAccount)account, currency);
            if (userMoney - quantity < 0.0) {
                boolean bl2 = false;
                return bl2;
            }
            context.transaction(currency, balance -> {
                balance.put((EconomyAccount)account, balance.get((EconomyAccount)account) - quantity);
                balance.put((EconomyAccount)toAccount, balance.get((EconomyAccount)toAccount) + quantity);
                return null;
            });
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u7528\u6237->\u7528\u6237", e);
            return false;
        }
    }

    public static boolean turnUserToBank(User user, double quantity) {
        return EconomyUtil.turnUserToBank(user, quantity, Constant.CURRENCY_GOLD);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean turnUserToBank(User user, double quantity, EconomyCurrency currency) {
        try (GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);){
            boolean bl;
            block18: {
                UserEconomyAccount bankAccount;
                UserEconomyAccount account;
                GlobalEconomyContext global;
                block16: {
                    boolean bl2;
                    block17: {
                        global = economyService.global();
                        try {
                            account = economyService.account(user);
                            bankAccount = economyService.account(user);
                            double money = context.get((EconomyAccount)account, currency);
                            if (!(money - quantity < 0.0)) break block16;
                            bl2 = false;
                            if (global == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (global != null) {
                                try {
                                    global.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        global.close();
                    }
                    return bl2;
                }
                context.minusAssign((EconomyAccount)account, currency, quantity);
                global.plusAssign((EconomyAccount)bankAccount, currency, quantity);
                bl = true;
                if (global == null) break block18;
                global.close();
            }
            return bl;
        }
        catch (Exception e) {
            Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u7528\u6237->\u94f6\u884c", e);
            return false;
        }
    }

    public static boolean turnBankToUser(User user, double quantity) {
        return EconomyUtil.turnBankToUser(user, quantity, Constant.CURRENCY_GOLD);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean turnBankToUser(User user, double quantity, EconomyCurrency currency) {
        try (GlobalEconomyContext global = economyService.global();){
            boolean bl;
            block18: {
                UserEconomyAccount account;
                UserEconomyAccount bankAccount;
                GlobalEconomyContext context;
                block16: {
                    boolean bl2;
                    block17: {
                        context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
                        try {
                            bankAccount = economyService.account(user);
                            account = economyService.account(user);
                            double bankMoney = global.get((EconomyAccount)bankAccount, currency);
                            if (!(bankMoney - quantity < 0.0)) break block16;
                            bl2 = false;
                            if (context == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (context != null) {
                                try {
                                    context.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        context.close();
                    }
                    return bl2;
                }
                global.minusAssign((EconomyAccount)bankAccount, currency, quantity);
                context.plusAssign((EconomyAccount)account, currency, quantity);
                bl = true;
                if (context == null) break block18;
                context.close();
            }
            return bl;
        }
        catch (Exception e) {
            Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u94f6\u884c->\u7528\u6237", e);
            return false;
        }
    }

    public static boolean plusMoneyToUser(User user, double quantity) {
        return EconomyUtil.plusMoneyToUser(user, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean plusMoneyToUser(User user, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
            try {
                UserEconomyAccount account = economyService.account(user);
                context.plusAssign((EconomyAccount)account, currency, quantity);
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u6dfb\u52a0\u7528\u6237\u7ecf\u6d4e", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }

    public static boolean plusMoneyToBank(User user, double quantity) {
        return EconomyUtil.plusMoneyToBank(user, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean plusMoneyToBank(User user, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.global();
            try {
                UserEconomyAccount account = economyService.account(user);
                context.plusAssign((EconomyAccount)account, currency, quantity);
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u6dfb\u52a0\u7528\u6237\u7ecf\u6d4e", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }

    public static boolean minusMoneyToUser(User user, double quantity) {
        return EconomyUtil.minusMoneyToUser(user, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean minusMoneyToUser(User user, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
            try {
                UserEconomyAccount account = economyService.account(user);
                context.minusAssign((EconomyAccount)account, currency, quantity);
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u51cf\u5c11\u7528\u6237\u7ecf\u6d4e", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }

    public static boolean plusMoneyToBankForId(String userId, String description, double quantity) {
        return EconomyUtil.plusMoneyToBankForId(userId, description, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean plusMoneyToBankForId(String userId, String description, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
            try {
                EconomyAccount account = economyService.account(userId, description);
                context.plusAssign(account, currency, quantity);
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u51cf\u5c11\u7528\u6237\u7ecf\u6d4e", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }

    public static boolean plusMoneyToWalletForAccount(EconomyAccount account, double quantity) {
        return EconomyUtil.plusMoneyToWalletForAccount(account, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean plusMoneyToWalletForAccount(EconomyAccount account, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
            try {
                context.plusAssign(account, currency, quantity);
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u51cf\u5c11\u7528\u6237\u7ecf\u6d4e", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }

    public static boolean plusMoneyToBankForAccount(EconomyAccount account, double quantity) {
        return EconomyUtil.plusMoneyToBankForAccount(account, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean plusMoneyToBankForAccount(EconomyAccount account, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.global();
            try {
                context.plusAssign(account, currency, quantity);
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u51cf\u5c11\u7528\u6237\u7ecf\u6d4e", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }

    public static Map<EconomyAccount, Double> getAccountByBank() {
        return EconomyUtil.getAccountByBank(Constant.CURRENCY_GOLD);
    }

    public static Map<EconomyAccount, Double> getAccountByBank(EconomyCurrency economyCurrency) {
        Map map;
        block8: {
            GlobalEconomyContext global = economyService.global();
            try {
                map = global.balance(economyCurrency);
                if (global == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (global != null) {
                        try {
                            global.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u83b7\u53d6\u51fa\u9519:\u83b7\u53d6\u94f6\u884c\u5bf9\u5e94\u8d27\u5e01\u7684\u6240\u6709\u7ecf\u6d4e\u4fe1\u606f", e);
                    return new HashMap<EconomyAccount, Double>();
                }
            }
            global.close();
        }
        return map;
    }

    public static boolean Cheat(User user, double quantity) {
        return EconomyUtil.Cheat(user, quantity, Constant.CURRENCY_GOLD);
    }

    public static boolean Cheat(User user, double quantity, EconomyCurrency currency) {
        boolean bl;
        block8: {
            GlobalEconomyContext context = economyService.custom((CoroutineScope)HuYanEconomy.INSTANCE);
            try {
                UserEconomyAccount account = economyService.account(user);
                context.transaction(currency, balance -> {
                    balance.put((EconomyAccount)account, balance.get((EconomyAccount)account) + quantity);
                    return null;
                });
                bl = true;
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error("\u7ecf\u6d4e\u8f6c\u79fb\u51fa\u9519:\u7528\u6237", e);
                    return false;
                }
            }
            context.close();
        }
        return bl;
    }
}

