/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.utils;

import cn.chahuyun.economy.HuYanEconomy;
import cn.chahuyun.economy.config.EconomyConfig;
import cn.chahuyun.hibernateplus.Configuration;
import cn.chahuyun.hibernateplus.DriveType;
import cn.chahuyun.hibernateplus.HibernatePlusService;
import java.nio.file.Path;

public class HibernateUtil {
    private HibernateUtil() {
    }

    public static void init(HuYanEconomy economy) {
        EconomyConfig config = HuYanEconomy.config;
        Configuration configuration = HibernatePlusService.createConfiguration(((Object)((Object)economy)).getClass());
        configuration.setPackageName("cn.chahuyun.economy.entity");
        DriveType dataType = config.getDataType();
        configuration.setDriveType(dataType);
        Path dataFolderPath = economy.getDataFolderPath();
        switch (dataType) {
            case MYSQL: {
                configuration.setAddress(config.getMysqlUrl());
                configuration.setUser(config.getMysqlUser());
                configuration.setPassword(config.getMysqlPassword());
                break;
            }
            case H2: {
                configuration.setAddress(dataFolderPath.resolve("HuYanEconomy.h2").toString());
                break;
            }
            case SQLITE: {
                configuration.setAddress(dataFolderPath.resolve("HuYanEconomy").toString());
            }
        }
        HibernatePlusService.loadingService((Configuration)configuration);
    }
}

