/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.economy.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        output = g2.getDeviceConfiguration().createCompatibleImage(w, h, 3);
        g2.dispose();
        g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fillRoundRect(0, 0, w, h, cornerRadius, cornerRadius);
        g2.setComposite(AlphaComposite.SrcIn);
        g2.drawImage(image, 0, 0, w, h, null);
        g2.dispose();
        return output;
    }

    public static void drawString(String text, int x, int y, int maxWidth, Graphics2D g2d) {
        float areaX = x;
        float areaY = y;
        int max = x + maxWidth;
        FontRenderContext frc = g2d.getFontRenderContext();
        Font font = g2d.getFont();
        for (String line : text.split("\n")) {
            TextLayout layout = new TextLayout(line, font, frc);
            Rectangle2D bounds = layout.getBounds();
            if (bounds.getWidth() > (double)maxWidth) {
                for (char word : line.toCharArray()) {
                    TextLayout wordLayout = new TextLayout(String.valueOf(word), font, frc);
                    Rectangle2D wordBounds = wordLayout.getBounds();
                    if ((double)areaX + wordBounds.getWidth() > (double)max) {
                        areaX = x;
                        areaY += (float)bounds.getHeight();
                    }
                    wordLayout.draw(g2d, areaX, areaY);
                    areaX += (float)wordBounds.getWidth() + 4.0f;
                }
            } else {
                layout.draw(g2d, areaX, areaY);
                areaY += (float)bounds.getHeight();
            }
            areaX = x;
        }
    }

    public static void drawStringGradient(String text, int x, int y, Color sColor, Color eColor, Graphics2D g2d) {
        FontRenderContext frc = g2d.getFontRenderContext();
        float textWidth = (float)g2d.getFont().getStringBounds(text, frc).getWidth();
        GradientPaint gradient = new GradientPaint(x, y, sColor, (float)x + textWidth, y, eColor);
        g2d.setPaint(gradient);
        g2d.drawString(text, x, y);
    }

    public static Graphics2D getG2d(BufferedImage bufferedImage) {
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2d;
    }

    public static Color hexColor(String color) {
        if (color != null && !color.isEmpty()) {
            String string = color.length() == 7 ? color.substring(1) : color;
            Integer r = Integer.valueOf(string.substring(0, 2), 16);
            Integer g = Integer.valueOf(string.substring(2, 4), 16);
            Integer b = Integer.valueOf(string.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        throw new IllegalArgumentException("\u6784\u5efa\u989c\u8272\u9519\u8bef!");
    }

    public static String colorHex(Color color) {
        Object red = Integer.toHexString(color.getRed());
        Object green = Integer.toHexString(color.getGreen());
        Object blue = Integer.toHexString(color.getBlue());
        if (((String)red).length() == 1) {
            red = "0" + (String)red;
        }
        if (((String)green).length() == 1) {
            green = "0" + (String)green;
        }
        if (((String)blue).length() == 1) {
            blue = "0" + (String)blue;
        }
        return (String)red + (String)green + (String)blue;
    }
}

