/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.snowflake;

import java.util.Date;
import java.util.UUID;

public class IdGenerator {
    private static IdGenerator instance = new IdGenerator(0L);
    private static final long MACHINE_BIT = 5L;
    private static final long SEQUENCE_BIT = 8L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 255L;
    private static final long MACHINE_LEFT = 8L;
    private static final long TIMESTMP_LEFT = 13L;
    private long machineId;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public static IdGenerator initDefaultInstance(int machineId) {
        instance = new IdGenerator(machineId);
        return instance;
    }

    public static IdGenerator getInstance() {
        return instance;
    }

    public static long generateId() {
        return instance.nextId();
    }

    private IdGenerator(long machineId) {
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than 31 or less than 0");
        }
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getTimestamp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextTimestamp();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp << 13 | this.machineId << 8 | this.sequence;
    }

    private long getNextTimestamp() {
        long mill = this.getTimestamp();
        while (mill <= this.lastStmp) {
            mill = this.getTimestamp();
        }
        return mill;
    }

    private long getTimestamp() {
        return System.currentTimeMillis() / 10L;
    }

    public static Date parseIdTimestamp(long id) {
        return new Date((id >>> 13) * 10L);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

