/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.interceptor;

import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class CnaWorldInnerInterceptor
implements Interceptor {
    private static final Map<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameterObject = args[1];
        if (SqlCommandType.UPDATE == ms.getSqlCommandType()) {
            TableFieldInfo versionField;
            String msId = ms.getId();
            Class entityClass = ENTITY_CLASS_CACHE.get(msId);
            if (null == entityClass) {
                try {
                    String className = msId.substring(0, msId.lastIndexOf(46));
                    entityClass = ReflectionKit.getSuperClassGenericType(Class.forName(className), Mapper.class, (int)0);
                    ENTITY_CLASS_CACHE.put(msId, entityClass);
                }
                catch (ClassNotFoundException var11) {
                    throw ExceptionUtils.mpe((Throwable)var11);
                }
            }
            if (null == (versionField = this.getVersionFieldInfo(entityClass))) {
                return invocation.proceed();
            }
            String versionColumn = versionField.getColumn();
            Class propertyType = versionField.getPropertyType();
            BoundSql boundSql = ms.getBoundSql(parameterObject);
            String sql = boundSql.getSql();
            if (sql.contains(versionColumn + "=?")) {
                return invocation.proceed();
            }
            String replaceStr = this.getUpdatedVersionVal(propertyType, versionColumn);
            sql = sql.replace("SET", replaceStr);
            this.resetSql2Invocation(invocation, sql);
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    private void resetSql2Invocation(Invocation invocation, String sql) {
        Object[] args = invocation.getArgs();
        MappedStatement statement = (MappedStatement)args[0];
        Object parameterObject = args[1];
        BoundSql boundSql = statement.getBoundSql(parameterObject);
        MappedStatement newStatement = this.newMappedStatement(statement, new BoundSqlSqlSource(boundSql));
        MetaObject msObject = MetaObject.forObject((Object)newStatement, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        msObject.setValue("sqlSource.boundSql.sql", (Object)sql);
        args[0] = newStatement;
    }

    private MappedStatement newMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    protected TableFieldInfo getVersionFieldInfo(Class<?> entityClazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClazz);
        return null != tableInfo && tableInfo.isWithVersion() ? tableInfo.getVersionFieldInfo() : null;
    }

    protected String getUpdatedVersionVal(Class<?> clazz, String versionColumn) {
        StringBuffer replaceStrBuf = new StringBuffer("SET ");
        replaceStrBuf.append(versionColumn).append("=");
        if (!Long.TYPE.equals(clazz) && !Long.class.equals(clazz)) {
            if (!Integer.TYPE.equals(clazz) && !Integer.class.equals(clazz)) {
                replaceStrBuf.append("'");
                if (Date.class.equals(clazz)) {
                    replaceStrBuf.append(new Date());
                } else if (Timestamp.class.equals(clazz)) {
                    replaceStrBuf.append(new Timestamp(System.currentTimeMillis()));
                } else {
                    replaceStrBuf.append(LocalDateTime.now());
                }
                replaceStrBuf.append("',");
            } else {
                replaceStrBuf.append(versionColumn).append("+1").append(",");
            }
        } else {
            replaceStrBuf.append(versionColumn).append("+1").append(",");
        }
        return replaceStrBuf.toString();
    }

    static class BoundSqlSqlSource
    implements SqlSource {
        private final BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

