/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.config;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.handler.CustomizedMetaObjectHandler;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.injector.CustomizedSqlInjector;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.interceptor.CnaWorldInnerInterceptor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.snowflake.CustomerIdGenerator;
import cn.cnaworld.framework.infrastructure.utils.CnaLogUtil;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;

@ConditionalOnExpression(value="#{environment['cnaworld.mybatis-plus.enabled'] ==null || !environment['cnaworld.mybatis-plus.enabled'].contains('false')}")
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);

    @Bean
    @ConditionalOnExpression(value="#{environment['cnaworld.mybatis-plus.function-extension'] ==null || !environment['cnaworld.mybatis-plus.function-extension'].contains('false')}")
    public CustomizedSqlInjector customizedSqlInjector() {
        CnaLogUtil.info((Logger)log, (String)"cnaworld mybatis-plus extend method initialized \uff01", (Object[])new Object[0]);
        return new CustomizedSqlInjector();
    }

    @Bean
    @ConditionalOnExpression(value="#{environment['cnaworld.mybatis-plus.optimistic-locker'] ==null || !environment['cnaworld.mybatis-plus.optimistic-locker'].contains('false')}")
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor(true));
        CnaLogUtil.info((Logger)log, (String)"cnaworld mybatis-plus optimistic-locker initialized \uff01", (Object[])new Object[0]);
        return mybatisPlusInterceptor;
    }

    @Bean
    @ConditionalOnExpression(value="#{environment['cnaworld.mybatis-plus.snow-flake'] ==null || !environment['cnaworld.mybatis-plus.snow-flake'].contains('false')}")
    public CustomerIdGenerator customerIdGenerator() {
        CnaLogUtil.info((Logger)log, (String)"cnaworld mybatis-plus 16-snowflake initialized \uff01", (Object[])new Object[0]);
        return new CustomerIdGenerator();
    }

    @Bean
    @ConditionalOnExpression(value="#{environment['cnaworld.mybatis-plus.auto-insert-fill'] == null || !environment['cnaworld.mybatis-plus.auto-insert-fill'].contains('false')}")
    public CustomizedMetaObjectHandler customizedMetaObjectHandler() {
        CnaLogUtil.info((Logger)log, (String)"cnaworld mybatis-plus auto-insert-fill initialized \uff01", (Object[])new Object[0]);
        return new CustomizedMetaObjectHandler();
    }

    @Bean
    @ConditionalOnExpression(value="#{environment['cnaworld.mybatis-plus.update-optimistic-locker-field'] ==null || !environment['cnaworld.mybatis-plus.update-optimistic-locker-field'].contains('false')}")
    public CnaWorldInnerInterceptor cnaWorldInnerInterceptor() {
        CnaLogUtil.info((Logger)log, (String)"cnaworld mybatis-plus update-optimistic-locker-field initialized \uff01", (Object[])new Object[0]);
        return new CnaWorldInnerInterceptor();
    }
}

